/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.miop.FragmentedMessage;
import org.jacorb.orb.miop.MIOPConnection;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.miop.MulticastUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;
import org.omg.ETF.Profile;
import org.omg.MIOP.PacketHeader_1_0;
import org.omg.MIOP.UniqueIdHelper;

public class ServerMIOPConnection
extends MIOPConnection
implements Runnable {
    private MulticastSocket socket = null;
    private Thread groupListener = null;
    private LinkedList fullMessages = new LinkedList();
    private HashMap incompleteMessages = null;
    private byte[] current = null;
    private int currentPos = 0;
    private int socketTimeout;
    private int timeToLive;
    private int incompleteMessagesThreshold;
    private int packetMaxSize;

    public ServerMIOPConnection() {
        this.groupListener = new Thread(this);
        this.groupListener.setDaemon(true);
    }

    public void connect(Profile profile, long time_out) {
        if (!this.is_connected()) {
            if (!(profile instanceof MIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an MIOP connection to a non-MIOP profile: " + profile.getClass());
            }
            this.profile = (MIOPProfile)profile;
            try {
                this.socket = new MulticastSocket(((MIOPProfile)profile).getUIPMCProfile().the_port);
                this.socket.setSoTimeout(this.socketTimeout);
                this.socket.setTimeToLive(this.timeToLive);
                this.socket.joinGroup(((MIOPProfile)profile).getGroupInetAddress());
                this.connection_info = this.socket.toString();
            }
            catch (Exception e2) {
                if (this.socket != null) {
                    this.socket.close();
                }
                throw new RuntimeException("Can't create multicast socket: " + profile);
            }
            this.connected = true;
            this.groupListener.start();
        }
    }

    public boolean is_data_available() {
        return this.current != null && this.currentPos < this.current.length || !this.fullMessages.isEmpty();
    }

    public synchronized boolean wait_next_data(long timeout) {
        if (this.fullMessages.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.current = (byte[])this.fullMessages.removeFirst();
        this.currentPos = 0;
        return true;
    }

    public synchronized void read(BufferHolder buffer, int offset, int minLength, int maxLength, long timeout) {
        if (this.current == null) {
            this.wait_next_data(0L);
        }
        int writen = 0;
        do {
            int toRead = Math.min(this.current.length - this.currentPos, maxLength);
            System.arraycopy(this.current, this.currentPos, buffer.value, offset + writen, toRead);
            writen += toRead;
            this.currentPos += toRead;
            if (this.currentPos == this.current.length) {
                this.current = null;
            }
            if (this.current != null || writen >= minLength) continue;
            this.wait_next_data(0L);
        } while (writen < minLength);
    }

    public synchronized void close() {
        block8: {
            block7: {
                if (!this.connected) {
                    return;
                }
                try {
                    this.socket.leaveGroup(((MIOPProfile)this.profile).getGroupInetAddress());
                }
                catch (IOException ex) {
                    if (!this.logger.isDebugEnabled()) break block7;
                    this.logger.debug("Exception when closing the socket", ex);
                }
            }
            try {
                this.socket.close();
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
            }
            catch (IOException ex) {
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.debug("Exception when closing the socket", ex);
            }
        }
        this.connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.incompleteMessages == null) {
            this.incompleteMessages = new HashMap();
        }
        byte[] buffer = new byte[this.packetMaxSize];
        while (this.connected) {
            try {
                if (this.incompleteMessages.size() > this.incompleteMessagesThreshold) {
                    this.dropIncompleteMessages();
                }
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                try {
                    this.socket.receive(packet);
                }
                catch (SocketTimeoutException ste) {
                    continue;
                }
                catch (InterruptedIOException e2) {
                    throw new TRANSIENT("Interrupted I/O: " + e2);
                }
                catch (IOException se) {
                    throw this.to_COMM_FAILURE(se);
                }
                CDRInputStream in = new CDRInputStream(this.configuration.getORB(), packet.getData());
                PacketHeader_1_0 header = new PacketHeader_1_0();
                header.magic = new char[4];
                in.read_char_array(header.magic, 0, 4);
                if (!MulticastUtil.matchMIOPMagic(header.magic)) continue;
                header.hdr_version = in.read_octet();
                header.flags = in.read_octet();
                in.setLittleEndian((1 & header.flags) != 0);
                header.packet_length = in.read_ushort();
                header.packet_number = in.read_ulong();
                header.number_of_packets = in.read_ulong();
                header.Id = UniqueIdHelper.read(in);
                int pos = in.get_pos();
                int header_padding = 8 - pos % 8;
                header_padding = header_padding == 8 ? 0 : header_padding;
                in.skip(header_padding);
                int packet_length = header.packet_length > 0 ? header.packet_length : Short.MAX_VALUE - header.packet_length;
                byte[] data = new byte[packet_length];
                if (in.available() < data.length) {
                    throw new MARSHAL("Impossible length in MIOP header. Header denotes length of " + packet_length + " but only " + in.available() + " is available.");
                }
                in.read_octet_array(data, 0, packet_length);
                String messageId = new String(header.Id);
                FragmentedMessage message = (FragmentedMessage)this.incompleteMessages.get(messageId);
                if (message == null) {
                    message = new FragmentedMessage();
                    try {
                        message.configure(this.configuration);
                    }
                    catch (ConfigurationException e3) {
                        this.logger.error("couldn't create a Fragmented message", e3);
                        throw new IllegalArgumentException("wrong configuration: " + e3);
                    }
                    this.incompleteMessages.put(messageId, message);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Received message number " + (header.packet_number + 1) + " out of " + header.number_of_packets + " and adding fragment of size " + data.length);
                }
                message.addFragment(header, data);
                if (!message.isComplete()) continue;
                ServerMIOPConnection serverMIOPConnection = this;
                synchronized (serverMIOPConnection) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Message is completed");
                    }
                    this.incompleteMessages.remove(messageId);
                    this.fullMessages.addLast(message.buildMessage());
                    this.notifyAll();
                }
            }
            catch (COMM_FAILURE e4) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Transport to " + this.connection_info + ": stream closed " + e4.getMessage());
                }
                if (!this.connected) continue;
                this.close();
            }
            catch (SystemException e5) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("ServerMIOPConnection caught exception.", e5);
            }
            catch (Throwable e6) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error("ServerMIOPConnection caught exception.", e6);
            }
        }
    }

    private final synchronized void dropIncompleteMessages() {
        Iterator ids = this.incompleteMessages.keySet().iterator();
        while (ids.hasNext()) {
            Object id = ids.next();
            if (!((FragmentedMessage)this.incompleteMessages.get(id)).canBeDiscarded()) continue;
            this.incompleteMessages.remove(id);
        }
    }

    protected int getTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException se) {
            throw this.to_COMM_FAILURE(se);
        }
    }

    protected void setTimeout(int timeout) {
        block4: {
            if (this.socket != null) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Socket timeout set to " + timeout + " ms");
                    }
                    this.socket.setSoTimeout(timeout);
                }
                catch (SocketException se) {
                    if (!this.logger.isInfoEnabled()) break block4;
                    this.logger.info("SocketException", se);
                }
            }
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.socketTimeout = config.getAttributeAsInteger("jacorb.miop.timeout", 100);
        this.timeToLive = config.getAttributeAsInteger("jacorb.miop.time_to_live", 5);
        this.incompleteMessagesThreshold = config.getAttributeAsInteger("jacorb.miop.incomplete_messages_threshold", 5);
        this.packetMaxSize = config.getAttributeAsInteger("jacorb.miop.packet_max_size", 1500);
    }
}

