/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;

public abstract class RequestInfoImpl
extends LocalObject
implements RequestInfo {
    protected int request_id;
    protected String operation;
    protected Parameter[] arguments = null;
    protected TypeCode[] exceptions = null;
    protected Any result = null;
    protected boolean response_expected;
    protected Object forward_reference = null;
    protected short reply_status;
    protected Current current = null;
    protected short sync_scope;
    protected final Map request_ctx;
    protected final Map reply_ctx;
    protected short caller_op = (short)-1;

    public RequestInfoImpl() {
        this.request_ctx = new HashMap();
        this.reply_ctx = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestServiceContexts(ServiceContext[] ctx) {
        Map map = this.request_ctx;
        synchronized (map) {
            for (int i2 = 0; i2 < ctx.length; ++i2) {
                this.request_ctx.put(ObjectUtil.newInteger(ctx[i2].context_id), ctx[i2]);
            }
        }
    }

    public ServiceContext[] getRequestServiceContextsArray() {
        ServiceContext[] ctxts = new ServiceContext[this.request_ctx.size()];
        Iterator iter = this.request_ctx.values().iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            ctxts[i2] = (ServiceContext)iter.next();
            ++i2;
        }
        return ctxts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplyServiceContexts(ServiceContext[] ctx) {
        Map map = this.reply_ctx;
        synchronized (map) {
            for (int i2 = 0; i2 < ctx.length; ++i2) {
                this.reply_ctx.put(ObjectUtil.newInteger(ctx[i2].context_id), ctx[i2]);
            }
        }
    }

    public ServiceContext[] getReplyServiceContextsArray() {
        ServiceContext[] ctxts = new ServiceContext[this.reply_ctx.size()];
        Iterator iter = this.reply_ctx.values().iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            ctxts[i2] = (ServiceContext)iter.next();
            ++i2;
        }
        return ctxts;
    }

    public void setArguments(Parameter[] args) {
        this.arguments = args;
    }

    public void setResult(Any result) {
        this.result = result;
    }

    public Current current() {
        return this.current;
    }

    public void setCurrent(Current current) {
        this.current = current;
    }

    public void setReplyStatus(short reply_status) {
        this.reply_status = reply_status;
    }

    public void setForwardReference(Object forward_reference) {
        this.forward_reference = forward_reference;
    }

    public Parameter[] arguments() {
        return this.arguments;
    }

    public String[] contexts() {
        throw new NO_RESOURCES("JacORB does not support operation contexts", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    public TypeCode[] exceptions() {
        return this.exceptions;
    }

    public Object forward_reference() {
        return this.forward_reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContext get_reply_service_context(int id) {
        ServiceContext result;
        Map map = this.reply_ctx;
        synchronized (map) {
            result = (ServiceContext)this.reply_ctx.get(ObjectUtil.newInteger(id));
        }
        if (result == null) {
            throw new BAD_PARAM("No ServiceContext with id " + id, 23, CompletionStatus.COMPLETED_MAYBE);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContext get_request_service_context(int id) {
        ServiceContext result;
        Map map = this.request_ctx;
        synchronized (map) {
            result = (ServiceContext)this.request_ctx.get(ObjectUtil.newInteger(id));
        }
        if (result == null) {
            throw new BAD_PARAM("No ServiceContext with id " + id, 23, CompletionStatus.COMPLETED_MAYBE);
        }
        return result;
    }

    public Any get_slot(int id) throws InvalidSlot {
        return this.current.get_slot(id);
    }

    public String operation() {
        return this.operation;
    }

    public String[] operation_context() {
        throw new NO_RESOURCES("JacORB does not support operation contexts", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    public short reply_status() {
        return this.reply_status;
    }

    public int request_id() {
        return this.request_id;
    }

    public boolean response_expected() {
        return this.response_expected;
    }

    public Any result() {
        if (this.result == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.result;
    }

    public short sync_scope() {
        return this.sync_scope;
    }
}

