/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.cvhelper;

import se.ericsson.cello.configurationversion.main.exception.ActionNotAllowedException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.mom.ConfigurationVersion;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.pnp.cvhelper.CvHelper;
import se.ericsson.crbs.omf.mao.pnp.proxy.PnpContext;

public class CvHelperImpl
implements CvHelper {
    private static final Class THIS_CLASS = CvHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CV_NAME_PREFIX = "selfconfig_autocreated";
    private final PnpContext pnpContext;

    public CvHelperImpl(PnpContext inputPnpContext) {
        logger.traceEnter(THIS_CLASS, "CvHelperImpl()");
        this.pnpContext = inputPnpContext;
        logger.traceReturn(THIS_CLASS, "CvHelperImpl()");
    }

    public void createCv() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createCv()");
        Coordinator coordinator = null;
        String cvName = this.getNextAvailableCVName(coordinator);
        ConfigurationVersion cvMo = this.getCvMo();
        cvMo.actionCreate(cvName, cvName, 0, "Selfconfig", "Autocreated by System", coordinator);
        cvMo.actionSetStartable(cvName, coordinator);
        logger.traceReturn(THIS_CLASS, "createCv(Created CV [" + cvName + "])");
    }

    private String getNextAvailableCVName(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getNextAvailableCVName()");
        String availableCv = "";
        for (int i = 1; i <= 3; ++i) {
            String cvName = CV_NAME_PREFIX + i;
            this.deleteUnusedCv(cvName, coordinator);
            if (!"".equals(availableCv) || !this.isCvNameAvailable(cvName, coordinator)) continue;
            availableCv = cvName;
        }
        if ("".equals(availableCv)) {
            throw new ActionNotAllowedException("No available CV names found.");
        }
        logger.traceReturn(THIS_CLASS, "getNextAvailableCVName(Available CV [" + availableCv + "])");
        return availableCv;
    }

    private void deleteUnusedCv(String cvName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteUnusedCv(cvName [" + cvName + "])");
        ConfigurationVersion cvMo = this.getCvMo();
        Struct[] storedConfigurationVersions = cvMo.getStoredConfigurationVersions(coordinator);
        String loadedCv = cvMo.getCurrentLoadedConfigurationVersion(coordinator);
        String executingCv = cvMo.getExecutingCv(coordinator);
        String startableCv = cvMo.getStartableConfigurationVersion(coordinator);
        boolean isCvInUse = cvName.equals(loadedCv) || cvName.equals(executingCv) || cvName.equals(startableCv);
        boolean cvExist = false;
        if (storedConfigurationVersions != null) {
            for (int i = 0; i < storedConfigurationVersions.length; ++i) {
                String storedCvName = (String)storedConfigurationVersions[i].getValue("name");
                if (!cvName.equals(storedCvName)) continue;
                cvExist = true;
                break;
            }
        }
        if (cvExist) {
            this.removeCvFromRollbackList(cvMo, cvName, coordinator);
            if (!isCvInUse) {
                logger.traceDebug(THIS_CLASS, "CV exist and is unused, delete CV [" + cvName + "]");
                cvMo.actionDelete(cvName, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteUnusedCv()");
    }

    private void removeCvFromRollbackList(ConfigurationVersion cvMo, String cvName, Coordinator coordinator) throws MoAccessException {
        String[] rollBackListCvs = cvMo.getRollbackList(coordinator);
        for (int i = 0; i < rollBackListCvs.length; ++i) {
            if (!cvName.equals(rollBackListCvs[i])) continue;
            cvMo.actionRemoveFromRollbackList(cvName, coordinator);
        }
    }

    private boolean isCvNameAvailable(String cvName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "isCvNameAvailable(cvName [" + cvName + "])");
        ConfigurationVersion cvMo = this.getCvMo();
        Struct[] storedConfigurationVersions = cvMo.getStoredConfigurationVersions(coordinator);
        boolean returnValue = true;
        if (storedConfigurationVersions != null) {
            for (int i = 0; i < storedConfigurationVersions.length; ++i) {
                String storedCvName = (String)storedConfigurationVersions[i].getValue("name");
                if (!storedCvName.equals(cvName)) continue;
                returnValue = false;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "isCvNameAvailable(CV [" + cvName + "] is available [" + returnValue + "])");
        return returnValue;
    }

    private ConfigurationVersion getCvMo() {
        ConfigurationVersion cvMo = null;
        MoIterator cvMoIterator = this.pnpContext.getMoRepositoryWrapper().lookupType("ConfigurationVersion");
        if (cvMoIterator.hasMoreElements()) {
            cvMo = (ConfigurationVersion)cvMoIterator.nextMo();
        }
        return cvMo;
    }
}

