/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.common;

import se.ericsson.cello.aueframework.common.InvalidCXCStringException;

public class ProductNumber {
    private String cxc;
    private int numericalPart;

    public ProductNumber(String string) throws InvalidCXCStringException {
        this.cxc = string;
        this.extractNumericalPart();
    }

    public String toString() {
        return this.cxc;
    }

    public int getNumericalPart() {
        return this.numericalPart;
    }

    private void extractNumericalPart() throws InvalidCXCStringException {
        if (this.cxc == null) {
            this.fail(this.cxc);
        }
        if (!this.cxc.startsWith("CXC")) {
            this.fail(this.cxc);
        }
        try {
            this.numericalPart = Integer.parseInt(this.cxc.substring(3, 10));
        }
        catch (Exception exception) {
            this.fail(this.cxc);
        }
    }

    private void fail(String string) throws InvalidCXCStringException {
        throw new InvalidCXCStringException(string);
    }
}

