/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.xml;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.ConversionActionListener;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.LayerException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.xml.ModificationXmlHandler;
import se.ericsson.crbs.omf.aue.common.xml.MomInfo;

public class AbstractModificationXmlHandler
extends DefaultHandler
implements ModificationXmlHandler {
    private static final Class THIS_CLASS = AbstractModificationXmlHandler.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    protected String moName;
    protected String tablePrefix = "";
    protected MomInfo fromMomInfo;
    protected MomInfo toMomInfo;
    protected String moActionName = "";
    protected final Map moActionArgsMap = new HashMap();
    private final List conversionActionListenerList = new ArrayList();
    protected AueContext aueContext;

    public void addMoConversionActionsCollectedListener(ConversionActionListener listener) {
        if (!this.conversionActionListenerList.contains(listener)) {
            this.conversionActionListenerList.add(listener);
        }
    }

    public void removeMoConversionActionsCollectedListener(ConversionActionListener listener) {
        logger.traceEnter(THIS_CLASS, "removeMoConversionActionsCollectedListener()");
        if (listener != null) {
            this.conversionActionListenerList.remove(listener);
        }
        logger.traceReturn(THIS_CLASS, "removeMoConversionActionsCollectedListener()");
    }

    public void setConverterContext(AueContext context) {
        this.aueContext = context;
    }

    protected void notifyConversionActionListeners(String localMoName, List moActionList) throws SAXException {
        logger.traceEnter(THIS_CLASS, "notifyConversionActionListeners(" + localMoName + ", " + moActionList + ")");
        try {
            Iterator iter = this.conversionActionListenerList.iterator();
            while (iter.hasNext()) {
                ConversionActionListener listener = (ConversionActionListener)iter.next();
                listener.moConversionActionsCollected(localMoName, moActionList);
            }
        }
        catch (CrbsAueException ae) {
            throw new SAXException("Conversion failed");
        }
        logger.traceReturn(THIS_CLASS, "notifyConversionActionListeners(" + localMoName + ", " + moActionList + ")");
    }

    protected MomInfo getMomInfo(String attrName, Attributes attributes) throws SAXException {
        logger.traceEnter(THIS_CLASS, "getMomInfo(" + attrName + " ...)");
        try {
            MomInfo momInfo = MomInfo.getMomInfo(attributes.getValue(attrName));
            logger.traceReturn(THIS_CLASS, "getMomInfo(" + attrName + ", " + momInfo + ")");
            return momInfo;
        }
        catch (ParseException pe) {
            throw new SAXException(pe.getMessage());
        }
    }

    protected String getMoActionName(Attributes attributes, String requiredLayer) throws SAXException, LayerException {
        logger.traceEnter(THIS_CLASS, "getMoActionName(" + requiredLayer + ")");
        String localMoActionName = null;
        String layer = attributes.getValue("layer");
        if (layer != null && !requiredLayer.equalsIgnoreCase(layer)) {
            throw new LayerException("Wrong layer. Asking for: " + requiredLayer + ", but found: " + layer);
        }
        localMoActionName = attributes.getValue("name");
        if (localMoActionName == null || localMoActionName.length() <= 0) {
            throw new SAXException("No name attribute found for MoAction for Mo " + this.moName);
        }
        logger.traceReturn(THIS_CLASS, "getMoActionName(" + localMoActionName + ", " + requiredLayer + ")");
        return localMoActionName;
    }

    protected String getMoName(Attributes attributes) throws SAXException {
        logger.traceEnter(THIS_CLASS, "getMoName(attributes.length=" + attributes.getLength() + ")");
        String localMoName = attributes.getValue("name");
        if (localMoName == null || localMoName.length() <= 0) {
            throw new SAXException("No name attribute found for Mo");
        }
        logger.traceReturn(THIS_CLASS, "getMoName(" + localMoName + ")");
        return localMoName;
    }

    protected String getTablePrefix(Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getTablePrefix(attributes.length=" + attributes.getLength() + ")");
        String localTablePrefix = "";
        try {
            localTablePrefix = attributes.getValue("tablePrefix");
            if (localTablePrefix == null || localTablePrefix.length() <= 0) {
                localTablePrefix = "";
            }
        }
        catch (Exception e) {
            localTablePrefix = "";
        }
        logger.traceReturn(THIS_CLASS, "getTablePrefix(" + localTablePrefix + ")");
        return localTablePrefix;
    }

    protected NameValue getNameAndValue(Attributes attributes) throws SAXException {
        logger.traceEnter(THIS_CLASS, "getNameAndValue(attributes.length=" + attributes.getLength() + ")");
        String name = attributes.getValue("name");
        String value = attributes.getValue("value");
        if (name == null || name.length() <= 0 || value == null) {
            throw new SAXException("No name and/or value attribute found for Arg in Mo " + this.moName + ", MoAction " + this.moActionName);
        }
        NameValue nameValue = new NameValue(name, value);
        logger.traceReturn(THIS_CLASS, "getNameAndValue(" + nameValue + ")");
        return nameValue;
    }

    protected class NameValue {
        public final String name;
        public final String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = "type".equalsIgnoreCase(name) ? ("array".equalsIgnoreCase(value) || "moref".equalsIgnoreCase(value) || "struct".equalsIgnoreCase(value) ? value.toLowerCase(Locale.getDefault()) : value.toUpperCase(Locale.getDefault())) : value;
        }

        public String toString() {
            return "Name: " + this.name + ", Value: " + this.value;
        }
    }
}

