/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.ConversionAction;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public abstract class AbstractConversionAction
implements ConversionAction {
    private final AbstractLogger logger;
    protected final Map paramMap = new HashMap();

    public AbstractConversionAction() {
        this.logger = LoggingService.getLogger(this.getClass().getName());
    }

    public void setMoActionArgs(Map moActionArgsMap) {
        this.paramMap.clear();
        this.paramMap.putAll(moActionArgsMap);
    }

    protected int getNextAvailableFroId(Object[] froIdColumnDatas) {
        int froId = 0;
        for (int row = 0; row < froIdColumnDatas.length; ++row) {
            try {
                int currId = Integer.parseInt(froIdColumnDatas[row].toString());
                if (currId < froId) continue;
                froId = currId + 1;
                continue;
            }
            catch (NumberFormatException e) {
                this.logger.traceAbnormal(this.getClass(), e.getMessage());
            }
        }
        return froId;
    }

    public abstract void convert(AueContext var1) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException;

    protected String getAndCheckParamMapString(String key, Map localParamMap, String errorMsg) throws CrbsAueException {
        String keyValue = (String)localParamMap.get(key);
        if (keyValue == null || keyValue.equals("")) {
            throw new CrbsAueException(errorMsg);
        }
        return keyValue;
    }

    protected String getWithoutCheckParamMapString(String key, Map localParamMap) {
        return (String)localParamMap.get(key);
    }

    protected String map2String(Map map) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            String name = (String)iter.next();
            buf.append(name).append('=').append(map.get(name));
        }
        return buf.toString();
    }

    protected String getParentLdn(String ldn) throws CrbsAueException {
        int lastIndex = ldn.lastIndexOf(44);
        if (lastIndex == -1) {
            throw new CrbsAueException("No parent found for LDN: " + AueUtil.doubleQuote(ldn));
        }
        String parentLdn = ldn.substring(0, lastIndex);
        return parentLdn;
    }

    protected String getFroTypeFromLdn(String ldn) throws CrbsAueException {
        int fromIndex = ldn.lastIndexOf(44);
        int toIndex = ldn.lastIndexOf(61);
        fromIndex = fromIndex == -1 ? 0 : ++fromIndex;
        if (toIndex == -1) {
            throw new CrbsAueException("No FroTypeName found for LDN: " + AueUtil.doubleQuote(ldn));
        }
        String froTypeName = ldn.substring(fromIndex, toIndex);
        return froTypeName;
    }
}

