/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.io.StringReader;
import java.util.AbstractList;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.ChildInstanceAttributesHandler;

public abstract class AbstractCreateInstanceAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$AbstractCreateInstanceAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$AbstractCreateInstanceAction = AbstractCreateInstanceAction.class$("se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$AbstractCreateInstanceAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    protected AbstractList attributeDataList = null;
    protected TableHandler tableHandler = null;
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$AbstractCreateInstanceAction;

    public final void convert(AueContext aueContext) throws CrbsAueException {
        this.tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        this.createInstance(aueContext);
    }

    public abstract void createInstance(AueContext var1) throws CrbsAueException;

    protected boolean isRacMo(String froTypeName) throws CrbsAueException {
        FroVersionsTable froVersionsTable = this.tableHandler.getFroVersionsTable();
        FroVersionsData[] froVersionsDatas = froVersionsTable.getDatas();
        boolean moTypeFound = false;
        for (int i = 0; i < froVersionsDatas.length; ++i) {
            if (!froVersionsDatas[i].froTypeName.equalsIgnoreCase(froTypeName)) continue;
            moTypeFound = true;
            break;
        }
        return moTypeFound;
    }

    protected String createParentMoRef(String parentLdn, String parentFroType, boolean froParent) throws CrbsAueException {
        String froType = "0";
        String froId = "1";
        if (this.isRacMo(parentFroType) && froParent) {
            logger.traceGeneral(THIS_CLASS, "The parent MO " + parentFroType + " is in RAC.");
            try {
                TableData parentTableData = this.tableHandler.getTableData(parentFroType);
                if (parentTableData.hasColumns()) {
                    froId = this.getParentFroId(parentLdn, parentFroType, parentTableData);
                    froType = parentTableData.getFroTypeId().toString();
                }
            }
            catch (TableDataException e) {
                throw new CrbsAueException("Error getting parent table data");
            }
        }
        String parentMoRef = "<moref name=\"parentRef\"><attr name=\"ldn\" type=\"STRING\" value=\"" + parentLdn + "\"/><attr name=\"froType\" type=\"S32\" value=\"" + froType + "\"/><attr name=\"froId\" type=\"S32\" value=\"" + froId + "\"/></moref>";
        return parentMoRef;
    }

    protected String getParentFroId(String parentLdn, String parentFroType, TableData parentTableData) throws CrbsAueException, TableDataException {
        String froId = null;
        Object[] ldnTableColumnData = parentTableData.getAttributeValues("ldn");
        Object[] froIdColumnDatas = parentTableData.getAttributeValues("froid");
        for (int row = 0; row < ldnTableColumnData.length; ++row) {
            if (!ldnTableColumnData[row].toString().equalsIgnoreCase(parentLdn)) continue;
            froId = froIdColumnDatas[row].toString();
        }
        if (froId == null) {
            throw new CrbsAueException("The froId for parent MO " + parentFroType + " could not be found in the database");
        }
        return froId;
    }

    protected String getFroTypeNameFromLdn(String ldnToType) {
        int lastCommaIndex = ldnToType.lastIndexOf(",");
        int lastEqualsIndex = ldnToType.lastIndexOf("=");
        if (lastEqualsIndex == -1) {
            lastEqualsIndex = ldnToType.length();
        }
        if (lastCommaIndex == -1) {
            lastCommaIndex = 0;
        }
        String typeFromLdn = ldnToType.substring(lastCommaIndex + 1, lastEqualsIndex);
        return typeFromLdn;
    }

    protected boolean moTypeIsNew(String froTypeName) throws CrbsAueException {
        FroVersionsTable froVersionsTable = this.tableHandler.getFroVersionsTable();
        FroVersionsData[] froVersionsDatas = froVersionsTable.getDatas();
        boolean froTypeNameFound = false;
        for (int i = 0; i < froVersionsDatas.length; ++i) {
            if (!froVersionsDatas[i].froTypeName.equalsIgnoreCase(froTypeName)) continue;
            froTypeNameFound = true;
            break;
        }
        return !froTypeNameFound;
    }

    protected void insertIntoFroVersions(Integer froTypeId, String froTypeName) throws CrbsAueException {
        String tablePrefix = this.tableHandler.getRbsAueMetaData().getFroDataPrefix();
        FroVersionsTable froVersionsTable = this.tableHandler.getFroVersionsTable();
        String froDataTableName = tablePrefix + "frodata_" + froTypeName + "_INITIAL";
        try {
            froVersionsTable.insertIntoTable(froTypeId, froTypeName, froDataTableName);
            logger.traceGeneral(THIS_CLASS, "Updated \"fro_versions\" table with the new FRO type: " + AueUtil.doubleQuote(froTypeName));
        }
        catch (TableDataException tde) {
            logger.traceAbnormal(THIS_CLASS, "Trying to insert the already existing MO, " + AueUtil.doubleQuote(froTypeName) + ", into the \"fro_versions\" table.");
        }
        catch (Exception e) {
            String errorMsg = "Could not insert the new MO, " + AueUtil.doubleQuote(froTypeName) + ", into the \"fro_versions\" table";
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
            throw new CrbsAueException(AueUtil.appendReason(errorMsg, e), e);
        }
    }

    protected Integer getIntegerFroTypeId(String froTypeIdString) throws CrbsAueException {
        Integer froTypeId;
        try {
            froTypeId = new Integer(froTypeIdString);
        }
        catch (NumberFormatException nfe) {
            throw new CrbsAueException("Specified FRO type id is not an integer, " + AueUtil.doubleQuote(froTypeIdString));
        }
        return froTypeId;
    }

    protected void parseChildAttributes(String childAttributes) throws CrbsAueException {
        try {
            String correctedXml = this.replaceInnerXmlTags(childAttributes);
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            StringReader reader = new StringReader(correctedXml);
            InputSource inputSource = new InputSource(reader);
            ChildInstanceAttributesHandler handler = new ChildInstanceAttributesHandler();
            parser.setContentHandler(handler);
            parser.parse(inputSource);
            this.attributeDataList = handler.getAttributeList();
            if (this.attributeDataList == null) {
                throw new CrbsAueException("No attribute list recieved from the ChildInstanceAttributeHandler");
            }
        }
        catch (Exception e) {
            throw new CrbsAueException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String replaceInnerXmlTags(String xmlString) {
        AbstractCreateInstanceAction abstractCreateInstanceAction = this;
        synchronized (abstractCreateInstanceAction) {
            int nestedLevel = 0;
            logger.traceGeneral(THIS_CLASS, xmlString);
            String correctedXml = xmlString;
            for (int i = 0; i < correctedXml.length(); ++i) {
                char currentChar = correctedXml.charAt(i);
                if (currentChar == '<') {
                    if (++nestedLevel <= 1) continue;
                    correctedXml = correctedXml.substring(0, i) + "&lt;" + correctedXml.substring(i + 1, correctedXml.length());
                    continue;
                }
                if (currentChar == '>') {
                    if (nestedLevel > 1) {
                        correctedXml = correctedXml.substring(0, i) + "&gt;" + correctedXml.substring(i + 1, correctedXml.length());
                    }
                    --nestedLevel;
                    continue;
                }
                if (currentChar != '\"' || nestedLevel <= 1) continue;
                correctedXml = correctedXml.substring(0, i) + "&quot;" + correctedXml.substring(i + 1, correctedXml.length());
            }
            logger.traceGeneral(THIS_CLASS, correctedXml);
            return correctedXml;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

