/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class ChangeAttributeValueAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$ChangeAttributeValueAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$ChangeAttributeValueAction = ChangeAttributeValueAction.class$("se.ericsson.crbs.omf.aue.step1.actions.ChangeAttributeValueAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$ChangeAttributeValueAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$ChangeAttributeValueAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        boolean rdnShouldBeChecked = false;
        String rdnValue = "";
        boolean oldValueShouldBeChecked = false;
        String oldValue = "";
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String attributeName = this.getAndCheckParamMapString("attribute", this.paramMap, "The parameter attribute for " + froTypeName + " is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String newAttributeValue = this.getAndCheckParamMapStringAcceptEmptyString("newAttributeValue", this.paramMap, "The parameter newAttributeValue for " + froTypeName + " is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        try {
            rdnValue = this.getAndCheckParamMapString("rdnValue", this.paramMap, "Optional parameter");
            rdnShouldBeChecked = true;
        }
        catch (CrbsAueException e) {
            rdnShouldBeChecked = false;
        }
        try {
            oldValue = this.getAndCheckParamMapStringAcceptEmptyString("oldAttributeValue", this.paramMap, "Optional parameter");
            oldValueShouldBeChecked = true;
        }
        catch (CrbsAueException e) {
            oldValueShouldBeChecked = false;
        }
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(froTypeName);
            this.changeAttributeValueIfItExist(froTypeName, attributeName, newAttributeValue, rdnShouldBeChecked, rdnValue, oldValueShouldBeChecked, oldValue, tableData);
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Could not find a TableData for the fro type " + froTypeName + ". Reason: " + e.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void changeAttributeValueIfItExist(String moName, String attributeName, String newAttributeValue, boolean rdnShouldBeChecked, String rdnValue, boolean oldValueShouldBeChecked, String oldValue, TableData tableData) throws CrbsAueException {
        block6: {
            try {
                if (tableData == null || !tableData.isNotEmpty()) break block6;
                Object[] attributeValues = null;
                boolean attributeExist = true;
                try {
                    attributeValues = tableData.getAttributeValues(attributeName);
                }
                catch (TableDataException e) {
                    attributeExist = false;
                }
                if (attributeExist) {
                    this.changeAttributeValue(moName, attributeName, newAttributeValue, rdnShouldBeChecked, rdnValue, oldValueShouldBeChecked, oldValue, tableData, attributeValues);
                } else {
                    logger.traceGeneral(THIS_CLASS, "The attribute \"" + attributeName + "\" does not exist in the database and can not be updated to the new value \"" + newAttributeValue + "\".");
                }
            }
            catch (TableDataException exception) {
                throw new CrbsAueException("Failed to set the data for table fro type " + tableData.getTableName() + " in " + AueUtil.doubleQuote(this.getClass().getName()), exception);
            }
        }
    }

    private void changeAttributeValue(String moName, String attributeName, String newAttributeValue, boolean rdnShouldBeChecked, String rdnValue, boolean oldValueShouldBeChecked, String oldValue, TableData tableData, Object[] attributeValues) throws TableDataException, CrbsAueException {
        String momType = tableData.getMomType(attributeName);
        Object newAttributeValueObj = this.convertValueTypeFromStringToCorrectType(newAttributeValue, momType);
        if (newAttributeValueObj == null) {
            throw new CrbsAueException("The given newAttributeValue can not be converted to the MOM type defined for the attribute. The MO:attribute is " + moName + ":" + attributeName + ". The attribute value =" + newAttributeValue + ". The momType=" + momType + ". Error in " + AueUtil.doubleQuote(this.getClass().getName()));
        }
        Object[] ldnValues = tableData.getAttributeValues("ldn");
        if (ldnValues.length != attributeValues.length) {
            throw new CrbsAueException("The size of the ldn column and the attribute \"" + attributeName + "\" column are not the same. Database corrupt. Aborting.");
        }
        for (int i = 0; i < attributeValues.length; ++i) {
            String currentValue;
            String currentLdn = ldnValues[i].toString();
            if (!this.shouldAttributeValueBeChanged(currentLdn, rdnShouldBeChecked, rdnValue, currentValue = attributeValues[i] == null ? null : attributeValues[i].toString(), oldValueShouldBeChecked, oldValue)) continue;
            tableData.setAttributeValue(i, attributeName, newAttributeValueObj);
            logger.traceDebug(THIS_CLASS, "Changing the value for the attribute " + attributeName + " to \"" + newAttributeValue + "\" for MO " + currentLdn);
        }
    }

    private Object convertValueTypeFromStringToCorrectType(String newAttributeValue, String momType) {
        Object result = newAttributeValue;
        try {
            if ("S32".equalsIgnoreCase(momType)) {
                result = "true".equalsIgnoreCase(newAttributeValue) ? new Integer(1) : ("false".equalsIgnoreCase(newAttributeValue) ? new Integer(0) : Integer.valueOf(newAttributeValue));
            } else if ("S64".equalsIgnoreCase(momType)) {
                result = Long.valueOf(newAttributeValue);
            }
        }
        catch (NumberFormatException e) {
            result = null;
        }
        return result;
    }

    private boolean shouldAttributeValueBeChanged(String ldn, boolean rdnShouldBeChecked, String rdnValue, String currentValue, boolean oldValueShouldBeChecked, String oldValue) {
        return this.theValueForThisRdnShouldBeChanged(ldn, rdnShouldBeChecked, rdnValue) && this.theValueForThisOldValueShouldBeChanged(currentValue, oldValueShouldBeChecked, oldValue);
    }

    private boolean theValueForThisOldValueShouldBeChanged(String currentValue, boolean oldValueShouldBeChecked, String oldValue) {
        boolean oldValueMatched = currentValue == null ? oldValue.equalsIgnoreCase("null") : oldValue.equals(currentValue);
        return !oldValueShouldBeChecked || oldValueMatched;
    }

    private boolean theValueForThisRdnShouldBeChanged(String ldn, boolean rdnShouldBeChecked, String rdnValue) {
        return !rdnShouldBeChecked || rdnValue.equals(LdnUtil.getRdnValue(ldn));
    }

    private String getAndCheckParamMapStringAcceptEmptyString(String key, Map localParamMap, String errorMsg) throws CrbsAueException {
        String keyValue = (String)localParamMap.get(key);
        if (keyValue == null) {
            throw new CrbsAueException(errorMsg);
        }
        return keyValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

