/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopyAndAddOffsetAttributeAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$CopyAndAddOffsetAttributeAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$CopyAndAddOffsetAttributeAction = CopyAndAddOffsetAttributeAction.class$("se.ericsson.crbs.omf.aue.step1.actions.CopyAndAddOffsetAttributeAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$CopyAndAddOffsetAttributeAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$CopyAndAddOffsetAttributeAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String fromAttr = this.getAndCheckParamMapString("fromAttr", this.paramMap, "No attribute to copy from is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String toAttr = this.getAndCheckParamMapString("toAttr", this.paramMap, "No attribute to copy to is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String offsetString = this.getAndCheckParamMapString("offset", this.paramMap, "No offset is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        int offsetVal = 0;
        try {
            offsetVal = Integer.parseInt(offsetString);
        }
        catch (NumberFormatException e) {
            String exceptionmsg = "Offset specified in " + AueUtil.doubleQuote(this.getClass().getName()) + " is not a valid integer value:" + AueUtil.doubleQuote(offsetString);
            logger.traceDebug(THIS_CLASS, exceptionmsg);
            throw new CrbsAueException(exceptionmsg);
        }
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(froTypeName);
            if (tableData.isNotEmpty()) {
                this.copyAttributeValues(fromAttr, toAttr, tableData, offsetVal);
            }
        }
        catch (TableDataException tde) {
            String errorMsg = "Could not copy attribute, " + AueUtil.doubleQuote(fromAttr) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", to, " + AueUtil.doubleQuote(toAttr) + ", in, " + AueUtil.doubleQuote(froTypeName);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, tde));
            throw new CrbsAueException(AueUtil.appendReason(errorMsg, tde), tde);
        }
    }

    private void copyAttributeValues(String fromAttributeName, String toAttributeName, TableData tableData, int offset) throws CrbsAueException, TableDataException {
        Object[] ldnColumnData = tableData.getAttributeValues("ldn");
        Object[] fromAttributeColumnData = tableData.getAttributeValues(fromAttributeName);
        Integer copiedData = null;
        for (int moInstanceIndex = 0; moInstanceIndex < ldnColumnData.length; ++moInstanceIndex) {
            Integer newAttrValue;
            try {
                copiedData = Integer.valueOf(fromAttributeColumnData[moInstanceIndex].toString());
                newAttrValue = new Integer(copiedData + offset);
            }
            catch (NumberFormatException e) {
                throw new CrbsAueException("The value " + AueUtil.doubleQuote(fromAttributeColumnData[moInstanceIndex].toString()) + " to copy from is not a valid Integer number.");
            }
            tableData.setAttributeValue(moInstanceIndex, toAttributeName, newAttrValue);
            logger.traceGeneral(THIS_CLASS, "Attribute value, " + AueUtil.doubleQuote(copiedData.toString()) + ", copied add added offset " + offset + " from attribute, " + AueUtil.doubleQuote(fromAttributeName) + ", in, " + AueUtil.doubleQuote(tableData.getTableName()) + ", to attribute ," + AueUtil.doubleQuote(toAttributeName) + ", in, " + AueUtil.doubleQuote(tableData.getTableName()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

