/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopyAndRemapAttributeAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$CopyAndRemapAttributeAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$CopyAndRemapAttributeAction = CopyAndRemapAttributeAction.class$("se.ericsson.crbs.omf.aue.step1.actions.CopyAndRemapAttributeAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$CopyAndRemapAttributeAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static Map valueMap = null;
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$CopyAndRemapAttributeAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String fromAttr = this.getAndCheckParamMapString("fromAttr", this.paramMap, "No attribute to copy from is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String toAttr = this.getAndCheckParamMapString("toAttr", this.paramMap, "No attribute to copy to is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String mapping = this.getAndCheckParamMapString("mapping", this.paramMap, "No mapping is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        valueMap = this.parseMappingString(mapping);
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(froTypeName);
            if (tableData.isNotEmpty()) {
                this.copyAttributeValues(fromAttr, toAttr, tableData);
            }
        }
        catch (TableDataException tde) {
            String errorMsg = "Could not copy attribute, " + AueUtil.doubleQuote(fromAttr) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", to, " + AueUtil.doubleQuote(toAttr) + ", in, " + AueUtil.doubleQuote(froTypeName);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, tde));
            throw new CrbsAueException(errorMsg, tde);
        }
    }

    protected Map parseMappingString(String mapping) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer singlemapping = new StringTokenizer(mapping);
        while (singlemapping.hasMoreTokens()) {
            String keyvalue = singlemapping.nextToken();
            int pos = keyvalue.indexOf(58);
            map.put(keyvalue.substring(0, pos), keyvalue.substring(pos + 1));
        }
        return map;
    }

    private void copyAttributeValues(String fromAttrName, String toAttrName, TableData tableData) throws CrbsAueException, TableDataException {
        Object[] ldnColumnData = tableData.getAttributeValues("ldn");
        Object[] moData = tableData.getAttributeValues(fromAttrName);
        Integer copiedData = null;
        String newData = "";
        for (int moInstanceIndex = 0; moInstanceIndex < ldnColumnData.length; ++moInstanceIndex) {
            Integer newAttrValue;
            try {
                copiedData = Integer.valueOf(moData[moInstanceIndex].toString());
                newData = (String)valueMap.get(copiedData.toString());
                if (newData == null) {
                    throw new CrbsAueException("The mapping data do not contain values for:" + copiedData);
                }
                newAttrValue = Integer.valueOf(newData);
            }
            catch (NumberFormatException e) {
                throw new CrbsAueException("The mapping " + copiedData + " to " + newData + " is not a valid Integer number.");
            }
            tableData.setAttributeValue(moInstanceIndex, toAttrName, newAttrValue);
            logger.traceGeneral(THIS_CLASS, "Attribute value, " + AueUtil.doubleQuote(copiedData.toString()) + ", copied from attribute, " + AueUtil.doubleQuote(fromAttrName) + ", in, " + AueUtil.doubleQuote(tableData.getTableName()) + ", to attribute ," + AueUtil.doubleQuote(toAttrName) + ", in, " + AueUtil.doubleQuote(tableData.getTableName()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

