/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.ArrayList;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class RemoveStructMemberAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$RemoveStructMemberAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$RemoveStructMemberAction = RemoveStructMemberAction.class$("se.ericsson.crbs.omf.aue.step1.actions.RemoveStructMemberAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$RemoveStructMemberAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$RemoveStructMemberAction;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String moTypeName = this.getMoTypeName();
        try {
            TableData tableData = this.getTableData(context, moTypeName);
            if (tableData.isNotEmpty()) {
                this.removeStructMember(tableData, moTypeName);
            }
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Could not to get table data for: " + moTypeName, e);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void removeStructMember(TableData tableData, String moTypeName) throws CrbsAueException {
        Object[] structAttrValues;
        String structAttrName = this.getAttributeName();
        String structMemberName = this.getStructMemberName();
        try {
            structAttrValues = tableData.getAttributeValues(structAttrName);
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Could not get table column for: " + moTypeName + "::" + structAttrName, e);
        }
        try {
            for (int rowIndex = 0; rowIndex < structAttrValues.length; ++rowIndex) {
                String newStructXml;
                String oldStructXml = structAttrValues[rowIndex].toString();
                if (!oldStructXml.equals(newStructXml = this.removeStructMemberFromArray(structMemberName, oldStructXml, moTypeName, structAttrName))) {
                    tableData.setAttributeValue(rowIndex, structAttrName, newStructXml);
                }
                logger.traceGeneral(THIS_CLASS, "Struct member \"" + structMemberName + "\" was successfully removed from instance " + rowIndex + " of " + moTypeName + "::" + structAttrName + " .");
            }
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Could not set table data for: " + moTypeName + "::" + structAttrName, e);
        }
    }

    private String removeStructMemberFromArray(String structMemberName, String structAttrXml, String moTypeName, String structAttrName) throws CrbsAueException {
        String noMemberEndTagMsg = "Could not find struct member xml end tag for " + structMemberName + " in " + moTypeName + "::" + structAttrName;
        if (structAttrXml.indexOf("<complex>") == -1) {
            String startTempXmlString = "";
            String endTempXmlString = structAttrXml;
            int xmlStartTag = 60;
            int xmlEndTag = 62;
            String structMemberNameStartString = "attr name=\"";
            String structMemberNameEndString = "\"";
            String structMemberToRemove = "<attr name=\"" + structMemberName + "\"";
            int structMemberStartIndex = structAttrXml.indexOf(structMemberToRemove);
            while (structMemberStartIndex > 0) {
                int structMemberEndIndex = endTempXmlString.indexOf(62, structMemberStartIndex);
                if (structMemberEndIndex < 0) {
                    throw new CrbsAueException(noMemberEndTagMsg);
                }
                startTempXmlString = startTempXmlString + endTempXmlString.substring(0, structMemberStartIndex);
                endTempXmlString = endTempXmlString.substring(structMemberEndIndex + 1);
                structMemberStartIndex = endTempXmlString.indexOf(structMemberToRemove);
            }
            return startTempXmlString.trim() + endTempXmlString;
        }
        String strctStart = "<strct name=\"" + structAttrName + "\">";
        String strctEnd = "</strct>";
        String dataStart = "<data>";
        String dataEnd = "</data>";
        String seqOfStrctsStart = "<seq name=\"" + structAttrName + "\" type=\"strct\">";
        String seqOfStrctsEnd = "</seq>";
        if (structAttrXml.indexOf(strctStart) != -1) {
            int i;
            int strctStartIndex = structAttrXml.indexOf(strctStart) + strctStart.length();
            int strctEndIndex = structAttrXml.indexOf("</strct>") - 1;
            int dataStartIndex = structAttrXml.indexOf("<data>", strctEndIndex) + "<data>".length();
            int dataEndIndex = structAttrXml.indexOf("</data>", strctEndIndex);
            String data = structAttrXml.substring(dataStartIndex, dataEndIndex);
            ArrayList strctMembers = this.getComplexStrctMembers(structAttrXml.substring(strctStartIndex, strctEndIndex + 1));
            ArrayList strctData = this.getComplexData(data);
            int strctMemberToBeRemovedIndex = -1;
            for (int i2 = 0; i2 < strctMembers.size(); ++i2) {
                if (((String)strctMembers.get(i2)).indexOf(structMemberName) == -1) continue;
                strctMemberToBeRemovedIndex = i2;
                break;
            }
            if (strctMemberToBeRemovedIndex < 0) {
                return structAttrXml;
            }
            int dataIndex = 0;
            for (int i3 = 0; i3 < strctMemberToBeRemovedIndex && i3 < strctMembers.size(); ++i3) {
                String strctMember = (String)strctMembers.get(i3);
                if (strctMember.indexOf("<attr ") != -1) {
                    ++dataIndex;
                    continue;
                }
                if (strctMember.indexOf("<moref ") != -1) {
                    dataIndex += 3;
                    continue;
                }
                if (strctMember.indexOf("<seq ") == -1) continue;
                int seqSize = Integer.parseInt((String)strctData.get(dataIndex));
                String seqType = strctMember.substring(strctMember.indexOf("type=\"") + 6, strctMember.indexOf(34, strctMember.indexOf("type=\"") + 6));
                if (seqType.equals("moref")) {
                    dataIndex += seqSize * 3 + 1;
                    continue;
                }
                dataIndex += seqSize + 1;
            }
            String strctMemberToBeRemoved = (String)strctMembers.get(strctMemberToBeRemovedIndex);
            if (strctMemberToBeRemoved.indexOf("<moref") != -1) {
                for (int i4 = 0; i4 < 3 && i4 < strctData.size(); ++i4) {
                    strctData.remove(dataIndex);
                }
            } else if (strctMemberToBeRemoved.indexOf("<seq") != -1) {
                int seqSize = Integer.parseInt((String)strctData.get(dataIndex));
                strctData.remove(dataIndex);
                for (i = 0; i < seqSize; ++i) {
                    if (strctMemberToBeRemoved.indexOf("type=\"moref\"") != -1) {
                        for (int j = 0; j < 3; ++j) {
                            strctData.remove(dataIndex);
                        }
                        continue;
                    }
                    strctData.remove(dataIndex);
                }
            } else {
                strctData.remove(dataIndex);
            }
            strctMembers.remove(strctMemberToBeRemovedIndex);
            StringBuffer result = new StringBuffer();
            result.append(structAttrXml.substring(0, strctStartIndex));
            for (i = 0; i < strctMembers.size(); ++i) {
                result.append((String)strctMembers.get(i));
            }
            result.append(structAttrXml.substring(strctEndIndex + 1, dataStartIndex));
            for (i = 0; i < strctData.size(); ++i) {
                result.append((String)strctData.get(i));
                if (i >= strctData.size() - 1) continue;
                result.append(',');
            }
            result.append(structAttrXml.substring(dataEndIndex));
            return result.toString();
        }
        if (structAttrXml.indexOf(seqOfStrctsStart) != -1) {
            int i;
            int strctStartIndex = structAttrXml.indexOf(seqOfStrctsStart) + seqOfStrctsStart.length();
            int strctEndIndex = structAttrXml.indexOf("</seq>") - 1;
            int dataStartIndex = structAttrXml.indexOf("<data>", strctEndIndex) + "<data>".length();
            int dataEndIndex = structAttrXml.indexOf("</data>", strctEndIndex);
            String data = structAttrXml.substring(dataStartIndex, dataEndIndex);
            ArrayList seqStrctMembers = this.getComplexStrctMembers(structAttrXml.substring(strctStartIndex, strctEndIndex + 1));
            ArrayList strctData = this.getComplexData(data);
            int strctMemberToBeRemovedIndex = -1;
            for (int i5 = 0; i5 < seqStrctMembers.size(); ++i5) {
                if (((String)seqStrctMembers.get(i5)).indexOf(structMemberName) == -1) continue;
                strctMemberToBeRemovedIndex = i5;
                break;
            }
            if (strctMemberToBeRemovedIndex < 0) {
                return structAttrXml;
            }
            int dataIndex = 1;
            int mainSeqSize = Integer.parseInt((String)strctData.get(0));
            int elementLength = 0;
            for (int i6 = 0; i6 < seqStrctMembers.size(); ++i6) {
                String strctMember = (String)seqStrctMembers.get(i6);
                if (strctMember.indexOf("<attr ") != -1) {
                    ++elementLength;
                    continue;
                }
                if (strctMember.indexOf("<moref ") != -1) {
                    elementLength += 3;
                    continue;
                }
                if (strctMember.indexOf("<seq ") == -1) continue;
                int seqSize = Integer.parseInt((String)strctData.get(elementLength + 1));
                String seqType = strctMember.substring(strctMember.indexOf("type=\"") + 6, strctMember.indexOf(34, strctMember.indexOf("type=\"") + 6));
                if (seqType.equals("moref")) {
                    elementLength += seqSize * 3 + 1;
                    continue;
                }
                elementLength += seqSize + 1;
            }
            for (int j = 0; j < mainSeqSize; ++j) {
                for (int i7 = 0; i7 < strctMemberToBeRemovedIndex; ++i7) {
                    String strctMember = (String)seqStrctMembers.get(i7);
                    if (strctMember.indexOf("<attr ") != -1) {
                        ++dataIndex;
                        continue;
                    }
                    if (strctMember.indexOf("<moref ") != -1) {
                        dataIndex += 3;
                        continue;
                    }
                    if (strctMember.indexOf("<seq ") == -1) continue;
                    int seqSize = Integer.parseInt((String)strctData.get(dataIndex));
                    String seqType = strctMember.substring(strctMember.indexOf("type=\"") + 6, strctMember.indexOf(34, strctMember.indexOf("type=\"") + 6));
                    if (seqType.equals("moref")) {
                        dataIndex += seqSize * 3 + 1;
                        continue;
                    }
                    dataIndex += seqSize + 1;
                }
                String strctMemberToBeRemoved = (String)seqStrctMembers.get(strctMemberToBeRemovedIndex);
                if (strctMemberToBeRemoved.indexOf("<moref") != -1) {
                    for (int i8 = 0; i8 < 3; ++i8) {
                        strctData.remove(dataIndex);
                    }
                    dataIndex = 1 + (j + 1) * (elementLength - 3);
                    continue;
                }
                if (strctMemberToBeRemoved.indexOf("<seq") != -1) {
                    int i9;
                    int seqSize = Integer.parseInt((String)strctData.get(dataIndex));
                    strctData.remove(dataIndex);
                    if (strctMemberToBeRemoved.indexOf("type=\"moref\"") != -1) {
                        for (i9 = 0; i9 < seqSize; ++i9) {
                            for (int k = 0; k < 3 && dataIndex < strctData.size(); ++k) {
                                strctData.remove(dataIndex);
                            }
                        }
                        dataIndex = 1 + (j + 1) * (elementLength - (3 * seqSize + 1));
                        continue;
                    }
                    for (i9 = 0; i9 < seqSize; ++i9) {
                        strctData.remove(dataIndex);
                    }
                    dataIndex = 1 + (j + 1) * (elementLength - (seqSize + 1));
                    continue;
                }
                strctData.remove(dataIndex);
                dataIndex = 1 + (j + 1) * (elementLength - 1);
            }
            seqStrctMembers.remove(strctMemberToBeRemovedIndex);
            StringBuffer result = new StringBuffer();
            result.append(structAttrXml.substring(0, strctStartIndex));
            for (i = 0; i < seqStrctMembers.size(); ++i) {
                result.append((String)seqStrctMembers.get(i));
            }
            result.append(structAttrXml.substring(strctEndIndex + 1, dataStartIndex));
            for (i = 0; i < strctData.size(); ++i) {
                result.append((String)strctData.get(i));
                if (i >= strctData.size() - 1) continue;
                result.append(',');
            }
            result.append(structAttrXml.substring(dataEndIndex));
            return result.toString();
        }
        return structAttrXml;
    }

    private ArrayList getComplexStrctMembers(String xmlString) {
        ArrayList<String> result = new ArrayList<String>();
        int idx = 0;
        while (idx < xmlString.length()) {
            int newIdx = xmlString.indexOf(62, idx + 1);
            if (++newIdx == 0) {
                result.add(xmlString.substring(idx));
                break;
            }
            result.add(xmlString.substring(idx, newIdx));
            idx = newIdx;
        }
        return result;
    }

    private ArrayList getComplexData(String xmlString) {
        ArrayList<String> result = new ArrayList<String>();
        int idx = 0;
        while (idx < xmlString.length()) {
            int newIdx = xmlString.indexOf(44, idx);
            if (newIdx == -1) {
                result.add(xmlString.substring(idx));
                break;
            }
            result.add(xmlString.substring(idx, newIdx));
            idx = newIdx + 1;
        }
        for (int i = 0; i < result.size() - 1; ++i) {
            if (!((String)result.get(i)).endsWith("\\") || ((String)result.get(i)).endsWith("\\\\")) continue;
            result.set(i, (String)result.get(i) + "," + (String)result.get(i + 1));
            result.remove(i + 1);
            --i;
        }
        return result;
    }

    private TableData getTableData(AueContext context, String moTypeName) throws TableDataException {
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = tableHandler.getTableData(moTypeName);
        return tableData;
    }

    private String getMoTypeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
    }

    private String getAttributeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("attribute", this.paramMap, "The attribute \"attribute\" is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
    }

    private String getStructMemberName() throws CrbsAueException {
        return this.getAndCheckParamMapString("structMember", this.paramMap, "The attribute \"structMember\" is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

