/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.util.AbstractTableDataUtilHelper;

public class TableDataUtilHelperImpl
extends AbstractTableDataUtilHelper {
    private static TableDataUtilHelperImpl instance = new TableDataUtilHelperImpl();

    public static TableDataUtilHelperImpl instance() {
        return instance;
    }

    private TableDataUtilHelperImpl() {
    }

    public Map getAttributes(String ldn, TableData froDataTable) throws CrbsAueException, TableDataException {
        int rowNr = this.getRowNr(ldn, froDataTable);
        Map attributeMap = froDataTable.getRecordMap(rowNr);
        return attributeMap;
    }

    public void setAttributes(String ldn, TableData tableData, Map attributes) throws CrbsAueException, TableDataException {
        int rowNr = this.getRowNr(ldn, tableData);
        Iterator attributeIterator = attributes.entrySet().iterator();
        while (attributeIterator.hasNext()) {
            Map.Entry entry = attributeIterator.next();
            String attributeName = entry.getKey().toString();
            Object attributeValue = entry.getValue();
            tableData.setAttributeValue(rowNr, attributeName, attributeValue);
        }
    }

    public Object[] getLdns(TableData tableData) throws TableDataException {
        return tableData.getAttributeValues("ldn");
    }

    public List getLdnsWithParent(String parentLdn, TableData tableData) throws TableDataException {
        Object[] ldns = this.getLdns(tableData);
        ArrayList<String> ldnList = new ArrayList<String>();
        for (int i = 0; i < ldns.length; ++i) {
            String ldn = ldns[i].toString();
            if (!LdnUtil.getParentLdn(ldn).equals(parentLdn)) continue;
            ldnList.add(ldn);
        }
        return ldnList;
    }

    public String getFroid(String ldn, TableData tableData) throws CrbsAueException, TableDataException {
        Map attributes = this.getAttributes(ldn, tableData);
        return attributes.get("froid").toString();
    }

    private int getRowNr(String ldnToLookFor, TableData froDataTable) throws CrbsAueException, TableDataException {
        Object[] ldnValues = froDataTable.getAttributeValues("ldn");
        int rowIndex = -1;
        for (int i = 0; i < ldnValues.length; ++i) {
            if (!ldnValues[i].toString().equalsIgnoreCase(ldnToLookFor)) continue;
            rowIndex = i;
            break;
        }
        if (rowIndex == -1) {
            throw new TableDataException("Can not find LDN \"" + ldnToLookFor + "\" in " + froDataTable.getTableName());
        }
        return rowIndex;
    }

    public String createEmptyMoRefXmlString(String moRefAttrName) {
        return this.createMoRefXmlString(moRefAttrName, "", "-1", "-1");
    }

    public String createMoRefXmlString(String moRefAttrName, String ldn, String froType, String froId) {
        String XML_STRING_START = "<moref name=\"";
        String XML_STRING_BEFORE_LDN = "\"><attr name=\"ldn\" type=\"STRING\" value=\"";
        String XML_STRING_BEFORE_FRO_TYPE = "\"/><attr name=\"froType\" type=\"S32\" value=\"";
        String XML_STRING_BEFORE_FRO_ID = "\"/><attr name=\"froId\" type=\"S32\" value=\"";
        String XML_STRING_END = "\"/></moref>";
        String xmlString = "<moref name=\"" + moRefAttrName + "\"><attr name=\"ldn\" type=\"STRING\" value=\"" + ldn + "\"/><attr name=\"froType\" type=\"S32\" value=\"" + froType + "\"/><attr name=\"froId\" type=\"S32\" value=\"" + froId + "\"/></moref>";
        return xmlString;
    }

    public String createMoRefInArrayXmlString(String ldn, String froType, String froId) {
        String XML_STRING_START = "<moref><attr name=\"ldn\" type=\"STRING\" value=\"";
        String XML_STRING_BEFORE_FRO_TYPE = "\"/><attr name=\"froType\" type=\"S32\" value=\"";
        String XML_STRING_BEFORE_FRO_ID = "\"/><attr name=\"froId\" type=\"S32\" value=\"";
        String XML_STRING_END = "\"/></moref>";
        String xmlString = "<moref><attr name=\"ldn\" type=\"STRING\" value=\"" + ldn + "\"/><attr name=\"froType\" type=\"S32\" value=\"" + froType + "\"/><attr name=\"froId\" type=\"S32\" value=\"" + froId + "\"/></moref>";
        return xmlString;
    }

    public String createEmptyArrayXmlString(String attrName) {
        String XML_STRING_START_ARRAY = "<array name=\"";
        String XML_STRING_START_ARRAY_2 = "\">";
        String XML_STRING_END_ARRAY = "</array>";
        String xmlString = "<array name=\"" + attrName + "\">" + "</array>";
        return xmlString;
    }

    public String createArrayXmlString(String attrName, List attrsAsXml) {
        String XML_STRING_START_ARRAY = "<array name=\"";
        String XML_STRING_START_ARRAY_2 = "\">";
        String XML_STRING_END_ARRAY = "</array>";
        String xmlString = "<array name=\"" + attrName + "\">";
        for (int i = 0; i < attrsAsXml.size(); ++i) {
            xmlString = xmlString + attrsAsXml.get(i);
        }
        xmlString = xmlString + "</array>";
        return xmlString;
    }

    public String getLdnFromMoRef(String moRefXmlString) {
        String stringBeforeLdn = "name=\"ldn\" type=\"STRING\" value=\"";
        int ldnStartIndex = moRefXmlString.indexOf("name=\"ldn\" type=\"STRING\" value=\"") + "name=\"ldn\" type=\"STRING\" value=\"".length();
        int ldnEndIndex = moRefXmlString.indexOf("\"/>", ldnStartIndex);
        return moRefXmlString.substring(ldnStartIndex, ldnEndIndex);
    }

    public Map getTableAttributesMap(TableData tableData) throws CrbsAueException, TableDataException {
        HashMap<String, Map> tableAttributesMap = new HashMap<String, Map>();
        Object[] ldns = this.getLdns(tableData);
        for (int i = 0; i < ldns.length; ++i) {
            String ldn = (String)ldns[i];
            tableAttributesMap.put(ldn, this.getAttributes(ldn, tableData));
        }
        return tableAttributesMap;
    }

    public Map getTableAttributesMapForAttributes(TableData tableData, List attributeNames) throws CrbsAueException, TableDataException {
        HashMap tableAttributesMap = new HashMap();
        HashMap<String, Object[]> attributeColumns = new HashMap<String, Object[]>();
        Iterator iterator = attributeNames.iterator();
        while (iterator.hasNext()) {
            String attributeName = (String)iterator.next();
            Object[] columnDatas = tableData.getAttributeValues(attributeName);
            attributeColumns.put(attributeName, columnDatas);
        }
        Object[] ldns = this.getLdns(tableData);
        for (int i = 0; i < ldns.length; ++i) {
            HashMap<String, Object> givenAttributes = new HashMap<String, Object>();
            Iterator iterator2 = attributeNames.iterator();
            while (iterator2.hasNext()) {
                String attributeName = (String)iterator2.next();
                givenAttributes.put(attributeName, ((Object[])attributeColumns.get(attributeName))[i]);
            }
            tableAttributesMap.put(ldns[i], givenAttributes);
        }
        return tableAttributesMap;
    }

    public void setAttributesForMos(Map tableAttributesMap, TableData tableData) throws CrbsAueException, TableDataException {
        Iterator iterator = tableAttributesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.setAttributes((String)entry.getKey(), tableData, (Map)entry.getValue());
        }
    }

    public String createArrayXmlString(String attributeName, String attributeType, String attributesAsString, String separator) {
        ArrayList<String> attributeList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(attributesAsString, separator);
        while (tokenizer.hasMoreElements()) {
            String stringValue = tokenizer.nextElement().toString();
            attributeList.add(this.createAttributeXml(stringValue, attributeType));
        }
        return this.createArrayXmlString(attributeName, attributeList);
    }

    public String createAttributeXml(String attributeValue, String attributeType) {
        return "<attr type=\"" + attributeType + "\" value=\"" + attributeValue + "\"/>";
    }
}

