/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.equipment.CppBoardMarker;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.extethswitch.EthernetBridgePortExtMoFactory;
import se.ericsson.cello.extethswitch.EthernetPortMoFactory;
import se.ericsson.cello.extethswitch.EthernetPortMoImpl;
import se.ericsson.cello.extethswitch.EthernetSwitchModuleMoGen;
import se.ericsson.cello.extethswitch.ExtethswitchUtil;
import se.ericsson.cello.extethswitch.LagMoFactory;
import se.ericsson.cello.extethswitch.LagMoImpl;
import se.ericsson.cello.extethswitch.SwitchStpMoFactory;
import se.ericsson.cello.extethswitch.mom.StructEthModOperatingMode2;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Coordinator;

public class EthernetSwitchModuleMoImpl
extends EthernetSwitchModuleMoGen
implements FroInfo,
CppBoardMarker {
    private static final String CAX_EBP_RDN = "EthernetBridgePort=BackPlaneLinkEBP1";
    private static final String CAX_LAG_RDN = "Lag=BackPlaneLinkLag1";
    private static final String CAX_EP_RDN = "EthernetPort=BackPlaneLinkEP";
    private static final int MAX_NO_ETHERNET_PORT = 12;
    private static final String PIU_FRO_ID = "piuFroId";
    private static int SLOT_1 = 1;
    private static int SLOT_27 = 27;
    private static final String SMX_LAG_RDN = "Lag=CrossLinkLag1";
    private static final int MAX_NO_ETHERNET_PORT_SMXB = 4;
    private static final String SMX_EP_RDN = "EthernetPort=CrossLinkEP";

    public EthernetSwitchModuleMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, SwitchStpMoFactory switchStpMoFactory) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler, switchStpMoFactory);
        this.createCAXMOs(managedObject, coordinator);
    }

    public EthernetSwitchModuleMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        Coordinator coordinator = setRequestContext.getCoordinator();
        this.checkSlotNumberIfSMXB(managedObject, coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter(PIU_FRO_ID, ((FroInfo)this.getParent()).getFroId(coordinator)));
    }

    private void checkSlotNumberIfSMXB(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        SlotMo slotMo;
        boolean bl = ExtethswitchUtil.isSMXB(coordinator);
        if (bl && (slotMo = (SlotMo)ExtethswitchUtil.getSlotMo(managedObject, coordinator)) != null) {
            int n = slotMo.getSlotNumber(coordinator);
            if (n != SLOT_1 && n != SLOT_27) {
                throw new MoCanNotBeCreatedException("EthernetSwitchModuleMO can only be created either in Slot 1 or Slot 27 on node configured with SMXB");
            }
            this.createSMXBMOs(managedObject, coordinator, bl);
        }
    }

    private void createSMXBMOs(ManagedObject managedObject, Coordinator coordinator, boolean bl) throws MoAccessException {
        String string = null;
        ManagedObject[] managedObjectArray = new ManagedObject[4];
        int n = 16;
        if (bl) {
            Object object;
            for (int i = 0; i < 4; ++i) {
                string = "CrossLinkEP" + n;
                object = new AttrListImpl();
                String[] stringArray = StructEthModOperatingMode2.ELEMENT_NAMES;
                Object[] objectArray = new Object[]{false, new Integer(8)};
                StructImpl structImpl = new StructImpl(stringArray, objectArray);
                object.addElement("operatingMode", (Object)structImpl);
                object.addElement("portNo", (Object)new Integer(n));
                EthernetPortMoFactory ethernetPortMoFactory = (EthernetPortMoFactory)MoFactoryMgr.instance().lookup("EthernetPort");
                EthernetPortMoImpl ethernetPortMoImpl = (EthernetPortMoImpl)ethernetPortMoFactory.createMo(managedObject, (AttrList)object, string, null, coordinator);
                managedObjectArray[i] = ethernetPortMoImpl;
                if (++n != 18) continue;
                ++n;
            }
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("lacpMode", (Object)new Integer(1));
            attrListImpl.addElement("ethernetPortRef", (Object)managedObjectArray);
            object = (LagMoFactory)MoFactoryMgr.instance().lookup("Lag");
            ((LagMoFactory)object).createMo(managedObject, (AttrList)attrListImpl, "CrossLinkLag1", null, coordinator);
        }
    }

    private void createCAXMOs(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        String string = null;
        ManagedObject[] managedObjectArray = new ManagedObject[12];
        int n = 1;
        int n2 = 13;
        if (ExtethswitchUtil.isCaxSubrack(managedObject, coordinator)) {
            Object object;
            AttrListImpl attrListImpl;
            ManagedObject managedObject2;
            Object object2;
            for (int i = 0; i < 12; ++i) {
                string = "BackPlaneLinkEP" + n++;
                object2 = new AttrListImpl();
                managedObject2 = StructEthModOperatingMode2.ELEMENT_NAMES;
                attrListImpl = new AttrListImpl[]{Boolean.valueOf(false), new Integer(7)};
                object = new StructImpl((String[])managedObject2, (Object[])attrListImpl);
                object2.addElement("operatingMode", object);
                object2.addElement("portNo", (Object)new Integer(n2));
                EthernetPortMoFactory ethernetPortMoFactory = (EthernetPortMoFactory)MoFactoryMgr.instance().lookup("EthernetPort");
                EthernetPortMoImpl ethernetPortMoImpl = (EthernetPortMoImpl)ethernetPortMoFactory.createMo(managedObject, (AttrList)object2, string, null, coordinator);
                managedObjectArray[i] = ethernetPortMoImpl;
                ++n2;
            }
            AttrListImpl attrListImpl2 = new AttrListImpl();
            attrListImpl2.addElement("lacpMode", (Object)new Integer(1));
            attrListImpl2.addElement("ethernetPortRef", (Object)managedObjectArray);
            object2 = (LagMoFactory)MoFactoryMgr.instance().lookup("Lag");
            managedObject2 = ((LagMoFactory)object2).createMo(managedObject, (AttrList)attrListImpl2, "BackPlaneLinkLag1", null, coordinator);
            attrListImpl = new AttrListImpl();
            attrListImpl.addElement("physicalPortRef", (Object)managedObject2);
            object = (EthernetBridgePortExtMoFactory)MoFactoryMgr.instance().lookup("EthernetBridgePort");
            ((EthernetBridgePortExtMoFactory)object).createMo(this, (AttrList)attrListImpl, "BackPlaneLinkEBP1", null, coordinator);
        }
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter(PIU_FRO_ID, ((PlugInUnitMo)this.getParent()).getResourceId(setRequestContext.getCoordinator())));
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        if (ExtethswitchUtil.isCaxSubrack(this.getParent(), coordinator)) {
            this.deleteAutocreatedBackPlaneLink(coordinator);
        }
        if (ExtethswitchUtil.isSMXB(coordinator)) {
            this.deleteAutocreatedCrossLink(coordinator);
        }
    }

    private void deleteAutocreatedCrossLink(Coordinator coordinator) throws MoAccessException {
        String string = this.getParent().getLocalDistinguishedName();
        String string2 = string + "," + SMX_LAG_RDN;
        ManagedObject managedObject = MoRepository.instance().lookup(string2);
        if (managedObject != null) {
            ((LagMoImpl)managedObject).deleteAutocreatedCrossLink(coordinator, true);
        }
        for (int i = 16; i <= 20; ++i) {
            if (i == 18) {
                ++i;
            }
            String string3 = string + "," + SMX_EP_RDN + i;
            ManagedObject managedObject2 = MoRepository.instance().lookup(string3);
            if (managedObject2 == null) continue;
            managedObject2.delete(coordinator);
        }
    }

    private void deleteAutocreatedBackPlaneLink(Coordinator coordinator) throws MoAccessException {
        String string = this.getLocalDistinguishedName();
        String string2 = string + "," + CAX_EBP_RDN;
        ManagedObject managedObject = MoRepository.instance().lookup(string2);
        if (managedObject != null) {
            managedObject.delete(coordinator);
        }
        String string3 = this.getParent().getLocalDistinguishedName();
        String string4 = string3 + "," + CAX_LAG_RDN;
        ManagedObject managedObject2 = MoRepository.instance().lookup(string4);
        if (managedObject2 != null) {
            managedObject2.delete(coordinator);
        }
        for (int i = 1; i <= 12; ++i) {
            String string5 = string3 + "," + CAX_EP_RDN + i;
            ManagedObject managedObject3 = MoRepository.instance().lookup(string5);
            if (managedObject3 == null) continue;
            managedObject3.delete(coordinator);
        }
    }

    public int getFroType() throws MoAccessException {
        return Integer.parseInt("D04", 16);
    }
}

