/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.equipment.SubrackProdTypeMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class ExtethswitchUtil {
    private static String PRODUCT_NUMBER_CMXB1 = "ROJ208504";
    private static String SMXB_PRODUCT_NUMBER_1 = "ROJ208476";
    private static String SMXB_PRODUCT_NUMBER_2 = "ROJ208482";
    public static final String PBIT = "pbit";
    public static final String QUEUE = "queue";
    private static String SLOT = "Slot";
    private static String PRODUCTDATA = "productData";
    private static String SLOTNUMBER = "slotNumber";
    private static int SLOT_1 = 1;
    private static int SLOT_27 = 27;

    protected static boolean isCaxPlugInUnit(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (!managedObject.getType().equals("PlugInUnit")) {
            return false;
        }
        SubrackMo subrackMo = (SubrackMo)managedObject.getParent().getParent();
        SubrackProdTypeMo subrackProdTypeMo = (SubrackProdTypeMo)subrackMo.getSubrackProdTypeRef(coordinator);
        return subrackProdTypeMo.getFanConfiguration(coordinator) == 5;
    }

    protected static boolean isOnCCIBPiu(ManagedObject managedObject) throws MoAccessException {
        boolean bl = true;
        String string = managedObject.getLocalDistinguishedName();
        if (string.indexOf("Slot=1") == -1 && string.indexOf("Slot=4") == -1) {
            bl = false;
        }
        return bl;
    }

    protected static boolean isControlEthernetPort(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        return managedObject != null && ExtethswitchUtil.isCaxPlugInUnit(managedObject.getParent(), coordinator) && ExtethswitchUtil.isOnCCIBPiu(managedObject);
    }

    protected static boolean isSMXB(Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        MoIterator moIterator = MoRepository.instance().lookupType(SLOT);
        while (moIterator != null && moIterator.hasMoreElements()) {
            String string;
            String string2;
            Struct struct;
            SlotMo slotMo = (SlotMo)moIterator.nextMo();
            int n = slotMo.getSlotNumber(coordinator);
            if (n == SLOT_1 && (struct = slotMo.getProductData(coordinator)) != null && ((string2 = Lib.optimize((String)(string = (String)struct.getValue("productNumber")))).startsWith(SMXB_PRODUCT_NUMBER_1) || string2.startsWith(SMXB_PRODUCT_NUMBER_2))) {
                bl = true;
            }
            if (n != SLOT_27 || bl || (struct = (Struct)slotMo.getAttribute("productData", coordinator)) == null || !(string2 = Lib.optimize((String)(string = (String)struct.getValue("productNumber")))).startsWith(SMXB_PRODUCT_NUMBER_1) && !string2.startsWith(SMXB_PRODUCT_NUMBER_2)) continue;
            bl = true;
        }
        return bl;
    }

    protected static ManagedObject getSlotMo(ManagedObject managedObject, Coordinator coordinator) {
        while (managedObject != null) {
            if (managedObject instanceof SlotMo) {
                return managedObject;
            }
            managedObject = managedObject.getParent();
        }
        return null;
    }

    protected static boolean isCaxSubrack(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        SubrackProdTypeMo subrackProdTypeMo = null;
        ManagedObject managedObject2 = ExtethswitchUtil.getSubRackMo(managedObject, coordinator);
        if (managedObject2 != null) {
            subrackProdTypeMo = (SubrackProdTypeMo)((SubrackMo)managedObject2).getSubrackProdTypeRef(coordinator);
        }
        if (subrackProdTypeMo != null && subrackProdTypeMo.getFanConfiguration(coordinator) == 5) {
            bl = true;
        }
        return bl;
    }

    protected static ManagedObject getSubRackMo(ManagedObject managedObject, Coordinator coordinator) {
        while (managedObject != null) {
            if (managedObject instanceof SubrackMo) {
                return managedObject;
            }
            managedObject = managedObject.getParent();
        }
        return null;
    }

    protected static boolean isHSC_CMXB(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        MoIterator moIterator = MoRepository.instance().lookupType(SLOT);
        while (moIterator != null && moIterator.hasMoreElements()) {
            String string;
            String string2;
            ManagedObject managedObject2 = moIterator.nextMo();
            Struct struct = ((SlotMo)managedObject2).getProductData(coordinator);
            if (struct == null || !(string2 = Lib.optimize((String)(string = (String)struct.getValue("productNumber")))).startsWith(PRODUCT_NUMBER_CMXB1)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

