/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.extethswitch.EthernetPortMo;
import se.ericsson.cello.extethswitch.EthernetPortMoImpl;
import se.ericsson.cello.extethswitch.LagMo;
import se.ericsson.cello.extethswitch.VlanPortMoGen;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;

public class VlanPortMoImpl
extends VlanPortMoGen {
    public VlanPortMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList);
    }

    public VlanPortMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy);
    }

    protected void validatePortRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        super.validatePortRef(managedObject, setRequestContext);
        if (!(managedObject instanceof EthernetPortMo) && !(managedObject instanceof LagMo)) {
            throw new ConfigurationMismatchException("portRef must be of type EthernetPortMo or LagMo", "VlanPort");
        }
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        ManagedObject managedObject = null;
        int n = 0;
        n = ((PlugInUnitMo)this.getParent()).getFroId(coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuFroId", n));
        if (setRequestContext.isIncludedInRequest("portRef")) {
            managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("portRef");
            if (managedObject instanceof EthernetPortMo) {
                EthernetPortMoImpl.checkPortNumber(managedObject, setRequestContext.getCoordinator(), "VlanPort", "portRef");
                setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("portRefType", 0));
            } else if (managedObject instanceof LagMo) {
                setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("portRefType", 1));
            }
        }
    }

    protected void validateVid(int n, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateVid(n, setRequestContext);
        if (n == 4094) {
            throw new IllegalAttributeValueException("VlanPort MO with Vid  as 4094 is not allowed as it is is reserved for CMX internal use.", "vid", "VlanPort");
        }
    }
}

