/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import enea.ose.system.UnlinkedSignal;
import se.ericsson.cello.common.fropxy.MoEventable;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.Ds0BundleBuildIF;
import se.ericsson.cello.pdhsdhtrans.E1TtpMo;
import se.ericsson.cello.pdhsdhtrans.ImaLinkBuildIF;
import se.ericsson.cello.pdhsdhtrans.ImaReservable;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermRepositoryImpl;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiNoCRCMFEInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiSetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1Proxy;
import se.ericsson.cello.transaction.Coordinator;

public class E1TtpMoImpl
extends CelloMao
implements E1TtpMo,
TrafficReservable,
MoEventable,
ImaReservable {
    private static final int RESULT_OK = 0;
    private static final int DEGDEGTHR_MIN = 0;
    private static final int DEGDEGTHR_MAX = 100;
    private static final int DEGDEGM_MIN = 2;
    private static final int DEGDEGM_MAX = 10;
    private static final int CRC4_MODE_OFF = 0;
    private static final int CRC4_MODE_ON = 1;
    private static final int CRC4_MODE_AUTOMATIC = 2;
    private static final int IDLE_PATTERN_UNDEFINED = 0;
    private static final int IDLE_PATTERN_A_LAW = 1;
    private static final int IDLE_PATTERN_MICRO_LAW = 2;
    private static final String DEFAULT_USERLABEL = "";
    private static final int TYPE_DEG_DEG_THR = 24;
    private static final int TYPE_DEG_DEG_M = 25;
    private static final int TYPE_AIS_REPORTING = 26;
    private static final int TYPE_RDI_REPORTING = 27;
    private static final int TYPE_CRC_4_MODE = 28;
    private static final int TYPE_IDLE_PATTERN = 29;
    private static final int TYPE_OPERATIONAL_STATE = 2;
    private static final int TYPE_AVAILABILITY_STATUS = 3;
    private static final String E1TTP_FRO_ID = "e1TtpFroId";
    private static final Class[] reservedClassesForTrafficReserve = new Class[]{AtmPortBuildIF.class};
    private MoData data;
    private IntegerAttribute e1TtpFroId;
    private StringAttribute userLabel;
    private ReferenceAttribute reservedBy;
    private ReferenceAttribute reservedByImaLink;
    private static PhyE1Proxy phyE1Proxy = PhyE1Proxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static PhysPathTermRepositoryImpl repository = PhysPathTermRepositoryImpl.instance();
    private static final int MO_DATA_REVISION_35 = 3500;
    private static final int MO_DATA_REVISION_36 = 3600;
    private static final int MO_DATA_REVISION_LATEST = 3600;

    static E1TtpMoImpl create(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"E1Ttp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Vc12Ttp");
        return new E1TtpMoImpl(managedObject, n, string, coordinator);
    }

    private E1TtpMoImpl(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "E1Ttp", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.e1TtpFroId = new IntegerAttribute(E1TTP_FRO_ID, false, n);
        this.data.registerPersistentAttr((Attribute)this.e1TtpFroId);
        this.userLabel = new StringAttribute("userLabel", true, DEFAULT_USERLABEL);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new ReferenceAttribute("reservedBy", false);
        this.reservedBy.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.reservedByImaLink = new ReferenceAttribute("reservedByImaLink", false);
        this.reservedByImaLink.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedByImaLink);
        this.data.setRevision(3600);
        phyE1Proxy.registerForNotifications(coordinator, this, this.e1TtpFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        repository.register(n, this, coordinator);
    }

    public E1TtpMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3600);
        moDataRecoveryHelper.assertAttribute(E1TTP_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("reservedByImaLink");
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.e1TtpFroId = (IntegerAttribute)moData.getAttribute(E1TTP_FRO_ID);
        this.reservedBy = (ReferenceAttribute)moData.getAttribute("reservedBy");
        this.reservedByImaLink = (ReferenceAttribute)moData.getAttribute("reservedByImaLink");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        phyE1Proxy.registerForNotifications(null, this, this.e1TtpFroId.getValue(null));
        repository.register(this.e1TtpFroId.getValue(null), this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedBy.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("E1Ttp");
        }
        if (this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("E1Ttp");
        }
        phyE1Proxy.deregisterForNotifications(coordinator, this.e1TtpFroId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
        repository.remove(this.e1TtpFroId.getValue(coordinator), coordinator);
    }

    public int getDegDegThr(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = this.getE1TtpAttribute(coordinator, 24);
        return phyE1MiGetAttributeRsp.getValue();
    }

    public void setDegDegThr(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0 || n > 100) {
            throw new ValueOutOfRangeException("degDegThr", "E1Ttp");
        }
        this.setE1TtpAttribute(coordinator, 24, n);
        String[] stringArray = new String[]{"degDegThr"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getDegDegM(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = this.getE1TtpAttribute(coordinator, 25);
        return phyE1MiGetAttributeRsp.getValue();
    }

    public void setDegDegM(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 2 || n > 10) {
            throw new ValueOutOfRangeException("degDegM", "E1Ttp");
        }
        this.setE1TtpAttribute(coordinator, 25, n);
        String[] stringArray = new String[]{"degDegM"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getAisReporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = this.getE1TtpAttribute(coordinator, 26);
        return MaoFroTypeConverter.int2boolean((int)phyE1MiGetAttributeRsp.getValue());
    }

    public void setAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.setE1TtpAttribute(coordinator, 26, MaoFroTypeConverter.boolean2int((boolean)bl));
        String[] stringArray = new String[]{"aisReporting"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getRdiReporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = this.getE1TtpAttribute(coordinator, 27);
        return MaoFroTypeConverter.int2boolean((int)phyE1MiGetAttributeRsp.getValue());
    }

    public void setRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.setE1TtpAttribute(coordinator, 27, MaoFroTypeConverter.boolean2int((boolean)bl));
        String[] stringArray = new String[]{"rdiReporting"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getCrc4Mode(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = this.getE1TtpAttribute(coordinator, 28);
        return phyE1MiGetAttributeRsp.getValue();
    }

    public void setCrc4Mode(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("crc4Mode", "E1Ttp");
        }
        this.setE1TtpAttribute(coordinator, 28, n);
        String[] stringArray = new String[]{"crc4Mode"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getIdlePattern(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = this.getE1TtpAttribute(coordinator, 29);
        return phyE1MiGetAttributeRsp.getValue();
    }

    public void setIdlePattern(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("idlePattern", "E1Ttp");
        }
        this.setE1TtpAttribute(coordinator, 29, n);
        String[] stringArray = new String[]{"idlePattern"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = this.getE1TtpAttribute(coordinator, 2);
        return phyE1MiGetAttributeRsp.getValue();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = this.getE1TtpAttribute(coordinator, 3);
        return AvailConverter.convert((int)phyE1MiGetAttributeRsp.getValue());
    }

    public int getPmEs(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmEs", coordinator);
    }

    public int getPmSes(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmSes", coordinator);
    }

    public int getPmUas(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmUas", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"E1Ttp", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = new ManagedObject[]{this.reservedBy.getValue(coordinator)};
        if (managedObjectArray[0] == null) {
            return new ManagedObject[0];
        }
        return managedObjectArray;
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.reservedBy.getValue(coordinator) instanceof AtmPortBuildIF) {
            return this.reservedBy.getValue(coordinator);
        }
        return null;
    }

    public ManagedObject getReservedByImaLink(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByImaLink.getValue(coordinator);
    }

    public String getType() {
        return "E1Ttp";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.e1TtpFroId.getValue(coordinator);
    }

    private boolean checkChildren(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof Ds0BundleBuildIF)) continue;
            if (((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator) != null) {
                ManagedObject managedObject2 = ((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator);
                return !(managedObject2 instanceof AtmPortBuildIF);
            }
            return true;
        }
        return false;
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("E1Ttp", "null reference");
        }
        if (this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoNotPossibleToReserveException("has been reserved by ImaLink", this.getType());
        }
        if (this.getChildren().hasMoreElements()) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        this.reservedBy = ReservableImpl.trafficReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (Class[])reservedClassesForTrafficReserve);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBy = ReservableImpl.trafficRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (Class[])reservedClassesForTrafficReserve);
    }

    private PhyE1MiGetAttributeRsp getE1TtpAttribute(Coordinator coordinator, int n) throws MoAccessException {
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = phyE1Proxy.sendPhyE1MiGetAttributeReq(n2, this.e1TtpFroId.getValue(coordinator), n);
        if (phyE1MiGetAttributeRsp == null) {
            throw new FroNotAccessibleException("E1Ttp", "E1PhysPathTermFro");
        }
        if (phyE1MiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1Ttp", "E1PhysPathTermFro", "GetAttrReq: " + phyE1Proxy.getResultMsg(phyE1MiGetAttributeRsp.getResult()), phyE1MiGetAttributeRsp.getResult());
        }
        return phyE1MiGetAttributeRsp;
    }

    private void setE1TtpAttribute(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyE1MiSetAttributeRsp phyE1MiSetAttributeRsp = phyE1Proxy.sendPhyE1MiSetAttributeReq(coordinator.getTransactionID(), this.e1TtpFroId.getValue(coordinator), n2, n);
        if (phyE1MiSetAttributeRsp == null) {
            throw new FroNotAccessibleException("E1Ttp", "E1PhysPathTermFro");
        }
        if (phyE1MiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1Ttp", "E1PhysPathTermFro", "SetAttrReq: " + phyE1Proxy.getResultMsg(phyE1MiSetAttributeRsp.getResult()), phyE1MiSetAttributeRsp.getResult());
        }
    }

    public void eventRaised(UnlinkedSignal unlinkedSignal, String string) {
        if (unlinkedSignal instanceof PhyE1MiNoCRCMFEInd) {
            AlarmManager.getReporter().reportEvent(12, (ManagedObject)this, DEFAULT_USERLABEL, DEFAULT_USERLABEL, null);
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("E1Ttp", "null reference");
        }
        if (this.checkChildren(coordinator)) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        if (managedObject instanceof ImaLinkBuildIF) {
            if (this.reservedBy.getValue(coordinator) != null) {
                throw new MoNotPossibleToReserveException("Already reserved by " + this.reservedBy.getValue(coordinator).getLocalDistinguishedName(), this.getType());
            }
            this.reservedByImaLink = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink);
        } else {
            if (this.reservedByImaLink.getValue(coordinator) != null) {
                throw new MoNotPossibleToReserveException("Already reserved by " + this.reservedByImaLink.getValue(coordinator).getLocalDistinguishedName(), this.getType());
            }
            this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy);
        }
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException("E1Ttp", "null reference");
        }
        if (managedObject instanceof ImaLinkBuildIF) {
            this.reservedByImaLink = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink);
        } else {
            this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy);
        }
    }
}

