/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.impl.CreateMoHelper;
import se.ericsson.wcdma.rbs.boam.main.BoamMain;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RetProfileMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class GenericRetProfilesAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "10/109 26-CRH 109 042/1-5";
    private static int NO_RECOGNIZABLE_MO_ID_DEFINED_FOR_EXISTING_RET_PROFILES = 0;
    private static final GenericRetProfilesAue INSTANCE = new GenericRetProfilesAue();
    private boolean foundRetProfJar = false;
    private boolean foundRetProps = false;
    private Properties retProperties = null;

    public GenericRetProfilesAue() {
        super(GenericRetProfilesAue.class);
    }

    public static GenericRetProfilesAue instance() {
        return INSTANCE;
    }

    public int getLowVersion() {
        return BoamMain.getBoamDataRev();
    }

    public int getHighVersion() {
        return BoamMain.getBoamDataRev() + 1;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        Coordinator context = tw.getCoordinator();
        AueProxy.instance();
        try {
            Vector newProfiles = this.initDataWithNewProfiles();
            if (newProfiles == null) {
                return true;
            }
            Vector vExistingRetProfiles = this.readExistingRetProfilesIntoVector(context);
            int iHighestMoId = this.calculateHighestDefinedMoIdForExistingRetProfiles(vExistingRetProfiles);
            this.updateNewRetProfilesWithNewMoIds(newProfiles, iHighestMoId);
            for (int i = 0; i < vExistingRetProfiles.size(); ++i) {
                RetProfileData existingRetProfile = (RetProfileData)vExistingRetProfiles.get(i);
                RetProfileData newRetProfile = this.lookupProfileWithType(existingRetProfile, newProfiles);
                if (newRetProfile != null) {
                    if (existingRetProfile.isEqual(newRetProfile) || newRetProfile.isCustomProfile()) {
                        newProfiles.remove(newRetProfile);
                        continue;
                    }
                    this.trace("Changed parameters in profile  = " + existingRetProfile + " ,ignored");
                    newProfiles.remove(newRetProfile);
                    continue;
                }
                if (!existingRetProfile.isStandardProfile() || newProfiles.size() <= 0) continue;
                this.info("Existing RET Profile not found in Upgrade Package :" + existingRetProfile);
            }
            ManagedObject retProfilesParent = null;
            if (vExistingRetProfiles.size() != 0) {
                RetProfileData someOldRetProfile = (RetProfileData)vExistingRetProfiles.get(0);
                retProfilesParent = someOldRetProfile.retProfileMo.getParent();
            }
            this.createNewProfiles(newProfiles, retProfilesParent, context);
            this.info("\n Aue finished successfully!!");
            return true;
        }
        catch (Exception e) {
            this.traceError("execute failed due to exception: ", e);
            return false;
        }
    }

    private RetProfileData lookupProfileWithType(RetProfileData prof, Vector vec) {
        for (int i = 0; i < vec.size(); ++i) {
            RetProfileData foundProf = (RetProfileData)vec.get(i);
            if (prof.antennaType != foundProf.antennaType || prof.retType != foundProf.retType) continue;
            return foundProf;
        }
        return null;
    }

    private void createNewProfiles(Vector newRetProfiles, ManagedObject retProfilesParent, Coordinator context) throws Exception {
        this.traceEnter("createNewProfiles()");
        if (retProfilesParent == null) {
            retProfilesParent = this.readRetProfilesParent();
        }
        for (int i = 0; i < newRetProfiles.size(); ++i) {
            RetProfileData retProfile = (RetProfileData)newRetProfiles.get(i);
            AttrListImpl attrs = new AttrListImpl();
            attrs.insert("retType", (Object)new Integer(retProfile.retType));
            attrs.insert("antennaType", (Object)new Integer(retProfile.antennaType));
            attrs.insert("maxTilt", (Object)new Integer(retProfile.maxTilt));
            attrs.insert("minTilt", (Object)new Integer(retProfile.minTilt));
            attrs.insert("retParam1", (Object)new Integer(retProfile.retParam1));
            attrs.insert("retParam2", (Object)new Integer(retProfile.retParam2));
            attrs.insert("retParam3", (Object)new Integer(retProfile.retParam3));
            attrs.insert("retParam4", (Object)new Integer(retProfile.retParam4));
            attrs.insert("retParam5", (Object)new Integer(retProfile.retParam5));
            attrs.insert("retParam6", (Object)new Integer(retProfile.retParam6));
            attrs.insert("retParam7", (Object)new Integer(retProfile.retParam7));
            attrs.insert("retParam8", (Object)new Integer(retProfile.retParam8));
            attrs.insert("checkSum", (Object)new Integer(retProfile.checkSum));
            String parentFdn = retProfilesParent == null ? "null" : retProfilesParent.getFullDistinguishedName();
            this.info("creating new RetProfile=" + retProfile.moId + " retType = " + retProfile.retType + " antennaType = " + retProfile.antennaType + " with parent " + parentFdn);
            CreateMoHelper.createMo("RetProfile", retProfilesParent, retProfile.moId, attrs, context);
        }
    }

    private ManagedObject readRetProfilesParent() {
        this.traceEnter("readRetProfilesParent()");
        ManagedObject moResult = null;
        MoIterator equipments = FindMo.findMOs("Equipment");
        if (equipments.hasMoreElements()) {
            moResult = equipments.nextMo();
        }
        return moResult;
    }

    private void updateNewRetProfilesWithNewMoIds(Vector newRetProfiles, int iHighestExistingMoId) {
        this.traceEnter("updateNewRetProfilesWithNewMoIds()");
        int newMoId = iHighestExistingMoId + 1;
        for (int i = 0; i < newRetProfiles.size(); ++i) {
            RetProfileData retProfile = (RetProfileData)newRetProfiles.get(i);
            retProfile.moId = newMoId + "";
            ++newMoId;
        }
    }

    private int calculateHighestDefinedMoIdForExistingRetProfiles(Vector vExistingRetProfiles) {
        this.traceEnter("calculateHighestDefinedMoIdForExistingRetProfiles()");
        int iResult = NO_RECOGNIZABLE_MO_ID_DEFINED_FOR_EXISTING_RET_PROFILES;
        for (int i = 0; i < vExistingRetProfiles.size(); ++i) {
            RetProfileData retProfile = (RetProfileData)vExistingRetProfiles.get(i);
            try {
                this.trace("examine MO ID = " + retProfile.moId);
                int iTmpMoId = Integer.parseInt(retProfile.moId);
                if (iTmpMoId <= iResult) continue;
                iResult = iTmpMoId;
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        this.trace("highest MO ID from existing RetProfiles is " + iResult);
        return iResult;
    }

    private ManagedObject findExecutingUp() throws MoAccessException {
        String UP_STATE_ATTR = "state";
        int UPGRADE_EXECUTING = 2;
        String UP_MO_TYPE = "UpgradePackage";
        MoIterator i = FindMo.findMOs("UpgradePackage");
        while (i.hasMoreElements()) {
            ManagedObject upgradePackageMo = i.nextMo();
            try {
                Integer state = (Integer)upgradePackageMo.getAttribute("state", null);
                if (state != 2) continue;
                return upgradePackageMo;
            }
            catch (MoAccessException e) {
                this.traceError("could not get state from UP :" + upgradePackageMo.getLocalDistinguishedName(), e);
            }
        }
        this.traceError("could not find any UpgradePackageMo where (state = EnumUpgradePackageState.UPGRADE_EXECUTING)");
        throw new CreationOfRetProfileFailedException("could not find any UpgradePackageMo where (state = EnumUpgradePackageState.UPGRADE_EXECUTING)");
    }

    private Vector initDataWithNewProfiles() throws MoAccessException, FileNotFoundException, IOException {
        this.traceEnter("initDataWithNewProfiles()");
        Vector vResult = new Vector();
        ManagedObject upMo = this.findExecutingUp();
        if (upMo == null) {
            return null;
        }
        ManagedObject[] lms = (ManagedObject[])upMo.getAttribute("loadModuleList", null);
        ArrayList<String> retProfileList = new ArrayList<String>();
        String retProfFileName = "";
        for (int i = 0; i < lms.length && this.breakIfJarFile(retProfFileName, i == lms.length); ++i) {
            String path;
            Integer loaderType = (Integer)lms[i].getAttribute("loaderType", null);
            if (loaderType != 3 || (retProfFileName = this.findRetProfFileName(path = (String)lms[i].getAttribute("loadModuleFilePath", null))) == null) continue;
            if (retProfFileName.endsWith("RetProfile.properties")) {
                this.retProperties = new Properties();
                this.retProperties.load(new FileInputStream(retProfFileName));
                continue;
            }
            if (retProfFileName.indexOf("jar") == -1) {
                retProfileList.add(retProfFileName);
                continue;
            }
            if (retProfFileName.indexOf("jar") == -1) continue;
            retProfileList.clear();
            retProfileList.add(retProfFileName);
        }
        for (int j = 0; j < retProfileList.size(); ++j) {
            this.addRetProfileDataFromFile((String)retProfileList.get(j), vResult);
        }
        this.foundRetProps = false;
        this.foundRetProfJar = false;
        if (vResult.size() == 0) {
            this.info("Could not find any RET profiles ");
        }
        return vResult;
    }

    private boolean breakIfJarFile(String retProfFileName, boolean allLoadModules) {
        if (allLoadModules) {
            return false;
        }
        if (retProfFileName == null) {
            return true;
        }
        if (retProfFileName.indexOf("jar") == -1) {
            return true;
        }
        if (retProfFileName.endsWith("RetProfile.properties")) {
            this.foundRetProps = true;
        } else {
            this.foundRetProfJar = true;
        }
        return !this.foundRetProps || !this.foundRetProfJar;
    }

    private String findRetProfFileName(String lmPath) throws CreationOfRetProfileFailedException {
        this.traceEnter("findRetProfFileName checking directory :" + lmPath);
        File dir = new File(lmPath, "em/rbs/RET/");
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String fName = files[i].getAbsolutePath();
                if (fName.indexOf("txt") != -1 && fName.indexOf("ret") != -1 && fName.indexOf("profile") != -1 && !this.foundRetProfJar) {
                    if (files.length != 1) {
                        throw new CreationOfRetProfileFailedException(" Can not handel more  than one unarchived Retprofile per LoadModule  , found :" + files.length + " files in " + lmPath);
                    }
                    this.traceEnter("Found RET profile :" + fName);
                    return fName;
                }
                if (fName.indexOf("bemretprofiles") != -1 && fName.indexOf("jar") != -1 && !this.foundRetProfJar) {
                    this.foundRetProfJar = true;
                    this.traceEnter("Found RET profile Jar:" + fName);
                    return fName;
                }
                if (!fName.endsWith("RetProfile.properties") || this.foundRetProps) continue;
                this.foundRetProps = true;
                this.traceEnter("Found RetProfile.properties:" + fName);
                return fName;
            }
        }
        return null;
    }

    private int getIntProp(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            this.trace("could not find property :" + name + " in :" + props);
            return -1;
        }
        return Integer.parseInt(str);
    }

    private void addRetProfileDataFromFile(String retProfilePath, Vector vResult) throws MoAccessException {
        Properties inputFile = new Properties();
        try {
            if (retProfilePath.indexOf("jar") == -1) {
                inputFile.load(new FileInputStream(retProfilePath));
                this.updateResults(inputFile, vResult);
            } else if (this.retProperties != null) {
                Iterator<Object> repProfile = this.retProperties.values().iterator();
                while (repProfile.hasNext()) {
                    String profile = (String)repProfile.next();
                    JarFile jarFile = new JarFile(new File(retProfilePath));
                    JarEntry entry = jarFile.getJarEntry(profile);
                    InputStream ioStream = jarFile.getInputStream(entry);
                    inputFile.load(ioStream);
                    ioStream.close();
                    this.updateResults(inputFile, vResult);
                }
            } else {
                this.traceError("could not retrieve ret profile from archive file, reason being RetProfile.properties = null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.traceError("could not read ret profile file :" + retProfilePath, e);
            throw new CreationOfRetProfileFailedException("could not read ret profile file :" + retProfilePath);
        }
    }

    private void updateResults(Properties inputFile, Vector vResult) {
        RetProfileData retProfile = new RetProfileData(null, "", this.getIntProp(inputFile, "RET_TYPE"), this.getIntProp(inputFile, "ANTENNA_TYPE"), this.getIntProp(inputFile, "MIN_TILT"), this.getIntProp(inputFile, "MAX_TILT"), this.getIntProp(inputFile, "RET_PARAM1"), this.getIntProp(inputFile, "RET_PARAM2"), this.getIntProp(inputFile, "RET_PARAM3"), this.getIntProp(inputFile, "RET_PARAM4"), this.getIntProp(inputFile, "RET_PARAM5"), this.getIntProp(inputFile, "RET_PARAM6"), this.getIntProp(inputFile, "RET_PARAM7"), this.getIntProp(inputFile, "RET_PARAM8"), this.getIntProp(inputFile, "CHECKSUM_VALUES"));
        vResult.add(retProfile);
    }

    private Vector readExistingRetProfilesIntoVector(Coordinator c) throws Exception {
        Vector<RetProfileData> vResult = new Vector<RetProfileData>();
        MoIterator retProfiles = FindMo.findMOs("RetProfile");
        while (retProfiles.hasMoreElements()) {
            RetProfileMo theRetProfile = (RetProfileMo)retProfiles.nextMo();
            this.trace("examining existing RetProfile " + theRetProfile.getFullDistinguishedName());
            int retType = theRetProfile.getRetType(c);
            int antennaType = theRetProfile.getAntennaType(c);
            String moId = theRetProfile.getNamingAttributeValue();
            this.trace("retType = " + retType + " antennaType = " + antennaType);
            vResult.add(new RetProfileData((ManagedObject)theRetProfile, moId, retType, antennaType, theRetProfile.getMinTilt(c), theRetProfile.getMaxTilt(c), theRetProfile.getRetParam1(c), theRetProfile.getRetParam2(c), theRetProfile.getRetParam3(c), theRetProfile.getRetParam4(c), theRetProfile.getRetParam5(c), theRetProfile.getRetParam6(c), theRetProfile.getRetParam7(c), theRetProfile.getRetParam8(c), theRetProfile.getCheckSum(c)));
        }
        return vResult;
    }

    private class RetProfileData {
        public final ManagedObject retProfileMo;
        public String moId;
        public final int retType;
        public final int antennaType;
        public final int minTilt;
        public final int maxTilt;
        public final int retParam1;
        public final int retParam2;
        public final int retParam3;
        public final int retParam4;
        public final int retParam5;
        public final int retParam6;
        public final int retParam7;
        public final int retParam8;
        public final int checkSum;

        public RetProfileData(ManagedObject _retProfileMo, String _moId, int _retType, int _antennaType, int _minTilt, int _maxTilt, int _retParam1, int _retParam2, int _retParam3, int _retParam4, int _retParam5, int _retParam6, int _retParam7, int _retParam8, int _checkSum) {
            this.retProfileMo = _retProfileMo;
            this.moId = _moId;
            this.retType = _retType;
            this.antennaType = _antennaType;
            this.minTilt = _minTilt;
            this.maxTilt = _maxTilt;
            this.retParam1 = _retParam1;
            this.retParam2 = _retParam2;
            this.retParam3 = _retParam3;
            this.retParam4 = _retParam4;
            this.retParam5 = _retParam5;
            this.retParam6 = _retParam6;
            this.retParam7 = _retParam7;
            this.retParam8 = _retParam8;
            this.checkSum = _checkSum;
        }

        public boolean isCustomProfile() {
            return this.retType > 50;
        }

        public boolean isStandardProfile() {
            return !this.isCustomProfile();
        }

        public boolean isEqual(RetProfileData x) {
            return this.retType == x.retType && this.antennaType == x.antennaType && this.minTilt == x.minTilt && this.maxTilt == x.maxTilt && this.retParam1 == x.retParam1 && this.retParam2 == x.retParam2 && this.retParam3 == x.retParam3 && this.retParam4 == x.retParam4 && this.retParam5 == x.retParam5 && this.retParam6 == x.retParam6 && this.retParam7 == x.retParam7 && this.retParam8 == x.retParam8 && this.checkSum == x.checkSum;
        }

        public String toString() {
            return "<retprofile antennaType=" + this.antennaType + " retType=" + this.retType + " checkSum=" + this.checkSum + " moId :" + this.moId + ">";
        }
    }

    static class CreationOfRetProfileFailedException
    extends MoAccessException {
        private static final long serialVersionUID = 1L;

        CreationOfRetProfileFailedException(String info) {
            super("CreationOfRetProfileFailed");
            this.addVariableValue("info", info);
        }
    }
}

