/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueCreateAuxPiuRspS;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueCreateDevGrpRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AntFeederCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.ReferenceAttribute;

public final class RadioDotSystemBasicOAMAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "11/109 26-CRH 109 042/1-5";
    public static final int LOW_VERSION = 19030000;
    private static final int HIGH_VERSION = 24050700;
    private static final RadioDotSystemBasicOAMAue instance = new RadioDotSystemBasicOAMAue();
    private static final int MAX_DOT = 8;
    private static final String RADIO_DOT = "RD";
    private static final String EQUIPMENT_LDN = "ManagedElement=1,Equipment=1";
    private static final String PIU_TYPE_ID_RD = "RD000000_";
    private static final String VALUE_SEPARATOR = "=";
    private static final String RDN_SEPARATOR = ",";
    private static final String UNDERLINE_SEPARATOR = "_";

    private RadioDotSystemBasicOAMAue() {
        super(RadioDotSystemBasicOAMAue.class);
    }

    public static RadioDotSystemBasicOAMAue instance() {
        return instance;
    }

    public int getLowVersion() {
        return 19030000;
    }

    public int getHighVersion() {
        return 24050700;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerConvert(List commands) throws Exception {
        this.traceEnter("triggerConvert(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        AuxPlugInUnitMo auxMo = null;
        Coordinator context = tw.getCoordinator();
        MoIterator moIter = BoamHelper.findMOs((String)"AuxPlugInUnit");
        while (moIter.hasMoreElements()) {
            String sectorAntennaRdn;
            auxMo = (AuxPlugInUnitMo)moIter.nextMo();
            if (auxMo.getAuType(context) != 27 || (sectorAntennaRdn = this.getSectorAntennaRdn(auxMo, context)) == null) continue;
            String sectorAntennaLdn = "ManagedElement=1,Equipment=1," + sectorAntennaRdn;
            for (int dotIndex = 1; dotIndex <= 8; ++dotIndex) {
                int auxRadioDotFroId = this.createAuxRDMo(auxMo, dotIndex, sectorAntennaLdn, context);
                this.createDeviceGroup(auxRadioDotFroId, dotIndex, sectorAntennaLdn, auxMo, context);
                this.createRdiCableMo(auxMo, dotIndex, auxRadioDotFroId, sectorAntennaLdn, context);
            }
        }
        return true;
    }

    private String getSectorId(String sectorAntennaLdn) {
        this.traceEnter("getSectorId()");
        MessageLog.traceParam((Class)RadioDotSystemBasicOAMAue.class, (String)("--> sectorAntennaLdn=" + sectorAntennaLdn));
        String sectorAntennaRdn = sectorAntennaLdn.substring(sectorAntennaLdn.lastIndexOf(RDN_SEPARATOR) + 1);
        int sectorIndex = sectorAntennaRdn.indexOf(VALUE_SEPARATOR) + 1;
        String sectorId = sectorAntennaRdn.substring(sectorIndex, sectorIndex + 1);
        return sectorId;
    }

    private String getSectorAntennaRdn(AuxPlugInUnitMo auxMo, Coordinator context) throws MoAccessException {
        this.traceEnter("getSectorAntennaRdn()");
        SectorAntennaMo sectorAntennaMo = null;
        String sectorAntennaRdn = null;
        ManagedObject[] resBy = auxMo.getReservedBy(context);
        for (int j = 0; j < resBy.length; ++j) {
            ManagedObject antennaBranchMo;
            AntFeederCableMo antFeederCable;
            if (!resBy[j].getType().equalsIgnoreCase("AntFeederCable") || (antFeederCable = (AntFeederCableMo)resBy[j]) == null || (antennaBranchMo = antFeederCable.getAntennaBranchRef(context)) == null) continue;
            sectorAntennaMo = (SectorAntennaMo)antennaBranchMo.getParent();
            sectorAntennaRdn = sectorAntennaMo.getRelativeDistinguishedName();
            break;
        }
        return sectorAntennaRdn;
    }

    private int createAuxRDMo(AuxPlugInUnitMo auxMo, int dotIndex, String sectorAntennaLdn, Coordinator context) throws Exception {
        this.traceEnter("createAuxRDMo");
        int piuFroId = auxMo.getFroId(context);
        MpswTaAueCreateAuxPiuRspS rspSig = AueProxy.instance().createAuxPiu(49180, piuFroId);
        int auxRdFroId = rspSig.auxPiuFroId;
        RadioDotSystemBasicOAMAue.updateCollectedMoData(sectorAntennaLdn, "AuxPlugInUnit", this.getRadioDotIdentity(dotIndex), auxRdFroId, auxMo, null, context);
        return auxRdFroId;
    }

    private void createDeviceGroup(int auxPiuFroId, int dotIndex, String sectorAntennaLdn, AuxPlugInUnitMo auxMo, Coordinator context) throws Exception {
        this.traceEnter("createDeviceGroup");
        String devGrpParentLdn = sectorAntennaLdn + RDN_SEPARATOR + "AuxPlugInUnit" + VALUE_SEPARATOR + this.getRadioDotIdentity(dotIndex);
        MpswTaAueCreateDevGrpRspS rspSig = AueProxy.instance().createDeviceGrp(49588, auxPiuFroId);
        int froId = rspSig.groupFroId;
        RadioDotSystemBasicOAMAue.updateCollectedMoData(devGrpParentLdn, "DeviceGroup", RADIO_DOT, froId, auxMo, null, context);
    }

    private void createRdiCableMo(AuxPlugInUnitMo auxMo, int dotIndex, int rdFroId, String sectorAntennaLdn, Coordinator context) throws Exception {
        this.traceEnter("createRdiCableMo()");
        String INTERNAL_IRU_NUMBER = "1";
        MpswTaAueCreateCableRspS rspSig = AueProxy.instance().createCable(50166, auxMo.getFroId(context), dotIndex, rdFroId);
        int rdiCableRroId = rspSig.cableFroId;
        String sectorId = this.getSectorId(sectorAntennaLdn);
        String radioDotLDN = this.getRadioDotLdn(sectorAntennaLdn, dotIndex);
        String newMoIdentity = sectorId + UNDERLINE_SEPARATOR + INTERNAL_IRU_NUMBER + UNDERLINE_SEPARATOR + dotIndex;
        RadioDotSystemBasicOAMAue.updateCollectedMoData(EQUIPMENT_LDN, "RdiCable", newMoIdentity, rdiCableRroId, auxMo, radioDotLDN, context);
    }

    private String getRadioDotLdn(String sectorAntennaLdn, int dotIndex) {
        this.traceEnter("getRadioDotLdn");
        return sectorAntennaLdn + RDN_SEPARATOR + "AuxPlugInUnit" + VALUE_SEPARATOR + this.getRadioDotIdentity(dotIndex);
    }

    private String getRadioDotIdentity(int dotIndex) {
        this.traceEnter("getRadioDotIdentity");
        return "RD-" + dotIndex;
    }

    private static CMoData updateCollectedMoData(String parentLdn, String moType, String newMoIdentity, int froId, AuxPlugInUnitMo auxMo, String rdLDN, Coordinator context) throws MoAccessException {
        MessageLog.traceParam((Class)RadioDotSystemBasicOAMAue.class, (String)("--> parentLdn=" + parentLdn + ",moType=" + moType + ",newMoIdentity=" + newMoIdentity + ",froId=" + froId + ", rdLDN= " + rdLDN + ",auxMo= " + auxMo.getLocalDistinguishedName()));
        String newMoLDN = parentLdn + RDN_SEPARATOR + moType + VALUE_SEPARATOR + newMoIdentity;
        CMoData cMoData = new CMoData(newMoLDN, moType, true, context);
        if (moType.equals("AuxPlugInUnit")) {
            cMoData.registerPersistentAttr(new IntegerAttribute("auxPiuFroId", false, froId));
            cMoData.registerPersistentAttr(new IntegerAttribute("auType", false, 28));
            cMoData.registerPersistentAttr(new ReferenceAttribute("piuType", false, (ManagedObject)RadioDotSystemBasicOAMAue.getPiuTypeOfRD()));
            cMoData.registerPersistentAttr(new ReferenceAttribute("plugInUnitRef1", false, (ManagedObject)((ManagedObjectBase)auxMo)));
        } else if (moType.equals("DeviceGroup")) {
            cMoData.registerPersistentAttr(new IntegerAttribute("groupFroId", false, froId));
        } else if (moType.equals("RdiCable")) {
            cMoData.registerPersistentAttr(new ReferenceAttribute("connectedToObjectARef", false, (ManagedObject)((ManagedObjectBase)auxMo)));
            cMoData.registerPersistentAttr(new ReferenceAttribute("connectedToObjectBRef", rdLDN, false));
            cMoData.registerPersistentAttr(new IntegerAttribute("froId", false, froId));
        } else {
            MessageLog.traceError((Class)RadioDotSystemBasicOAMAue.class, (String)"Wrong MO Type");
        }
        cMoData.handleTransaction(context, CMoData.WRITE_ACCESS);
        return cMoData;
    }

    private static ManagedObjectBase getPiuTypeOfRD() {
        MoIterator piuTypeIterator = FindMo.findMOs("PiuType");
        while (piuTypeIterator.hasMoreElements()) {
            ManagedObject mo = piuTypeIterator.nextMo();
            if (-1 == mo.getRelativeDistinguishedName().indexOf(PIU_TYPE_ID_RD)) continue;
            return (ManagedObjectBase)mo;
        }
        return null;
    }
}

