/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueSectorInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class SetSectorIdAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "11/109 26-CRH 109 042/1-2";
    public static final int LOW_VERSION = 6000000;
    private static final int HIGH_VERSION = 7089999;
    private static final SetSectorIdAue INSTANCE = new SetSectorIdAue();

    protected SetSectorIdAue() {
        super(SetSectorIdAue.class);
    }

    public static SetSectorIdAue instance() {
        return INSTANCE;
    }

    public int getLowVersion() {
        return 6000000;
    }

    public int getHighVersion() {
        return 7089999;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerConvert(List commands) throws Exception {
        this.traceEnter("triggerConvert(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        MoIterator moIter = BoamHelper.findMOs((String)"Sector");
        ArrayList<MpswTaAueSectorInfoT> sectorInfo = new ArrayList<MpswTaAueSectorInfoT>();
        while (moIter.hasMoreElements()) {
            SectorMo sector = (SectorMo)moIter.nextMo();
            int sectorFroId = sector.getSectorFroId(tw.getCoordinator());
            int sectorId = Integer.parseInt(sector.getNamingAttributeValue());
            sectorInfo.add(new MpswTaAueSectorInfoT(sectorId, sectorFroId));
        }
        AueProxy.instance().setSectorIds(sectorInfo.toArray(new MpswTaAueSectorInfoT[0]));
        return true;
    }
}

