/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueMaxOutputPowerInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TpaDeviceMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class WionaWP625Aue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "10/109 26-CRH 109 042/1-2";
    public static final int LOW_VERSION = 6000000;
    private static final int HIGH_VERSION = 7060599;
    public static final String CANDID1_P_NO = "KRC11842/1";
    public static final String CANDID2_P_NO = "KRC11842/2";
    public static final int RRUW = 20;
    private static WionaWP625Aue instance = new WionaWP625Aue();

    protected WionaWP625Aue() {
        super(WionaWP625Aue.class);
    }

    public static WionaWP625Aue instance() {
        return instance;
    }

    public int getHighVersion() {
        return 7060599;
    }

    public int getLowVersion() {
        return 6000000;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerConvert(List commands) throws Exception {
        this.traceEnter("triggerConvert(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        this.doExecute(tw.getCoordinator());
        return true;
    }

    private void doExecute(Coordinator context) throws Exception {
        this.traceEnter("doExecute()");
        MoIterator mos = BoamHelper.findMOs((String)"AuxPlugInUnit");
        Hashtable<AuxPlugInUnitMo, String> rruwList = new Hashtable<AuxPlugInUnitMo, String>();
        ArrayList<AuxPlugInUnitMo> auxPiuList = new ArrayList<AuxPlugInUnitMo>();
        while (mos.hasMoreElements()) {
            AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)mos.nextMo();
            String pNo = this.getProductNumber(auxPiu, context);
            if (pNo.equals("")) {
                this.trace("Cannot find product number of: " + auxPiu + "; no action for this AuxPlugInUnit");
                continue;
            }
            if (!CANDID1_P_NO.equalsIgnoreCase(pNo) && !CANDID2_P_NO.equalsIgnoreCase(pNo) || this.isWionaWP625AueNeeded(auxPiu, context)) continue;
            rruwList.put(auxPiu, pNo);
            auxPiuList.add(auxPiu);
        }
        if (auxPiuList.size() == 0) {
            this.trace("doExecute(), Nothing to do! No matching AuxPlugInUnit with pNo: KRC11842/1, KRC11842/2Or all  auType are already RRUW.");
            AueProxy.instance().setOutputpower(new MpswTaAueMaxOutputPowerInfoT[0]);
            AueProxy.instance().setAuTypeRrruw(new int[0]);
            return;
        }
        this.changeAuxPiuTyp(auxPiuList, context);
        this.setMaxTotalOutputPower(rruwList, context);
    }

    private boolean isWionaWP625AueNeeded(AuxPlugInUnitMo auxPiu, Coordinator context) throws Exception {
        this.traceEnter("isWionaWP625AueNeeded()");
        return auxPiu.getAuType(context) == 20;
    }

    private void changeAuxPiuTyp(List auxPius, Coordinator context) throws Exception {
        this.traceEnter("changeAuxPiuTyp()");
        int[] forIdList = new int[auxPius.size()];
        for (int i = 0; i < forIdList.length; ++i) {
            AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)auxPius.get(i);
            forIdList[i] = auxPiu.getFroId(context);
            MoData moData = WionaWP625Aue.getMoData(auxPiu);
            moData.handleTransaction(context, MoData.WRITE_ACCESS);
            IntegerAttribute attribute = (IntegerAttribute)moData.getAttribute("auType");
            attribute.setValue(20);
        }
        AueProxy.instance().setAuTypeRrruw(forIdList);
    }

    private void setMaxTotalOutputPower(Hashtable rruwList, Coordinator context) throws MoAccessException {
        this.traceEnter("setMaxTotalOutputPower()");
        ArrayList<MpswTaAueMaxOutputPowerInfoT> mpswTaInfo = new ArrayList<MpswTaAueMaxOutputPowerInfoT>();
        Enumeration enumer = rruwList.keys();
        while (enumer.hasMoreElements()) {
            AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)enumer.nextElement();
            int maxTotalOutputPower = CANDID1_P_NO.equalsIgnoreCase((String)rruwList.get(auxPiu)) ? 40 : 60;
            MoIterator mos = BoamHelper.findMOs((String)"TpaDevice", (ManagedObject)auxPiu, (int)-1);
            while (mos.hasMoreElements()) {
                TpaDeviceMo tpaDev = (TpaDeviceMo)mos.nextElement();
                mpswTaInfo.add(new MpswTaAueMaxOutputPowerInfoT(tpaDev.getFroId(context), maxTotalOutputPower));
            }
        }
        AueProxy.instance().setOutputpower(mpswTaInfo.toArray(new MpswTaAueMaxOutputPowerInfoT[0]));
    }

    private String getProductNumber(AuxPlugInUnitMo auxPiu, Coordinator context) {
        try {
            return auxPiu.getProductNumber(context);
        }
        catch (Exception e) {
            this.trace("Failed to get product number of: " + auxPiu + ", exception caught: " + e);
            return "";
        }
    }

    private static MoData getMoData(Object object) throws Exception {
        Class<?> saClass = object.getClass();
        Method m = saClass.getMethod("getMyMoData", new Class[0]);
        return (MoData)m.invoke(object, new Object[0]);
    }
}

