/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class AddBaseBandReferenceAttributeOp
implements Command {
    private static final String DUI_DEVICE_GROUP_REF = "duiDeviceGroupRef";
    private static final String DOWNLINK_BASE_BAND_POOL_REF = "downlinkBaseBandPoolRef";
    private final Coordinator context;
    private final WorkingMoData workingMoData;
    private final String moTypeName;
    private final int newRev;
    private final String attrName;
    private final boolean notification;
    private String attrValue;

    public AddBaseBandReferenceAttributeOp(WorkingMoData workingMoData, String moTypeName, int newRev, String attrName, boolean notification, Coordinator context) {
        this.workingMoData = workingMoData;
        this.moTypeName = moTypeName;
        this.newRev = newRev;
        this.attrName = attrName;
        this.notification = notification;
        this.context = context;
        this.attrValue = null;
        MessageLog.traceEnter(this.getClass(), (String)"Start AddBaseBandReferenceAttributeOp");
    }

    public void execute() throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.moTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, this.getClass(), (String)(this.moTypeName + " MO not found in Working Data."));
            return;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            MoDataHelper.activateWriteAccess(this.context, tmpMoData);
            MessageLog.trace((int)9, this.getClass(), (String)("Found tmpMoData, will look for attribute " + this.attrName));
            ReferenceAttribute newAttr = (ReferenceAttribute)tmpMoData.getAttribute(this.attrName);
            ReferenceAttribute duiRefAttr = (ReferenceAttribute)tmpMoData.getAttribute(DUI_DEVICE_GROUP_REF);
            if (duiRefAttr != null) {
                String duiDeviceGroupRefValue = duiRefAttr.getReferenceAsLDN();
                MessageLog.trace((int)9, this.getClass(), (String)("The value of duiDeviceGroupRef is " + duiDeviceGroupRefValue));
                if (duiDeviceGroupRefValue != null) {
                    String slotMoLdn = LDNHelper.getParentLdn(duiDeviceGroupRefValue, "PlugInUnit");
                    String slotValue = LDNHelper.getNamingAttributeValue(slotMoLdn);
                    MessageLog.trace((int)9, this.getClass(), (String)("The duiDeviceGroupRef is not null. The slotModLdn is " + slotMoLdn + ". The slotValue is " + slotValue));
                    if (this.attrName.equals(DOWNLINK_BASE_BAND_POOL_REF)) {
                        this.attrValue = "ManagedElement=1,Equipment=1,Subrack=1,DownlinkBaseBandPool=" + slotValue;
                    } else {
                        MessageLog.traceError(this.getClass(), (String)"The attrName is invalid. Attr Name: attrName");
                    }
                } else {
                    MessageLog.trace((int)9, this.getClass(), (String)"The value of attribute duiDeviceGroupRef is null, set value of attribute downlinkBaseBandPoolRef to null");
                }
            } else {
                MessageLog.trace((int)9, this.getClass(), (String)"The attribute duiDeviceGroupRef is null, set value of attribute downlinkBaseBandPoolRef to null");
            }
            if (newAttr == null) {
                ReferenceAttribute tmpRA = new ReferenceAttribute(this.attrName, this.attrValue, this.notification);
                tmpMoData.registerPersistentAttr((Attribute)tmpRA);
                String moLDN = tmpMoData.getLocalDistinguishedName();
                MessageLog.trace((int)9, this.getClass(), (String)("Register attribute to MO " + moLDN + ", Attribute Name:" + this.attrName + ". Attribute Value:" + this.attrValue + ". Notification:" + this.notification));
                tmpMoData.setRevision(this.newRev);
                continue;
            }
            MessageLog.trace((int)9, this.getClass(), (String)(" The attribute allready exists in the MoData. Attr name: " + this.attrName + ", Mo:" + tmpMoData.getLocalDistinguishedName()));
        }
    }
}

