/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv;

import java.io.File;
import java.util.Vector;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.RealMoDataSource;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.step2.common.RbsDataConverter;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.ConversionSequenceNotFoundException;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.Converter;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DCRevHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DCSequence;
import se.ericsson.wcdma.rbs.boam.upfwk.data.DumpDataStorage;
import se.ericsson.wcdma.rbs.boam.upfwk.data.RecoveryHandler;

public class BoamDC
implements RbsDataConverter {
    private static BoamDC instanceObj = new BoamDC();
    private Converter[] dcList = null;

    private BoamDC() {
    }

    public void upgrade(ConverterContext context, Integer currentSequenceNumber) throws CrbsAueException {
        MessageLog.info(this.getClass(), (String)("upgrade method called with sequenceNumber: " + currentSequenceNumber));
        try {
            TransactionWrapper transactionWrapper = context.getTransactionWrapperFactory().create();
            RealMoDataSource moDataSource = (RealMoDataSource)context.getMoDataAccessor();
            this.convertMoData(moDataSource.getOriginalData(), transactionWrapper.getCoordinator());
            transactionWrapper.commit();
        }
        catch (MoDataConversionException e) {
            throw new CrbsAueException("Got MoDataConversionException: " + e.getMessage(), (Throwable)e);
        }
        catch (AueException e) {
            throw new CrbsAueException("Got AueException: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean convertMoData(Vector moData, Coordinator context) throws MoDataConversionException {
        MessageLog.info(this.getClass(), (String)" BoamDC ");
        this.checkIfDumpDataNeedes(moData);
        MessageLog.info(this.getClass(), (String)" BoamDC starting conversion.");
        long startTime = System.currentTimeMillis();
        WorkingMoData workingMoData = new WorkingMoData(moData);
        DCRevHandler revHandler = new DCRevHandler(workingMoData);
        try {
            DCSequence seq = new DCSequence(this.dcList, revHandler);
            MessageLog.info(this.getClass(), (String)("\n\n Conversion sequence:\n" + seq.toString()));
            seq.convert(workingMoData);
        }
        catch (ConversionSequenceNotFoundException se) {
            MessageLog.info(this.getClass(), (String)("\n\n**** " + se.getMessage() + " Check if the DCList is updated for this upgrade package?  ****"));
        }
        long endTime = System.currentTimeMillis();
        MessageLog.info(this.getClass(), (String)("BoamDC completed conversion in " + (endTime - startTime) + "ms"));
        return false;
    }

    public void initDCList(Converter[] dcList) {
        this.dcList = dcList;
    }

    public static synchronized BoamDC instance() {
        return instanceObj;
    }

    private void checkIfDumpDataNeedes(Vector moData) {
        try {
            File dumpNeeded = new File("/c/mo_data_dump_needed");
            if (dumpNeeded.exists()) {
                DumpDataStorage dumpMoStorage = DumpDataStorage.instance();
                dumpMoStorage.setMoData(moData, RecoveryHandler.getCollectedMoData());
                dumpMoStorage.save();
                dumpNeeded.delete();
            }
        }
        catch (Throwable t) {
            MessageLog.info(this.getClass(), (String)(" checkIfDumpDataNeedes(), Couldn't do check/dump!!: " + t));
        }
    }

    public String[] getConverterClassnames_onlyForTest() {
        if (this.dcList == null) {
            return new String[0];
        }
        String[] result = new String[this.dcList.length];
        for (int i = 0; i < this.dcList.length; ++i) {
            String longName = this.dcList[i].getClass().getName();
            result[i] = longName.substring(longName.lastIndexOf(46) + 1);
        }
        return result;
    }
}

