/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.ConverterOpBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.ConverterOpContext;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;

public class UpdateMoLDNOp
extends ConverterOpBase {
    public Class SELF = UpdateMoLDNOp.class;
    private String ldn = null;
    private String toName = null;
    private boolean cleanCMoData = false;

    public UpdateMoLDNOp(WorkingMoData workingMoData, Coordinator context, String aLDN, String aName, boolean cleanCMoData) {
        super(workingMoData, context);
        this.ldn = aLDN;
        this.toName = aName;
        this.cleanCMoData = cleanCMoData;
        MessageLog.trace((int)9, (Class)this.SELF, (String)("UpdateMoLDNOp: old LDN=" + this.ldn + ", new name=" + this.toName));
    }

    public void execute(ConverterOpContext context) throws Exception {
        CMoData cmodata;
        MoData oldMoData = context.getMoDataByLDN(this.ldn);
        int index = this.ldn.lastIndexOf("=");
        String newLDN = this.ldn.substring(0, index) + "=" + this.toName;
        TopologyMgr mgr = new TopologyMgr(context.getWorkingData());
        mgr.changeLdnTopology(oldMoData, newLDN);
        MessageLog.trace((int)9, (Class)this.SELF, (String)(oldMoData.getLocalDistinguishedName() + " now has the following LDN : " + newLDN));
        if (this.cleanCMoData && (cmodata = context.getCMoDataByLDN(this.ldn)) != null) {
            cmodata.handleTransaction(context.getTransaction(), CMoData.WRITE_ACCESS);
            cmodata.delete(context.getTransaction());
        }
    }

    public void registerAttributeInMoData(MoData moData) throws Exception {
    }
}

