/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoConverterUtility;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.ReserveMoHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class UpdateReferenceAttributeOp
implements Command {
    private static final Class SELF = UpdateReferenceAttributeOp.class;
    private final WorkingMoData workingMoData;
    private final String moTypeName;
    private final int newRev;
    private final String attrName;
    private final String attrValue;
    private final Coordinator context;
    private final String genericMoName;
    private final String moParentName;

    public UpdateReferenceAttributeOp(WorkingMoData workingMoData, String moTypeName, int newrev, String attrName, String attrValue, String genericMoName, String moParentName, Coordinator context) {
        this.workingMoData = workingMoData;
        this.moTypeName = moTypeName;
        this.newRev = newrev;
        this.attrName = attrName;
        this.attrValue = attrValue;
        this.context = context;
        this.genericMoName = genericMoName;
        this.moParentName = moParentName;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.moTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, (Class)SELF, (String)("workingMoData does not contain any: " + this.moTypeName));
        } else {
            Iterator iter = mos.iterator();
            while (iter.hasNext()) {
                MoData reservedMO;
                MoData moData = (MoData)iter.next();
                String moLdn = moData.getLocalDistinguishedName();
                String moParentLdn = LDNHelper.getParentLdn(moLdn, this.moTypeName);
                if (this.genericMoName == null || !LDNHelper.getNamingAttributeValue(moLdn).startsWith(this.genericMoName) || this.moParentName != null && (this.moParentName == null || !this.moParentName.equalsIgnoreCase(LDNHelper.getMoTypeName(moParentLdn)))) continue;
                ReferenceAttribute attr = (ReferenceAttribute)moData.getAttribute(this.attrName);
                if (attr == null) {
                    throw new NoSuchAttributeException(this.attrName, this.moTypeName);
                }
                if (!(attr instanceof ReferenceAttribute)) {
                    throw new WrongAttributeTypeException(this.attrName, this.moTypeName);
                }
                MoDataHelper.activateWriteAccess(this.context, moData);
                MoDataHelper.registerRefAttr(moData, null, this.attrName, attr.isAVCNotifier(), this.attrValue);
                if (this.attrValue != null && (reservedMO = MoConverterUtility.getMoDataByLDN(this.workingMoData, this.context, this.attrValue)) != null) {
                    ReserveMoHelper.reserve(reservedMO, moLdn, this.context);
                }
                moData.setRevision(this.newRev);
            }
        }
    }
}

