/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class UpdateSequenceOfIntegerAttributeOp
implements Command {
    private static final Class SELF = UpdateSequenceOfIntegerAttributeOp.class;
    private final WorkingMoData workingMoData;
    private final String moTypeName;
    private final int newRev;
    private final String attrName;
    private final int[] indexes;
    private final int[] values;
    private final Coordinator context;

    public UpdateSequenceOfIntegerAttributeOp(WorkingMoData workingMoData, String moTypeName, int newRev, String attrName, int[] indexes, int[] values, Coordinator context) throws MoAccessException {
        this.workingMoData = workingMoData;
        this.moTypeName = moTypeName;
        this.newRev = newRev;
        this.attrName = attrName;
        if (indexes.length != values.length) {
            MessageLog.traceError((Class)SELF, (String)("array lengths must be equal; found lengths: indexes: " + indexes.length + ", values: " + values.length));
            throw new SoftwareErrorException();
        }
        this.indexes = indexes;
        this.values = values;
        this.context = context;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.moTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, (Class)SELF, (String)("workingMoData does not contain any: " + this.moTypeName));
        } else {
            Iterator iter = mos.iterator();
            while (iter.hasNext()) {
                MoData moData = (MoData)iter.next();
                Attribute attr = moData.getAttribute(this.attrName);
                if (attr == null) {
                    throw new NoSuchAttributeException(this.attrName, this.moTypeName);
                }
                if (!(attr instanceof SequenceAttribute)) {
                    throw new WrongAttributeTypeException(this.attrName, this.moTypeName);
                }
                SequenceAttribute seqAttr = (SequenceAttribute)attr;
                Attribute[] attrs = seqAttr.getValue(this.context);
                int largestIndex = UpdateSequenceOfIntegerAttributeOp.largestIndex(this.indexes);
                if (largestIndex >= attrs.length) {
                    MessageLog.traceError((Class)SELF, (String)("index out of range: actual: " + largestIndex + ", exceeds maximum allowed: " + (attrs.length - 1)));
                    throw new SoftwareErrorException();
                }
                boolean notify = seqAttr.isAVCNotifier();
                Attribute[] newAttrs = new Attribute[attrs.length];
                for (int i = 0; i < attrs.length; ++i) {
                    int k = UpdateSequenceOfIntegerAttributeOp.indexOf(i, this.indexes);
                    newAttrs[i] = k == -1 ? attrs[i] : new IntegerAttribute(attrs[i].getName(), attrs[i].isAVCNotifier(), this.values[k]);
                }
                SequenceAttribute newSeqAttr = new SequenceAttribute(this.attrName, notify);
                newSeqAttr.setValue(newAttrs);
                MoDataHelper.activateWriteAccess(this.context, moData);
                moData.deregisterAttribute(attr);
                moData.registerPersistentAttr((Attribute)newSeqAttr);
                moData.setRevision(this.newRev);
            }
        }
    }

    private static int largestIndex(int[] indexes) {
        int result = Integer.MIN_VALUE;
        for (int j = 0; j < indexes.length; ++j) {
            if (indexes[j] <= result) continue;
            result = indexes[j];
        }
        return result;
    }

    private static int indexOf(int i, int[] indexes) {
        for (int j = 0; j < indexes.length; ++j) {
            if (i != indexes[j]) continue;
            return j;
        }
        return -1;
    }
}

