/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import se.ericsson.cello.moframework.ManagedObject;

public class BoamCollectorBaseMo {
    private static final int UNDEFINED = -1;
    private final ManagedObject parent;
    private final String ldName;
    private final String moTypeName;
    private final int froId;

    public BoamCollectorBaseMo(ManagedObject parent, String moTypeName, String identity) {
        this.parent = parent;
        String relativeName = moTypeName + "=" + identity;
        this.ldName = parent != null ? parent.getLocalDistinguishedName() + "," + relativeName : relativeName;
        this.moTypeName = moTypeName;
        this.froId = -1;
    }

    public BoamCollectorBaseMo(String parentLdn, String moTypeName, String identity, int froId) {
        this.parent = null;
        String relativeName = moTypeName + "=" + identity;
        this.ldName = !parentLdn.equals("") ? parentLdn + "," + relativeName : relativeName;
        this.moTypeName = moTypeName;
        this.froId = froId;
    }

    public String getTypeName() {
        return this.moTypeName;
    }

    public ManagedObject getParent() {
        return this.parent;
    }

    public String getLocalDistinguishedName() {
        return this.ldName;
    }

    public String getNamingAttributeValue() {
        int startPos = this.ldName.lastIndexOf("=");
        if (startPos != -1) {
            String namingValue = this.ldName.substring(startPos + 1);
            return namingValue;
        }
        return null;
    }

    public int getFroId() {
        return this.froId;
    }

    public String toString() {
        return this.getLocalDistinguishedName();
    }
}

