/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.Serializable;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;

public class IntegerAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 0L;
    private transient int myBackup;
    private int myValue;
    private transient boolean myIsTransactionActive = false;

    public IntegerAttribute(String name, boolean isAttrValueChangeNotifier) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = 0;
    }

    public IntegerAttribute(String name, boolean isAttrValueChangeNotifier, int initialValue) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = initialValue;
    }

    public IntegerAttribute(String name, String attrData) {
        super(name, attrData.charAt(1));
        this.myValue = Integer.parseInt(attrData.substring(2));
    }

    public synchronized int getValue(Coordinator c) {
        if (c == null) {
            if (this.myIsTransactionActive) {
                return this.myBackup;
            }
            return this.myValue;
        }
        return this.myValue;
    }

    public synchronized void setValue(int aValue) {
        this.myValue = aValue;
    }

    public synchronized void setValue(Integer aValue) {
        this.myValue = aValue;
    }

    synchronized void rollback() {
        this.myValue = this.myBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
        this.myIsTransactionActive = true;
    }

    Object getValueAsObject(Coordinator c) {
        return new Integer(this.getValue(c));
    }

    boolean isModified() {
        return this.myValue != this.myBackup;
    }

    public String buildString() {
        String avc = "";
        avc = this.isAVCNotifier() ? "T" : "F";
        return this.getName() + "^i" + avc + Integer.toString(this.myValue);
    }
}

