/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.Const;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.BooleanAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.FloatAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.LongAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StringAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StructAttribute;

public class SequenceAttribute
extends Attribute
implements Serializable {
    private static final long serialVersionUID = -4156837133393235372L;
    private Vector myValue = new Vector();
    private transient Vector myValueBackup = null;

    public SequenceAttribute(String name, boolean isAttrValueChangeNotifier) {
        super(name, isAttrValueChangeNotifier);
    }

    public SequenceAttribute(String name, String attrData) {
        super(name, attrData.charAt(1));
        SequenceStringHandler sequenceString = new SequenceStringHandler(attrData.substring(2));
        int noOfAttributes = Integer.parseInt(sequenceString.nextSubstring());
        String attributeName = sequenceString.nextSubstring();
        for (int i = 0; i < noOfAttributes; ++i) {
            String attributeData = sequenceString.nextSubstring();
            char id = attributeData.charAt(0);
            if (id == 's') {
                this.addElement(new StringAttribute(attributeName, attributeData));
            } else if (id == 'i') {
                this.addElement(new IntegerAttribute(attributeName, attributeData));
            } else if (id == 'l') {
                this.addElement(new LongAttribute(attributeName, attributeData));
            } else if (id == 'b') {
                this.addElement(new BooleanAttribute(attributeName, attributeData));
            } else if (id == 'f') {
                this.addElement(new FloatAttribute(attributeName, attributeData));
            } else if (id != 'r' && id == 't') {
                this.addElement(new StructAttribute(attributeName, attributeData));
            }
            attributeName = sequenceString.nextSubstring();
        }
    }

    public synchronized Attribute[] getValue(Coordinator c) {
        if (c == null && this.myValueBackup != null) {
            Object[] arr = new Attribute[this.myValueBackup.size()];
            this.myValueBackup.copyInto(arr);
            return arr;
        }
        Object[] arr = new Attribute[this.myValue.size()];
        this.myValue.copyInto(arr);
        return arr;
    }

    public synchronized void setValue(Attribute[] aValue) {
        Const.callAssert(aValue);
        this.myValue.removeAllElements();
        for (int i = 0; i < aValue.length; ++i) {
            this.myValue.addElement(aValue[i]);
        }
    }

    public synchronized void addElement(Attribute a) {
        this.myValue.addElement(a);
    }

    public synchronized boolean removeElement(Attribute a) {
        return this.myValue.removeElement(a);
    }

    public synchronized boolean isEmpty() {
        return this.myValue.isEmpty();
    }

    public synchronized Enumeration elements() {
        return this.myValue.elements();
    }

    public synchronized int size() {
        return this.myValue.size();
    }

    synchronized void startTransaction() {
        this.myValueBackup = (Vector)this.myValue.clone();
        Enumeration e = this.myValue.elements();
        while (e.hasMoreElements()) {
            Attribute attr = (Attribute)e.nextElement();
            attr.startTransaction();
        }
    }

    synchronized void commit() {
        this.myValueBackup = null;
    }

    synchronized void rollback() {
        this.myValue = this.myValueBackup;
        this.myValueBackup = null;
        if (this.myValue == null) {
            this.myValue = new Vector();
        }
        Enumeration e = this.myValue.elements();
        while (e.hasMoreElements()) {
            Attribute attr = (Attribute)e.nextElement();
            attr.rollback();
        }
    }

    Object getValueAsObject(Coordinator c) {
        Class elementClass;
        if (this.myValue.size() == 0) {
            return new int[0];
        }
        Attribute first = (Attribute)this.myValue.elementAt(0);
        Object o = first.getValueAsObject(c);
        if (o == null) {
            elementClass = ManagedObject.class;
        } else {
            elementClass = o.getClass();
            if (o instanceof ManagedObject) {
                elementClass = ManagedObject.class;
            }
        }
        Object[] array = (Object[])Array.newInstance(elementClass, this.myValue.size());
        for (int i = 0; i < this.myValue.size(); ++i) {
            Object value;
            Attribute a = (Attribute)this.myValue.elementAt(i);
            array[i] = value = a.getValueAsObject(c);
        }
        return array;
    }

    boolean isModified() {
        Enumeration e = this.myValue.elements();
        while (e.hasMoreElements()) {
            Attribute attr = (Attribute)e.nextElement();
            if (!attr.isModified()) continue;
            return true;
        }
        return false;
    }

    public String buildString() {
        StringBuffer sb = new StringBuffer(64);
        if (this.isAVCNotifier()) {
            sb.append("T");
        } else {
            sb.append("F");
        }
        sb.append(this.size());
        sb.append("|");
        for (int i = 0; i < this.myValue.size(); ++i) {
            Attribute a = (Attribute)this.myValue.elementAt(i);
            sb.append(a.buildString());
            sb.append("|");
        }
        return this.getName() + "^q" + sb.toString().replace('^', '|');
    }

    private class SequenceStringHandler {
        private String str;
        private int index = 0;
        private boolean eos = false;

        SequenceStringHandler(String data) {
            this.str = data;
        }

        public String nextSubstring() {
            if (this.eos) {
                return null;
            }
            int tmpIndex = this.str.indexOf(124, this.index) + 1;
            if (tmpIndex == 0) {
                this.eos = true;
                return this.str.substring(this.index);
            }
            int readFrom = this.index;
            this.index = tmpIndex;
            if (readFrom == this.index) {
                return "";
            }
            return this.str.substring(readFrom, this.index - 1);
        }
    }
}

