/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.BERConstructedOctetString;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROctetString;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ASN1OctetString
extends DERObject {
    byte[] ec;

    public static ASN1OctetString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ASN1OctetString.getInstance(aSN1TaggedObject.getObject());
    }

    public static ASN1OctetString getInstance(Object object) {
        if (object == null || object instanceof ASN1OctetString) {
            return (ASN1OctetString)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        if (object instanceof ASN1Sequence) {
            Vector vector = new Vector();
            Enumeration enumeration = ((ASN1Sequence)object).getObjects();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            return new BERConstructedOctetString(vector);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public ASN1OctetString(byte[] byArray) {
        this.ec = byArray;
    }

    public ASN1OctetString(DEREncodable dEREncodable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dEREncodable);
            dEROutputStream.close();
            this.ec = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    public byte[] getOctets() {
        return this.ec;
    }

    public int hashCode() {
        byte[] byArray = this.getOctets();
        int n = 0;
        for (int k = 0; k != byArray.length; ++k) {
            n ^= (byArray[k] & 0xFF) << k % 4;
        }
        return n;
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (object == null || !(object instanceof DEROctetString)) {
            return false;
        }
        DEROctetString dEROctetString = (DEROctetString)object;
        byte[] byArray2 = dEROctetString.getOctets();
        if (byArray2.length != (byArray = this.getOctets()).length) {
            return false;
        }
        for (int k = 0; k != byArray2.length; ++k) {
            if (byArray2[k] == byArray[k]) continue;
            return false;
        }
        return true;
    }

    abstract void encode(DEROutputStream var1) throws IOException;
}

