/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1Encodable;
import com.maverick.crypto.asn1.ASN1EncodableVector;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERBoolean;
import com.maverick.crypto.asn1.DERInteger;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERSequence;
import java.math.BigInteger;

public class BasicConstraints
extends ASN1Encodable {
    DERBoolean lc = new DERBoolean(false);
    DERInteger mc = null;

    public static BasicConstraints getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static BasicConstraints getInstance(Object object) {
        if (object == null || object instanceof BasicConstraints) {
            return (BasicConstraints)object;
        }
        if (object instanceof ASN1Sequence) {
            return new BasicConstraints((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public BasicConstraints(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 0) {
            this.lc = null;
            this.mc = null;
        } else {
            this.lc = (DERBoolean)aSN1Sequence.getObjectAt(0);
            if (aSN1Sequence.size() > 1) {
                this.mc = (DERInteger)aSN1Sequence.getObjectAt(1);
            }
        }
    }

    public BasicConstraints(boolean bl, int n) {
        if (bl) {
            this.lc = new DERBoolean(bl);
            this.mc = new DERInteger(n);
        } else {
            this.lc = null;
            this.mc = null;
        }
    }

    public BasicConstraints(boolean bl) {
        this.lc = bl ? new DERBoolean(true) : null;
        this.mc = null;
    }

    public BasicConstraints(int n) {
        this.lc = new DERBoolean(true);
        this.mc = new DERInteger(n);
    }

    public boolean isCA() {
        return this.lc != null && this.lc.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.mc != null) {
            return this.mc.getValue();
        }
        return null;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.lc != null) {
            aSN1EncodableVector.add(this.lc);
            if (this.mc != null) {
                aSN1EncodableVector.add(this.mc);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        if (this.mc == null) {
            if (this.lc == null) {
                return "BasicConstraints: isCa(false)";
            }
            return "BasicConstraints: isCa(" + this.isCA() + ")";
        }
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.mc.getValue();
    }
}

