/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1Dump;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.DERBitString;
import com.maverick.crypto.asn1.DERBoolean;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERIA5String;
import com.maverick.crypto.asn1.DERInputStream;
import com.maverick.crypto.asn1.DERInteger;
import com.maverick.crypto.asn1.DERObjectIdentifier;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.misc.MiscObjectIdentifiers;
import com.maverick.crypto.asn1.misc.NetscapeCertType;
import com.maverick.crypto.asn1.misc.NetscapeRevocationURL;
import com.maverick.crypto.asn1.misc.VerisignCzagExtension;
import com.maverick.crypto.asn1.pkcs.PKCSObjectIdentifiers;
import com.maverick.crypto.asn1.x509.AlgorithmIdentifier;
import com.maverick.crypto.asn1.x509.BasicConstraints;
import com.maverick.crypto.asn1.x509.CertificateException;
import com.maverick.crypto.asn1.x509.KeyUsage;
import com.maverick.crypto.asn1.x509.RSAPublicKeyStructure;
import com.maverick.crypto.asn1.x509.X509CertificateStructure;
import com.maverick.crypto.asn1.x509.X509Extension;
import com.maverick.crypto.asn1.x509.X509Extensions;
import com.maverick.crypto.asn1.x509.X509Name;
import com.maverick.crypto.asn1.x509.X509ObjectIdentifiers;
import com.maverick.crypto.encoders.Hex;
import com.maverick.crypto.publickey.PublicKey;
import com.maverick.crypto.publickey.RsaPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class X509Certificate {
    private X509CertificateStructure d;
    private Hashtable c = new Hashtable();
    private Vector b = new Vector();

    public X509Certificate(X509CertificateStructure x509CertificateStructure) {
        this.d = x509CertificateStructure;
    }

    public void checkValidity() throws CertificateException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateException {
        if (date.after(this.getNotAfter())) {
            throw new CertificateException(1, "Certificate expired on " + this.d.getEndDate().getTime());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateException(2, "certificate not valid till " + this.d.getStartDate().getTime());
        }
    }

    public int getVersion() {
        return this.d.getVersion();
    }

    public BigInteger getSerialNumber() {
        return this.d.getSerialNumber().getValue();
    }

    public X509Name getIssuerDN() {
        return this.d.getIssuer();
    }

    public X509Name getSubjectDN() {
        return this.d.getSubject();
    }

    public Date getNotBefore() {
        return this.d.getStartDate().getDate();
    }

    public Date getNotAfter() {
        return this.d.getEndDate().getDate();
    }

    public byte[] getTBSCertificate() throws CertificateException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.d.getTBSCertificate());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateException(3, iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.d.getSignature().getBytes();
    }

    public String getSigAlgOID() {
        return this.d.getSignatureAlgorithm().getObjectId().getId();
    }

    public String getSigAlgName() throws CertificateException {
        if (this.getSigAlgOID().equals("1.2.840.113549.1.1.4")) {
            return "MD5WithRSAEncryption";
        }
        if (this.getSigAlgOID().equals("1.2.840.113549.1.1.5")) {
            return "SHA1WithRSAEncryption";
        }
        throw new CertificateException(5, "Unsupported signature algorithm id " + this.getSigAlgOID());
    }

    public byte[] getSigAlgParams() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.d.getSignatureAlgorithm().getParameters() != null) {
            try {
                DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
                dEROutputStream.writeObject(this.d.getSignatureAlgorithm().getParameters());
            }
            catch (Exception exception) {
                throw new RuntimeException("exception getting sig parameters " + exception);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        DERBitString dERBitString = this.d.getTBSCertificate().getIssuerUniqueId();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            for (int k = 0; k != blArray.length; ++k) {
                blArray[k] = (byArray[k / 8] & 128 >>> k % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        DERBitString dERBitString = this.d.getTBSCertificate().getSubjectUniqueId();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            for (int k = 0; k != blArray.length; ++k) {
                blArray[k] = (byArray[k / 8] & 128 >>> k % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        byte[] byArray = this.b("2.5.29.15");
        int n = 0;
        if (byArray != null) {
            Object object;
            try {
                object = new DERInputStream(new ByteArrayInputStream(byArray));
                DERBitString dERBitString = (DERBitString)((DERInputStream)object).readObject();
                byArray = dERBitString.getBytes();
                n = byArray.length * 8 - dERBitString.getPadBits();
            }
            catch (Exception exception) {
                throw new RuntimeException("error processing key usage extension");
            }
            object = new boolean[n < 9 ? 9 : n];
            for (int k = 0; k != n; ++k) {
                object[k] = (byArray[k / 8] & 128 >>> k % 8) != 0;
            }
            return object;
        }
        return null;
    }

    public int getBasicConstraints() {
        byte[] byArray = this.b("2.5.29.19");
        if (byArray != null) {
            try {
                DERInputStream dERInputStream = new DERInputStream(new ByteArrayInputStream(byArray));
                ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
                if (aSN1Sequence.size() == 2) {
                    if (((DERBoolean)aSN1Sequence.getObjectAt(0)).isTrue()) {
                        return ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue().intValue();
                    }
                    return -1;
                }
                if (aSN1Sequence.size() == 1) {
                    if (aSN1Sequence.getObjectAt(0) instanceof DERBoolean) {
                        if (((DERBoolean)aSN1Sequence.getObjectAt(0)).isTrue()) {
                            return Integer.MAX_VALUE;
                        }
                        return -1;
                    }
                    return -1;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("error processing key usage extension");
            }
        }
        return -1;
    }

    public X509Extension[] getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            Vector<String> vector = new Vector<String>();
            X509Extensions x509Extensions = this.d.getTBSCertificate().getExtensions();
            if (x509Extensions != null) {
                Object[] objectArray;
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    objectArray = (Object[])enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension((DERObjectIdentifier)objectArray);
                    if (!x509Extension.isCritical()) continue;
                    vector.addElement(objectArray.getId());
                }
                objectArray = new X509Extension[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
        }
        return null;
    }

    private byte[] b(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.d.getTBSCertificate().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            return x509Extension.getValue().getOctets();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.d.getTBSCertificate().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            try {
                dEROutputStream.writeObject(x509Extension.getValue());
                return byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    public X509Extension[] getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            Vector<String> vector = new Vector<String>();
            X509Extensions x509Extensions = this.d.getTBSCertificate().getExtensions();
            if (x509Extensions != null) {
                Object[] objectArray;
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    objectArray = (Object[])enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension((DERObjectIdentifier)objectArray);
                    if (x509Extension.isCritical()) continue;
                    vector.addElement(objectArray.getId());
                }
                objectArray = new X509Extension[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        X509Extensions x509Extensions;
        if (this.getVersion() == 3 && (x509Extensions = this.d.getTBSCertificate().getExtensions()) != null) {
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                X509Extension x509Extension;
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                if (dERObjectIdentifier.getId().equals("2.5.29.15") || dERObjectIdentifier.getId().equals("2.5.29.19") || !(x509Extension = x509Extensions.getExtension(dERObjectIdentifier)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    public PublicKey getPublicKey() throws CertificateException {
        try {
            AlgorithmIdentifier algorithmIdentifier = this.d.getSubjectPublicKeyInfo().getAlgorithmId();
            if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) || algorithmIdentifier.getObjectId().equals(X509ObjectIdentifiers.id_ea_rsa)) {
                RSAPublicKeyStructure rSAPublicKeyStructure = RSAPublicKeyStructure.getInstance(this.d.getSubjectPublicKeyInfo().getPublicKey());
                return new RsaPublicKey(rSAPublicKeyStructure.getModulus(), rSAPublicKeyStructure.getPublicExponent());
            }
            throw new CertificateException(5, "Public key algorithm id " + algorithmIdentifier.getObjectId().getId() + " is not supported");
        }
        catch (IOException iOException) {
            throw new CertificateException(4, iOException.getMessage());
        }
    }

    public byte[] getEncoded() throws CertificateException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.d);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateException(3, iOException.toString());
        }
    }

    public void setBagAttribute(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.c.put(dERObjectIdentifier, dEREncodable);
        this.b.addElement(dERObjectIdentifier);
    }

    public DEREncodable getBagAttribute(DERObjectIdentifier dERObjectIdentifier) {
        return (DEREncodable)this.c.get(dERObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.b.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("  [0]         Version: " + this.getVersion() + string);
        stringBuffer.append("         SerialNumber: " + this.getSerialNumber() + string);
        stringBuffer.append("             IssuerDN: " + this.getIssuerDN() + string);
        stringBuffer.append("           Start Date: " + this.getNotBefore() + string);
        stringBuffer.append("           Final Date: " + this.getNotAfter() + string);
        stringBuffer.append("            SubjectDN: " + this.getSubjectDN() + string);
        try {
            stringBuffer.append("           Public Key: " + this.getPublicKey() + string);
        }
        catch (CertificateException certificateException) {
            stringBuffer.append("           Public Key:  " + certificateException.getMessage());
        }
        try {
            stringBuffer.append("  Signature Algorithm: " + this.getSigAlgName() + string);
        }
        catch (CertificateException certificateException) {
            stringBuffer.append("  Signature Algorithm: " + certificateException.getMessage());
        }
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: " + new String(Hex.encode(byArray, 0, 20)) + string);
        for (int k = 20; k < byArray.length; k += 20) {
            if (k < byArray.length - 20) {
                stringBuffer.append("                       " + new String(Hex.encode(byArray, k, 20)) + string);
                continue;
            }
            stringBuffer.append("                       " + new String(Hex.encode(byArray, k, byArray.length - k)) + string);
        }
        X509Extensions x509Extensions = this.d.getTBSCertificate().getExtensions();
        if (x509Extensions != null) {
            Enumeration enumeration = x509Extensions.oids();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (x509Extension.getValue() != null) {
                    byte[] byArray2 = x509Extension.getValue().getOctets();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
                    stringBuffer.append("                       critical(" + x509Extension.isCritical() + ") ");
                    try {
                        if (dERObjectIdentifier.equals(X509Extensions.BasicConstraints)) {
                            stringBuffer.append(new BasicConstraints((ASN1Sequence)dERInputStream.readObject()) + string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(X509Extensions.KeyUsage)) {
                            stringBuffer.append(new KeyUsage((DERBitString)dERInputStream.readObject()) + string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.netscapeCertType)) {
                            stringBuffer.append(new NetscapeCertType((DERBitString)dERInputStream.readObject()) + string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.netscapeRevocationURL)) {
                            stringBuffer.append(new NetscapeRevocationURL((DERIA5String)dERInputStream.readObject()) + string);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(MiscObjectIdentifiers.verisignCzagExtension)) {
                            stringBuffer.append(new VerisignCzagExtension((DERIA5String)dERInputStream.readObject()) + string);
                            continue;
                        }
                        stringBuffer.append(dERObjectIdentifier.getId());
                        stringBuffer.append(" value = " + ASN1Dump.dumpAsString(dERInputStream.readObject()) + string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(dERObjectIdentifier.getId());
                        stringBuffer.append(" value = *****" + string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) {
    }
}

