/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.digests;

import com.maverick.crypto.digests.GeneralDigest;

public class MD5Digest
extends GeneralDigest {
    private int h;
    private int g;
    private int f;
    private int e;
    private int[] j = new int[16];
    private int i;

    public MD5Digest() {
        this.reset();
    }

    public MD5Digest(MD5Digest mD5Digest) {
        super(mD5Digest);
        this.h = mD5Digest.h;
        this.g = mD5Digest.g;
        this.f = mD5Digest.f;
        this.e = mD5Digest.e;
        System.arraycopy(mD5Digest.j, 0, this.j, 0, mD5Digest.j.length);
        this.i = mD5Digest.i;
    }

    public String getAlgorithmName() {
        return "MD5";
    }

    public int getDigestSize() {
        return 16;
    }

    protected void processWord(byte[] byArray, int n) {
        this.j[this.i++] = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        if (this.i == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long l) {
        if (this.i > 14) {
            this.processBlock();
        }
        this.j[14] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.j[15] = (int)(l >>> 32);
    }

    private void b(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2 + 2] = (byte)(n >>> 16);
        byArray[n2 + 3] = (byte)(n >>> 24);
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        this.b(this.h, byArray, n);
        this.b(this.g, byArray, n + 4);
        this.b(this.f, byArray, n + 8);
        this.b(this.e, byArray, n + 12);
        this.reset();
        return 16;
    }

    public void reset() {
        super.reset();
        this.h = 1732584193;
        this.g = -271733879;
        this.f = -1732584194;
        this.e = 271733878;
        this.i = 0;
        for (int k = 0; k != this.j.length; ++k) {
            this.j[k] = 0;
        }
    }

    private int b(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private int b(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private int d(int n, int n2, int n3) {
        return n & n3 | n2 & ~n3;
    }

    private int c(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int e(int n, int n2, int n3) {
        return n2 ^ (n | ~n3);
    }

    protected void processBlock() {
        int n = this.h;
        int n2 = this.g;
        int n3 = this.f;
        int n4 = this.e;
        n = this.b(n + this.b(n2, n3, n4) + this.j[0] + -680876936, 7) + n2;
        n4 = this.b(n4 + this.b(n, n2, n3) + this.j[1] + -389564586, 12) + n;
        n3 = this.b(n3 + this.b(n4, n, n2) + this.j[2] + 606105819, 17) + n4;
        n2 = this.b(n2 + this.b(n3, n4, n) + this.j[3] + -1044525330, 22) + n3;
        n = this.b(n + this.b(n2, n3, n4) + this.j[4] + -176418897, 7) + n2;
        n4 = this.b(n4 + this.b(n, n2, n3) + this.j[5] + 1200080426, 12) + n;
        n3 = this.b(n3 + this.b(n4, n, n2) + this.j[6] + -1473231341, 17) + n4;
        n2 = this.b(n2 + this.b(n3, n4, n) + this.j[7] + -45705983, 22) + n3;
        n = this.b(n + this.b(n2, n3, n4) + this.j[8] + 1770035416, 7) + n2;
        n4 = this.b(n4 + this.b(n, n2, n3) + this.j[9] + -1958414417, 12) + n;
        n3 = this.b(n3 + this.b(n4, n, n2) + this.j[10] + -42063, 17) + n4;
        n2 = this.b(n2 + this.b(n3, n4, n) + this.j[11] + -1990404162, 22) + n3;
        n = this.b(n + this.b(n2, n3, n4) + this.j[12] + 1804603682, 7) + n2;
        n4 = this.b(n4 + this.b(n, n2, n3) + this.j[13] + -40341101, 12) + n;
        n3 = this.b(n3 + this.b(n4, n, n2) + this.j[14] + -1502002290, 17) + n4;
        n2 = this.b(n2 + this.b(n3, n4, n) + this.j[15] + 1236535329, 22) + n3;
        n = this.b(n + this.d(n2, n3, n4) + this.j[1] + -165796510, 5) + n2;
        n4 = this.b(n4 + this.d(n, n2, n3) + this.j[6] + -1069501632, 9) + n;
        n3 = this.b(n3 + this.d(n4, n, n2) + this.j[11] + 643717713, 14) + n4;
        n2 = this.b(n2 + this.d(n3, n4, n) + this.j[0] + -373897302, 20) + n3;
        n = this.b(n + this.d(n2, n3, n4) + this.j[5] + -701558691, 5) + n2;
        n4 = this.b(n4 + this.d(n, n2, n3) + this.j[10] + 38016083, 9) + n;
        n3 = this.b(n3 + this.d(n4, n, n2) + this.j[15] + -660478335, 14) + n4;
        n2 = this.b(n2 + this.d(n3, n4, n) + this.j[4] + -405537848, 20) + n3;
        n = this.b(n + this.d(n2, n3, n4) + this.j[9] + 568446438, 5) + n2;
        n4 = this.b(n4 + this.d(n, n2, n3) + this.j[14] + -1019803690, 9) + n;
        n3 = this.b(n3 + this.d(n4, n, n2) + this.j[3] + -187363961, 14) + n4;
        n2 = this.b(n2 + this.d(n3, n4, n) + this.j[8] + 1163531501, 20) + n3;
        n = this.b(n + this.d(n2, n3, n4) + this.j[13] + -1444681467, 5) + n2;
        n4 = this.b(n4 + this.d(n, n2, n3) + this.j[2] + -51403784, 9) + n;
        n3 = this.b(n3 + this.d(n4, n, n2) + this.j[7] + 1735328473, 14) + n4;
        n2 = this.b(n2 + this.d(n3, n4, n) + this.j[12] + -1926607734, 20) + n3;
        n = this.b(n + this.c(n2, n3, n4) + this.j[5] + -378558, 4) + n2;
        n4 = this.b(n4 + this.c(n, n2, n3) + this.j[8] + -2022574463, 11) + n;
        n3 = this.b(n3 + this.c(n4, n, n2) + this.j[11] + 1839030562, 16) + n4;
        n2 = this.b(n2 + this.c(n3, n4, n) + this.j[14] + -35309556, 23) + n3;
        n = this.b(n + this.c(n2, n3, n4) + this.j[1] + -1530992060, 4) + n2;
        n4 = this.b(n4 + this.c(n, n2, n3) + this.j[4] + 1272893353, 11) + n;
        n3 = this.b(n3 + this.c(n4, n, n2) + this.j[7] + -155497632, 16) + n4;
        n2 = this.b(n2 + this.c(n3, n4, n) + this.j[10] + -1094730640, 23) + n3;
        n = this.b(n + this.c(n2, n3, n4) + this.j[13] + 681279174, 4) + n2;
        n4 = this.b(n4 + this.c(n, n2, n3) + this.j[0] + -358537222, 11) + n;
        n3 = this.b(n3 + this.c(n4, n, n2) + this.j[3] + -722521979, 16) + n4;
        n2 = this.b(n2 + this.c(n3, n4, n) + this.j[6] + 76029189, 23) + n3;
        n = this.b(n + this.c(n2, n3, n4) + this.j[9] + -640364487, 4) + n2;
        n4 = this.b(n4 + this.c(n, n2, n3) + this.j[12] + -421815835, 11) + n;
        n3 = this.b(n3 + this.c(n4, n, n2) + this.j[15] + 530742520, 16) + n4;
        n2 = this.b(n2 + this.c(n3, n4, n) + this.j[2] + -995338651, 23) + n3;
        n = this.b(n + this.e(n2, n3, n4) + this.j[0] + -198630844, 6) + n2;
        n4 = this.b(n4 + this.e(n, n2, n3) + this.j[7] + 1126891415, 10) + n;
        n3 = this.b(n3 + this.e(n4, n, n2) + this.j[14] + -1416354905, 15) + n4;
        n2 = this.b(n2 + this.e(n3, n4, n) + this.j[5] + -57434055, 21) + n3;
        n = this.b(n + this.e(n2, n3, n4) + this.j[12] + 1700485571, 6) + n2;
        n4 = this.b(n4 + this.e(n, n2, n3) + this.j[3] + -1894986606, 10) + n;
        n3 = this.b(n3 + this.e(n4, n, n2) + this.j[10] + -1051523, 15) + n4;
        n2 = this.b(n2 + this.e(n3, n4, n) + this.j[1] + -2054922799, 21) + n3;
        n = this.b(n + this.e(n2, n3, n4) + this.j[8] + 1873313359, 6) + n2;
        n4 = this.b(n4 + this.e(n, n2, n3) + this.j[15] + -30611744, 10) + n;
        n3 = this.b(n3 + this.e(n4, n, n2) + this.j[6] + -1560198380, 15) + n4;
        n2 = this.b(n2 + this.e(n3, n4, n) + this.j[13] + 1309151649, 21) + n3;
        n = this.b(n + this.e(n2, n3, n4) + this.j[4] + -145523070, 6) + n2;
        n4 = this.b(n4 + this.e(n, n2, n3) + this.j[11] + -1120210379, 10) + n;
        n3 = this.b(n3 + this.e(n4, n, n2) + this.j[2] + 718787259, 15) + n4;
        n2 = this.b(n2 + this.e(n3, n4, n) + this.j[9] + -343485551, 21) + n3;
        this.h += n;
        this.g += n2;
        this.f += n3;
        this.e += n4;
        this.i = 0;
        for (int k = 0; k != this.j.length; ++k) {
            this.j[k] = 0;
        }
    }
}

