/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.digests;

import com.maverick.crypto.digests.GeneralDigest;

public class SHA1Digest
extends GeneralDigest {
    private int o;
    private int n;
    private int m;
    private int l;
    private int k;
    private int[] q = new int[80];
    private int p;

    public SHA1Digest() {
        this.reset();
    }

    public SHA1Digest(SHA1Digest sHA1Digest) {
        super(sHA1Digest);
        this.o = sHA1Digest.o;
        this.n = sHA1Digest.n;
        this.m = sHA1Digest.m;
        this.l = sHA1Digest.l;
        this.k = sHA1Digest.k;
        System.arraycopy(sHA1Digest.q, 0, this.q, 0, sHA1Digest.q.length);
        this.p = sHA1Digest.p;
    }

    public String getAlgorithmName() {
        return "SHA-1";
    }

    public int getDigestSize() {
        return 20;
    }

    protected void processWord(byte[] byArray, int n) {
        this.q[this.p++] = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        if (this.p == 16) {
            this.processBlock();
        }
    }

    private void c(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    protected void processLength(long l) {
        if (this.p > 14) {
            this.processBlock();
        }
        this.q[14] = (int)(l >>> 32);
        this.q[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        this.c(this.o, byArray, n);
        this.c(this.n, byArray, n + 4);
        this.c(this.m, byArray, n + 8);
        this.c(this.l, byArray, n + 12);
        this.c(this.k, byArray, n + 16);
        this.reset();
        return 20;
    }

    public void reset() {
        super.reset();
        this.o = 1732584193;
        this.n = -271733879;
        this.m = -1732584194;
        this.l = 271733878;
        this.k = -1009589776;
        this.p = 0;
        for (int k = 0; k != this.q.length; ++k) {
            this.q[k] = 0;
        }
    }

    private int g(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private int h(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int f(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private int c(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    protected void processBlock() {
        int n;
        int n2;
        int n3;
        for (n3 = 16; n3 <= 79; ++n3) {
            this.q[n3] = this.c(this.q[n3 - 3] ^ this.q[n3 - 8] ^ this.q[n3 - 14] ^ this.q[n3 - 16], 1);
        }
        n3 = this.o;
        int n4 = this.n;
        int n5 = this.m;
        int n6 = this.l;
        int n7 = this.k;
        for (n2 = 0; n2 <= 19; ++n2) {
            n = this.c(n3, 5) + this.g(n4, n5, n6) + n7 + this.q[n2] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = this.c(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 20; n2 <= 39; ++n2) {
            n = this.c(n3, 5) + this.h(n4, n5, n6) + n7 + this.q[n2] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = this.c(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 40; n2 <= 59; ++n2) {
            n = this.c(n3, 5) + this.f(n4, n5, n6) + n7 + this.q[n2] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = this.c(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 60; n2 <= 79; ++n2) {
            n = this.c(n3, 5) + this.h(n4, n5, n6) + n7 + this.q[n2] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = this.c(n4, 30);
            n4 = n3;
            n3 = n;
        }
        this.o += n3;
        this.n += n4;
        this.m += n5;
        this.l += n6;
        this.k += n7;
        this.p = 0;
        for (n2 = 0; n2 != this.q.length; ++n2) {
            this.q[n2] = 0;
        }
    }
}

