/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.publickey;

import com.maverick.crypto.digests.SHA1Digest;
import com.maverick.crypto.publickey.Dsa;
import com.maverick.crypto.publickey.DsaKey;
import com.maverick.crypto.publickey.PublicKey;
import java.math.BigInteger;

public class DsaPublicKey
extends DsaKey
implements PublicKey {
    protected BigInteger y;

    public DsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(bigInteger, bigInteger2, bigInteger3);
        this.y = bigInteger4;
    }

    public DsaPublicKey() {
    }

    public BigInteger getY() {
        return this.y;
    }

    public int getBitLength() {
        return this.p.bitLength();
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray3, 0);
        return Dsa.verify(this.y, this.p, this.q, this.g, byArray, byArray3);
    }

    protected boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        bigInteger3 = bigInteger3.mod(this.q);
        if (BigInteger.valueOf(0L).compareTo(bigInteger) >= 0 || this.q.compareTo(bigInteger) <= 0) {
            return false;
        }
        if (BigInteger.valueOf(0L).compareTo(bigInteger2) >= 0 || this.q.compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger4 = bigInteger2.modInverse(this.q);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4).mod(this.q);
        BigInteger bigInteger6 = bigInteger.multiply(bigInteger4).mod(this.q);
        BigInteger bigInteger7 = this.g.modPow(bigInteger5, this.p).multiply(this.y.modPow(bigInteger6, this.p)).mod(this.p).mod(this.q);
        return bigInteger7.compareTo(bigInteger) == 0;
    }
}

