/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.publickey;

import com.maverick.crypto.digests.SHA1Digest;
import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaKey;
import java.math.BigInteger;

public class RsaPrivateKey
extends RsaKey {
    protected BigInteger privateExponent;
    protected static final byte[] ASN_SHA1 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};

    public RsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger);
        this.privateExponent = bigInteger2;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public byte[] sign(byte[] byArray) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        byte[] byArray3 = new byte[byArray2.length + ASN_SHA1.length];
        System.arraycopy(ASN_SHA1, 0, byArray3, 0, ASN_SHA1.length);
        System.arraycopy(byArray2, 0, byArray3, ASN_SHA1.length, byArray2.length);
        byArray2 = byArray3;
        BigInteger bigInteger = new BigInteger(1, byArray2);
        int n = (this.getModulus().bitLength() + 7) / 8;
        bigInteger = Rsa.padPKCS1(bigInteger, 1, n);
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = this.getPrivateExponent();
        BigInteger bigInteger4 = this.getModulus();
        bigInteger2 = Rsa.doPrivate(bigInteger, bigInteger4, bigInteger3);
        byte[] byArray4 = RsaPrivateKey.unsignedBigIntToBytes(bigInteger2, n);
        return byArray4;
    }

    protected static byte[] unsignedBigIntToBytes(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - n, byArray2, 0, n);
        } else if (byArray.length < n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public boolean equals(Object object) {
        if (object instanceof RsaPrivateKey) {
            RsaPrivateKey rsaPrivateKey = (RsaPrivateKey)object;
            return rsaPrivateKey.getBitLength() == this.getBitLength() && rsaPrivateKey.getModulus().compareTo(this.getModulus()) == 0 && rsaPrivateKey.getPrivateExponent().compareTo(this.getPrivateExponent()) == 0;
        }
        return false;
    }
}

