/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.DiffieHellmanGroups;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.ssh.components.jce.AbstractKeyExchange;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DiffieHellmanGroup14Sha1
extends SshKeyExchangeClient
implements AbstractKeyExchange {
    public static final String DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
    static final BigInteger db = BigInteger.valueOf(1L);
    static final BigInteger jb;
    static final BigInteger hb;
    static final BigInteger fb;
    BigInteger kb = null;
    BigInteger ib = null;
    BigInteger nb = null;
    String cb;
    String gb;
    byte[] lb;
    byte[] pb;
    KeyPairGenerator ob;
    KeyAgreement mb;
    KeyFactory eb;

    public DiffieHellmanGroup14Sha1() {
        super("SHA-1");
    }

    public void performClientExchange(String string, String string2, byte[] byArray, byte[] byArray2) throws SshException {
        Object object;
        Object object2;
        this.cb = string;
        this.gb = string2;
        this.lb = byArray;
        this.pb = byArray2;
        try {
            this.eb = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
            this.ob = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
            this.mb = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SshException("JCE does not support Diffie Hellman key exchange", 16);
        }
        try {
            object2 = new DHParameterSpec(fb, hb);
            this.ob.initialize((AlgorithmParameterSpec)object2);
            object = this.ob.generateKeyPair();
            this.mb.init(((KeyPair)object).getPrivate());
            this.kb = ((DHPublicKey)((KeyPair)object).getPublic()).getY();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SshException("Failed to generate DH value", 16, invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SshException("Failed to generate DH value", 16, invalidAlgorithmParameterException);
        }
        try {
            object2 = new ByteArrayWriter();
            ((ByteArrayOutputStream)object2).write(30);
            ((ByteArrayWriter)object2).writeBigInteger(this.kb);
            this.transport.sendMessage(((ByteArrayOutputStream)object2).toByteArray(), true);
        }
        catch (IOException iOException) {
            throw new SshException("Failed to write SSH_MSG_KEXDH_INIT to message buffer", 5);
        }
        object2 = this.transport.nextMessage();
        if (object2[0] != 31) {
            this.transport.disconnect(3, "Key exchange failed");
            throw new SshException("Key exchange failed [id=" + (int)object2[0] + "]", 5);
        }
        object = new ByteArrayReader((byte[])object2, 1, ((Object)object2).length - 1);
        try {
            this.hostKey = ((ByteArrayReader)object).readBinaryString();
            this.ib = ((ByteArrayReader)object).readBigInteger();
            this.signature = ((ByteArrayReader)object).readBinaryString();
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(this.ib, fb, hb);
            DHPublicKey dHPublicKey = (DHPublicKey)this.eb.generatePublic(dHPublicKeySpec);
            this.mb.doPhase(dHPublicKey, true);
            object2 = this.mb.generateSecret();
            if ((object2[0] & 0x80) == 128) {
                byte[] byArray3 = new byte[((Object)object2).length + 1];
                System.arraycopy(object2, 0, byArray3, 1, ((Object)object2).length);
                object2 = byArray3;
            }
            this.secret = new BigInteger((byte[])object2);
            this.calculateExchangeHash();
        }
        catch (Exception exception) {
            throw new SshException("Failed to read SSH_MSG_KEXDH_REPLY from message buffer", 5);
        }
    }

    public String getProvider() {
        if (this.mb != null) {
            return this.mb.getProvider().getName();
        }
        return "";
    }

    protected void calculateExchangeHash() throws SshException {
        Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance("SHA-1");
        digest.putString(this.cb);
        digest.putString(this.gb);
        digest.putInt(this.lb.length);
        digest.putBytes(this.lb);
        digest.putInt(this.pb.length);
        digest.putBytes(this.pb);
        digest.putInt(this.hostKey.length);
        digest.putBytes(this.hostKey);
        digest.putBigInteger(this.kb);
        digest.putBigInteger(this.ib);
        digest.putBigInteger(this.secret);
        this.exchangeHash = digest.doFinal();
    }

    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP14_SHA1;
    }

    public boolean isKeyExchangeMessage(int n) {
        switch (n) {
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    static {
        hb = jb = BigInteger.valueOf(2L);
        fb = DiffieHellmanGroups.group14;
    }
}

