/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.ssh.components.jce.Ssh2RsaPublicKey;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

public class SshX509RsaPublicKey
extends Ssh2RsaPublicKey {
    public static final String X509V3_SIGN_RSA = "x509v3-sign-rsa";
    X509Certificate e;

    public SshX509RsaPublicKey() {
    }

    public SshX509RsaPublicKey(X509Certificate x509Certificate) {
        super((RSAPublicKey)x509Certificate.getPublicKey());
        this.e = x509Certificate;
    }

    public String getAlgorithm() {
        return X509V3_SIGN_RSA;
    }

    public byte[] getEncoded() throws SshException {
        try {
            return this.e.getEncoded();
        }
        catch (Throwable throwable) {
            throw new SshException("Failed to encoded key data", 5, throwable);
        }
    }

    public void init(byte[] byArray, int n, int n2) throws SshException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            CertificateFactory certificateFactory = JCEProvider.getProviderForAlgorithm("X.509") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", JCEProvider.getProviderForAlgorithm("X.509"));
            this.e = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            if (!(this.e.getPublicKey() instanceof RSAPublicKey)) {
                throw new SshException("Certificate public key is not an RSA public key!", 4);
            }
            this.c = (RSAPublicKey)this.e.getPublicKey();
        }
        catch (Throwable throwable) {
            throw new SshException(throwable.getMessage(), 16, throwable);
        }
    }

    public X509Certificate getCertificate() {
        return this.e;
    }
}

