/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.standalone;

import com.maverick.crypto.security.SecureRandom;
import com.maverick.events.EventLog;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.DiffieHellmanGroups;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;

public class DiffieHellmanGroup1Sha1
extends SshKeyExchangeClient {
    public static final String DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    static final BigInteger q = BigInteger.valueOf(1L);
    static final BigInteger w;
    static final BigInteger u;
    static final BigInteger s;
    static final BigInteger r;
    BigInteger x = null;
    BigInteger v = null;
    BigInteger ab = null;
    BigInteger z = null;
    String p;
    String t;
    byte[] y;
    byte[] bb;

    public DiffieHellmanGroup1Sha1() {
        super("SHA-1");
    }

    public boolean isKeyExchangeMessage(int n) {
        switch (n) {
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP1_SHA1;
    }

    public void performClientExchange(String string, String string2, byte[] byArray, byte[] byArray2) throws SshException {
        try {
            this.p = string;
            this.t = string2;
            this.y = byArray;
            this.bb = byArray2;
            do {
                this.ab = new BigInteger(s.bitLength(), SecureRandom.getInstance());
            } while (this.ab.compareTo(q) < 0 || this.ab.compareTo(r) > 0);
            this.x = u.modPow(this.ab, s);
            if (this.x.compareTo(q) < 0 || this.x.compareTo(s.subtract(q)) > 0) {
                this.transport.disconnect(3, "Failed to generate key exchange value");
                throw new SshException("Key exchange failed to generate e value", 5);
            }
            EventLog.LogDebugEvent(this, "Secret will be " + this.ab.toString(16));
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(30);
            byteArrayWriter.writeBigInteger(this.x);
            this.transport.sendMessage(byteArrayWriter.toByteArray(), true);
            byte[] byArray3 = this.transport.nextMessage();
            if (byArray3[0] != 31) {
                this.transport.disconnect(3, "Key exchange failed");
                throw new SshException("Key exchange failed [id=" + byArray3[0] + "]", 5);
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray3, 1, byArray3.length - 1);
            this.hostKey = byteArrayReader.readBinaryString();
            this.v = byteArrayReader.readBigInteger();
            this.signature = byteArrayReader.readBinaryString();
            this.secret = this.v.modPow(this.ab, s);
            this.calculateExchangeHash();
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    protected void calculateExchangeHash() throws SshException {
        Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance("SHA-1");
        digest.putString(this.p);
        digest.putString(this.t);
        digest.putInt(this.y.length);
        digest.putBytes(this.y);
        digest.putInt(this.bb.length);
        digest.putBytes(this.bb);
        digest.putInt(this.hostKey.length);
        digest.putBytes(this.hostKey);
        digest.putBigInteger(this.x);
        digest.putBigInteger(this.v);
        digest.putBigInteger(this.secret);
        this.exchangeHash = digest.doFinal();
    }

    static {
        u = w = BigInteger.valueOf(2L);
        s = DiffieHellmanGroups.group1;
        r = s.subtract(q).divide(w);
    }
}

