/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.events.EventLog;
import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.HostKeyVerification;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentFactory;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh2.BannerDisplay;
import com.maverick.ssh2.MaverickCallbackHandler;

public final class Ssh2Context
implements SshContext {
    ComponentFactory eb;
    ComponentFactory bb;
    ComponentFactory z;
    ComponentFactory v;
    ComponentFactory n;
    ComponentFactory kb;
    ComponentFactory gb;
    ComponentFactory cb;
    public static final String CIPHER_TRIPLEDES_CBC = "3des-cbc";
    public static final String CIPHER_TRIPLEDES_CTR = "3des-ctr";
    public static final String CIPHER_BLOWFISH_CBC = "blowfish-cbc";
    public static final String CIPHER_AES128_CBC = "aes128-cbc";
    public static final String CIPHER_AES192_CBC = "aes192-cbc";
    public static final String CIPHER_AES256_CBC = "aes256-cbc";
    public static final String CIPHER_AES128_CTR = "aes128-ctr";
    public static final String CIPHER_AES192_CTR = "aes192-ctr";
    public static final String CIPHER_AES256_CTR = "aes256-ctr";
    public static final String CIPHER_ARCFOUR = "arcfour";
    public static final String CIPHER_ARCFOUR_128 = "arcfour128";
    public static final String CIPHER_ARCFOUR_256 = "arcfour256";
    public static final String HMAC_SHA1 = "hmac-sha1";
    public static final String HMAC_SHA1_96 = "hmac-sha1-96";
    public static final String HMAC_MD5 = "hmac-md5";
    public static final String HMAC_MD5_96 = "hmac-md5-96";
    public static final String HMAC_SHA256 = "hmac-sha256";
    public static final String COMPRESSION_NONE = "none";
    public static final String COMPRESSION_ZLIB = "zlib";
    public static final String KEX_DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA256 = "diffie-hellman-group-exchange-sha256";
    public static final String PUBLIC_KEY_SSHDSS = "ssh-dss";
    public static final String PUBLIC_KEY_SSHRSA = "ssh-rsa";
    String pb = "3des-cbc";
    String nb = "3des-cbc";
    String l = "hmac-sha1";
    String j = "hmac-sha1";
    String m = "none";
    String k = "none";
    String y = "diffie-hellman-group1-sha1";
    String x = "ssh-dss";
    String q = "/usr/libexec/sftp-server";
    int t = 100;
    BannerDisplay r;
    HostKeyVerification s;
    String lb = null;
    byte[] ab = null;
    byte[] ob = null;
    ForwardingRequestListener mb = null;
    String jb = "";
    int p = 131072;
    boolean fb = false;
    int u = 30000;
    int db = 128;
    int w = 0;
    boolean ib = false;
    int hb = 0;
    MaverickCallbackHandler o = null;

    public Ssh2Context() throws SshException {
        try {
            this.z = ComponentManager.getInstance().supportedSsh2CiphersCS();
            this.v = ComponentManager.getInstance().supportedSsh2CiphersSC();
            this.n = ComponentManager.getInstance().supportedKeyExchanges();
            this.kb = ComponentManager.getInstance().supportedHMacsCS();
            this.gb = ComponentManager.getInstance().supportedHMacsSC();
            this.cb = ComponentManager.getInstance().supportedPublicKeys();
            if (this.z.contains(CIPHER_AES128_CBC)) {
                this.pb = CIPHER_AES128_CBC;
            }
            if (this.v.contains(CIPHER_AES128_CBC)) {
                this.nb = CIPHER_AES128_CBC;
            }
            EventLog.LogEvent(this, "Creating compression factory");
            this.bb = new ComponentFactory(Class.forName("com.maverick.ssh.compression.SshCompression"));
            EventLog.LogEvent(this, "Adding None Compression");
            this.bb.add(COMPRESSION_NONE, Class.forName("java.lang.Object"));
            try {
                EventLog.LogEvent(this, "Adding ZLib Compression");
                this.bb.add(COMPRESSION_ZLIB, Class.forName("com.sshtools.zlib.ZLibCompression"));
                this.bb.add("zlib@openssh.com", Class.forName("com.sshtools.zlib.OpenSSHZLibCompression"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.eb = new ComponentFactory(Class.forName("com.maverick.ssh.compression.SshCompression"));
            EventLog.LogEvent(this, "Adding None Compression");
            this.eb.add(COMPRESSION_NONE, Class.forName("java.lang.Object"));
            try {
                EventLog.LogEvent(this, "Adding ZLib Compression");
                this.eb.add(COMPRESSION_ZLIB, Class.forName("com.sshtools.zlib.ZLibCompression"));
                this.eb.add("zlib@openssh.com", Class.forName("com.sshtools.zlib.OpenSSHZLibCompression"));
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            throw new SshException(throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName(), 5);
        }
        EventLog.LogEvent(this, "Completed Ssh2Context creation");
    }

    public int getMaximumPacketLength() {
        return this.p;
    }

    public void setGssCallback(MaverickCallbackHandler maverickCallbackHandler) {
        this.o = maverickCallbackHandler;
    }

    public MaverickCallbackHandler getGssCallback() {
        return this.o;
    }

    public void setMaximumPacketLength(int n) {
        if (n < 35000) {
            throw new IllegalArgumentException("The minimum packet length supported must be 35,000 bytes or greater!");
        }
        this.p = n;
    }

    public void setChannelLimit(int n) {
        this.t = n;
    }

    public int getChannelLimit() {
        return this.t;
    }

    public void setX11Display(String string) {
        this.lb = string;
    }

    public String getX11Display() {
        return this.lb;
    }

    public byte[] getX11AuthenticationCookie() throws SshException {
        if (this.ab == null) {
            this.ab = new byte[16];
            ComponentManager.getInstance().getRND().nextBytes(this.ab);
        }
        return this.ab;
    }

    public void setX11RealCookie(byte[] byArray) {
        this.ob = byArray;
    }

    public byte[] getX11RealCookie() throws SshException {
        if (this.ob == null) {
            this.ob = this.getX11AuthenticationCookie();
        }
        return this.ob;
    }

    public void setX11RequestListener(ForwardingRequestListener forwardingRequestListener) {
        this.mb = forwardingRequestListener;
    }

    public ForwardingRequestListener getX11RequestListener() {
        return this.mb;
    }

    public BannerDisplay getBannerDisplay() {
        return this.r;
    }

    public void setBannerDisplay(BannerDisplay bannerDisplay) {
        this.r = bannerDisplay;
    }

    public ComponentFactory supportedCiphersSC() {
        return this.v;
    }

    public ComponentFactory supportedCiphersCS() {
        return this.z;
    }

    public String getPreferredCipherCS() {
        return this.pb;
    }

    public void setPreferredCipherCS(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.z.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.pb = string;
        this.setCipherPreferredPositionCS(string, 0);
    }

    public String getPreferredCipherSC() {
        return this.nb;
    }

    public String getCiphersCS() {
        return this.z.list(this.pb);
    }

    public String getCiphersSC() {
        return this.v.list(this.nb);
    }

    public String getMacsCS() {
        return this.kb.list(this.l);
    }

    public String getMacsSC() {
        return this.gb.list(this.j);
    }

    public String getPublicKeys() {
        return this.cb.list(this.x);
    }

    public String getKeyExchanges() {
        return this.n.list(this.y);
    }

    public void setPreferredCipherSC(int[] nArray) throws SshException {
        this.nb = this.v.createNewOrdering(nArray);
    }

    public void setPreferredCipherCS(int[] nArray) throws SshException {
        this.pb = this.z.createNewOrdering(nArray);
    }

    public void setCipherPreferredPositionCS(String string, int n) throws SshException {
        this.pb = this.z.changePositionofAlgorithm(string, n);
    }

    public void setCipherPreferredPositionSC(String string, int n) throws SshException {
        this.nb = this.v.changePositionofAlgorithm(string, n);
    }

    public void setMacPreferredPositionSC(String string, int n) throws SshException {
        this.j = this.gb.changePositionofAlgorithm(string, n);
    }

    public void setMacPreferredPositionCS(String string, int n) throws SshException {
        this.l = this.kb.changePositionofAlgorithm(string, n);
    }

    public void setPreferredMacSC(int[] nArray) throws SshException {
        this.nb = this.gb.createNewOrdering(nArray);
    }

    public void setPreferredMacCS(int[] nArray) throws SshException {
        this.nb = this.kb.createNewOrdering(nArray);
    }

    public void setPreferredCipherSC(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.v.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.nb = string;
        this.setCipherPreferredPositionSC(string, 0);
    }

    public ComponentFactory supportedMacsSC() {
        return this.gb;
    }

    public ComponentFactory supportedMacsCS() {
        return this.kb;
    }

    public String getPreferredMacCS() {
        return this.l;
    }

    public void setPreferredMacCS(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.kb.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.l = string;
        this.setMacPreferredPositionCS(string, 0);
    }

    public String getPreferredMacSC() {
        return this.j;
    }

    public void setPreferredMacSC(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.gb.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.j = string;
        this.setMacPreferredPositionSC(string, 0);
    }

    public ComponentFactory supportedCompressionsSC() {
        return this.bb;
    }

    public ComponentFactory supportedCompressionsCS() {
        return this.eb;
    }

    public String getPreferredCompressionCS() {
        return this.m;
    }

    public void setPreferredCompressionCS(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.eb.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.m = string;
    }

    public String getPreferredCompressionSC() {
        return this.k;
    }

    public void setPreferredCompressionSC(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.bb.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.k = string;
    }

    public void enableCompression() throws SshException {
        this.supportedCompressionsCS().changePositionofAlgorithm(COMPRESSION_ZLIB, 0);
        this.supportedCompressionsCS().changePositionofAlgorithm("zlib@openssh.com", 1);
        this.m = this.supportedCompressionsCS().changePositionofAlgorithm(COMPRESSION_NONE, 2);
        this.supportedCompressionsSC().changePositionofAlgorithm(COMPRESSION_ZLIB, 0);
        this.supportedCompressionsSC().changePositionofAlgorithm("zlib@openssh.com", 1);
        this.k = this.supportedCompressionsSC().changePositionofAlgorithm(COMPRESSION_NONE, 2);
    }

    public void disableCompression() throws SshException {
        this.supportedCompressionsCS().changePositionofAlgorithm(COMPRESSION_NONE, 0);
        this.supportedCompressionsCS().changePositionofAlgorithm(COMPRESSION_ZLIB, 1);
        this.m = this.supportedCompressionsCS().changePositionofAlgorithm("zlib@openssh.com", 2);
        this.supportedCompressionsSC().changePositionofAlgorithm(COMPRESSION_NONE, 0);
        this.supportedCompressionsSC().changePositionofAlgorithm(COMPRESSION_ZLIB, 1);
        this.k = this.supportedCompressionsSC().changePositionofAlgorithm("zlib@openssh.com", 2);
    }

    public ComponentFactory supportedKeyExchanges() {
        return this.n;
    }

    public String getPreferredKeyExchange() {
        return this.y;
    }

    public void setPreferredKeyExchange(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.n.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.y = string;
        this.setKeyExchangePreferredPosition(string, 0);
    }

    public ComponentFactory supportedPublicKeys() {
        return this.cb;
    }

    public String getPreferredPublicKey() {
        return this.x;
    }

    public void setPreferredPublicKey(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.cb.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.x = string;
        this.setPublicKeyPreferredPosition(string, 0);
    }

    public void setHostKeyVerification(HostKeyVerification hostKeyVerification) {
        this.s = hostKeyVerification;
    }

    public HostKeyVerification getHostKeyVerification() {
        return this.s;
    }

    public void setSFTPProvider(String string) {
        this.q = string;
    }

    public String getSFTPProvider() {
        return this.q;
    }

    public void setPartialMessageTimeout(int n) {
        this.u = n;
    }

    public int getPartialMessageTimeout() {
        return this.u;
    }

    public boolean isKeyReExchangeDisabled() {
        return this.fb;
    }

    public void setKeyReExchangeDisabled(boolean bl) {
        this.fb = bl;
    }

    public void setPublicKeyPreferredPosition(String string, int n) throws SshException {
        this.x = this.cb.changePositionofAlgorithm(string, n);
    }

    public void setKeyExchangePreferredPosition(String string, int n) throws SshException {
        this.y = this.n.changePositionofAlgorithm(string, n);
    }

    public int getIdleConnectionTimeoutSeconds() {
        return this.w;
    }

    public void setIdleConnectionTimeoutSeconds(int n) {
        this.w = n;
    }

    public boolean isSendIgnorePacketOnIdle() {
        return this.ib;
    }

    public void setSendIgnorePacketOnIdle(boolean bl) {
        this.ib = bl;
    }

    public int getKeepAliveMaxDataLength() {
        return this.db;
    }

    public void setKeepAliveMaxDataLength(int n) {
        if (n < 8) {
            throw new IllegalArgumentException("There must be at least 8 bytes of random data");
        }
        this.db = n;
    }

    public int getSocketTimeout() {
        return this.hb;
    }

    public void setSocketTimeout(int n) {
        this.hb = n;
    }
}

