/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshDsaPublicKey;
import com.maverick.ssh.components.SshPrivateKey;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh.components.SshRsaPublicKey;
import com.maverick.ssh2.AuthenticationClient;
import com.maverick.ssh2.AuthenticationProtocol;
import com.maverick.ssh2.AuthenticationResult;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;

public class Ssh2HostbasedAuthentication
implements AuthenticationClient {
    String n;
    String m;
    String l;
    SshPrivateKey j;
    SshPublicKey k;

    public void authenticate(AuthenticationProtocol authenticationProtocol, String string) throws SshException, AuthenticationResult {
        if (this.m == null) {
            throw new SshException("Username not set!", 4);
        }
        if (this.n == null) {
            throw new SshException("Client hostname not set!", 4);
        }
        if (this.l == null) {
            this.l = this.m;
        }
        if (this.j == null || this.k == null) {
            throw new SshException("Client host keys not set!", 4);
        }
        if (!(this.k instanceof SshRsaPublicKey) && !(this.k instanceof SshDsaPublicKey)) {
            throw new SshException("Invalid public key type for SSH2 authentication!", 4);
        }
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.k.getAlgorithm());
            byteArrayWriter.writeBinaryString(this.k.getEncoded());
            byteArrayWriter.writeString(this.n);
            byteArrayWriter.writeString(this.l);
            ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
            byteArrayWriter2.writeBinaryString(authenticationProtocol.getSessionIdentifier());
            byteArrayWriter2.write(50);
            byteArrayWriter2.writeString(this.m);
            byteArrayWriter2.writeString(string);
            byteArrayWriter2.writeString("hostbased");
            byteArrayWriter2.writeString(this.k.getAlgorithm());
            byteArrayWriter2.writeBinaryString(this.k.getEncoded());
            byteArrayWriter2.writeString(this.n);
            byteArrayWriter2.writeString(this.l);
            ByteArrayWriter byteArrayWriter3 = new ByteArrayWriter();
            byteArrayWriter3.writeString(this.k.getAlgorithm());
            byteArrayWriter3.writeBinaryString(this.j.sign(byteArrayWriter2.toByteArray()));
            byteArrayWriter.writeBinaryString(byteArrayWriter3.toByteArray());
            authenticationProtocol.sendRequest(this.getUsername(), string, "hostbased", byteArrayWriter.toByteArray());
            byte[] byArray = authenticationProtocol.readMessage();
            throw new SshException("Unexpected message returned from authentication protocol: " + byArray[0], 3);
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public String getMethod() {
        return "hostbased";
    }

    public void setClientHostname(String string) {
        this.n = string;
    }

    public void setUsername(String string) {
        this.m = string;
    }

    public String getUsername() {
        return this.m;
    }

    public void setPublicKey(SshPublicKey sshPublicKey) {
        this.k = sshPublicKey;
    }

    public void setPrivateKey(SshPrivateKey sshPrivateKey) {
        this.j = sshPrivateKey;
    }

    public void setClientUsername(String string) {
        this.l = string;
    }

    public String getClientUsername() {
        return this.l;
    }

    public SshPrivateKey getPrivateKey() {
        return this.j;
    }

    public SshPublicKey getPublicKey() {
        return this.k;
    }
}

