/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.events.Event;
import com.maverick.events.EventServiceImplementation;
import com.maverick.ssh.PseudoTerminalModes;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh2.Ssh2Channel;
import com.maverick.ssh2.Ssh2Client;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;
import java.io.InputStream;

public class Ssh2Session
extends Ssh2Channel
implements SshSession {
    Ssh2Channel._d md;
    boolean ld = false;
    int nd = Integer.MIN_VALUE;
    String kd = "";
    Ssh2Client jd;

    public Ssh2Session(int n, int n2, Ssh2Client ssh2Client) {
        super("session", n, n2);
        this.jd = ssh2Client;
        this.md = this.createExtendedDataStream();
    }

    public SshClient getClient() {
        return this.jd;
    }

    protected void processExtendedData(int n, byte[] byArray, int n2, int n3) throws SshException {
        super.processExtendedData(n, byArray, n2, n3);
        if (n == 1) {
            this.md.b(byArray, n2, n3);
        }
    }

    public InputStream getStderrInputStream() {
        return this.md;
    }

    public boolean requestPseudoTerminal(String string, int n, int n2, int n3, int n4) throws SshException {
        return this.requestPseudoTerminal(string, n, n2, n3, n4, new byte[]{0});
    }

    public boolean requestPseudoTerminal(String string, int n, int n2, int n3, int n4, PseudoTerminalModes pseudoTerminalModes) throws SshException {
        return this.requestPseudoTerminal(string, n, n2, n3, n4, pseudoTerminalModes.toByteArray());
    }

    public boolean requestPseudoTerminal(String string, int n, int n2, int n3, int n4, byte[] byArray) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeInt(n);
            byteArrayWriter.writeInt(n2);
            byteArrayWriter.writeInt(n3);
            byteArrayWriter.writeInt(n4);
            byteArrayWriter.writeBinaryString(byArray);
            return this.sendRequest("pty-req", true, byteArrayWriter.toByteArray());
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean startShell() throws SshException {
        boolean bl = this.sendRequest("shell", true, null);
        if (bl) {
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 23, true));
        } else {
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 24, false));
        }
        this.vb = true;
        return bl;
    }

    public boolean executeCommand(String string) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            boolean bl = this.sendRequest("exec", true, byteArrayWriter.toByteArray());
            if (bl) {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 30, true).addAttribute("COMMAND", string));
            } else {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 30, false).addAttribute("COMMAND", string));
            }
            this.vb = true;
            return bl;
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean executeCommand(String string, String string2) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string, string2);
            boolean bl = this.sendRequest("exec", true, byteArrayWriter.toByteArray());
            if (bl) {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 30, true).addAttribute("COMMAND", string));
            } else {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 30, false).addAttribute("COMMAND", string));
            }
            this.vb = true;
            return bl;
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean startSubsystem(String string) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            boolean bl = this.sendRequest("subsystem", true, byteArrayWriter.toByteArray());
            if (bl) {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 1001, true).addAttribute("COMMAND", string));
            } else {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 1001, false).addAttribute("COMMAND", string));
            }
            this.vb = true;
            return bl;
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    boolean b(boolean bl, String string, String string2, int n) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeBoolean(bl);
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString(string2);
            byteArrayWriter.writeInt(n);
            return this.sendRequest("x11-req", true, byteArrayWriter.toByteArray());
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean setEnvironmentVariable(String string, String string2) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString(string2);
            return this.sendRequest("env", true, byteArrayWriter.toByteArray());
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public void changeTerminalDimensions(int n, int n2, int n3, int n4) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeInt(n);
            byteArrayWriter.writeInt(n2);
            byteArrayWriter.writeInt(n4);
            byteArrayWriter.writeInt(n3);
            this.sendRequest("window-change", false, byteArrayWriter.toByteArray());
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean isFlowControlEnabled() {
        return this.ld;
    }

    public void signal(String string) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            this.sendRequest("signal", false, byteArrayWriter.toByteArray());
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    protected void channelRequest(String string, boolean bl, byte[] byArray) throws SshException {
        try {
            if (string.equals("exit-status") && byArray != null) {
                this.nd = (int)ByteArrayReader.readInt(byArray, 0);
            }
            if (string.equals("exit-signal") && byArray != null) {
                ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, 0, byArray.length);
                this.kd = "Signal=" + byteArrayReader.readString() + " CoreDump=" + String.valueOf(byteArrayReader.read() != 0) + " Message=" + byteArrayReader.readString();
            }
            if (string.equals("xon-xoff")) {
                this.ld = byArray != null && byArray[0] != 0;
            }
            super.channelRequest(string, bl, byArray);
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public int exitCode() {
        return this.nd;
    }

    public boolean hasExitSignal() {
        return !this.kd.equals("");
    }

    public String getExitSignalInfo() {
        return this.kd;
    }
}

