/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.util;

import com.maverick.util.b;
import com.maverick.util.c;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EOLProcessor {
    public static final int TEXT_SYSTEM = 0;
    public static final int TEXT_WINDOWS = 1;
    public static final int TEXT_DOS = 1;
    public static final int TEXT_CRLF = 1;
    public static final int TEXT_UNIX = 2;
    public static final int TEXT_LF = 2;
    public static final int TEXT_MAC = 3;
    public static final int TEXT_CR = 3;
    public static final int TEXT_ALL = 4;
    byte[] d;
    String i = System.getProperty("line.separator");
    boolean c = false;
    boolean g = false;
    boolean h = false;
    boolean f = false;
    boolean b = false;
    OutputStream e;

    public EOLProcessor(int n, int n2, OutputStream outputStream) throws IOException {
        this.e = new BufferedOutputStream(outputStream);
        switch (n) {
            case 1: {
                this.h = true;
                break;
            }
            case 3: {
                this.c = true;
                break;
            }
            case 2: {
                this.g = true;
                break;
            }
            case 4: {
                this.c = true;
                this.g = true;
                this.h = true;
                break;
            }
            case 0: {
                byte[] byArray = this.i.getBytes();
                if (byArray.length == 2 && byArray[0] == 13 && byArray[1] == 10) {
                    this.h = true;
                    break;
                }
                if (byArray.length == 1 && byArray[0] == 13) {
                    this.c = true;
                    break;
                }
                if (byArray.length == 1 && byArray[0] == 10) {
                    this.g = true;
                    break;
                }
                throw new IOException("Unsupported system EOL mode");
            }
            default: {
                throw new IllegalArgumentException("Unknown text style: " + n2);
            }
        }
        switch (n2) {
            case 0: {
                this.d = this.i.getBytes();
                break;
            }
            case 1: {
                this.d = new byte[]{13, 10};
                break;
            }
            case 3: {
                this.d = new byte[]{13};
                break;
            }
            case 2: {
                this.d = new byte[]{10};
                break;
            }
            case 4: {
                throw new IllegalArgumentException("TEXT_ALL cannot be used for an output style");
            }
            default: {
                throw new IllegalArgumentException("Unknown text style: " + n2);
            }
        }
    }

    public boolean hasBinary() {
        return this.f;
    }

    public void close() throws IOException {
        if (this.b && !this.c) {
            this.e.write(13);
        }
        this.e.close();
    }

    public void processBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray, n, n2), 32768);
        while ((n3 = bufferedInputStream.read()) != -1) {
            if (n3 == 13) {
                if (this.h) {
                    bufferedInputStream.mark(1);
                    int n4 = bufferedInputStream.read();
                    if (n4 == -1) {
                        this.b = true;
                        break;
                    }
                    if (n4 == 10) {
                        this.e.write(this.d);
                        continue;
                    }
                    bufferedInputStream.reset();
                    if (this.c) {
                        this.e.write(this.d);
                        continue;
                    }
                    this.e.write(n3);
                    continue;
                }
                if (this.c) {
                    this.e.write(this.d);
                    continue;
                }
                this.e.write(n3);
                continue;
            }
            if (n3 == 10) {
                if (this.b) {
                    this.e.write(this.d);
                    this.b = false;
                    continue;
                }
                if (this.g) {
                    this.e.write(this.d);
                    continue;
                }
                this.e.write(n3);
                continue;
            }
            if (this.b) {
                if (this.c) {
                    this.e.write(this.d);
                } else {
                    this.e.write(n3);
                }
            }
            if (n3 != 116 && n3 != 12 && (n3 & 0xFF) < 32) {
                this.f = true;
            }
            this.e.write(n3);
        }
        this.e.flush();
    }

    public static OutputStream createOutputStream(int n, int n2, OutputStream outputStream) throws IOException {
        return new b(n, n2, outputStream);
    }

    public static InputStream createInputStream(int n, int n2, InputStream inputStream) throws IOException {
        return new c(n, n2, inputStream);
    }
}

