/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.ssh.components.SshKeyPair;
import com.maverick.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.publickey.Base64EncodedFileFormat;
import com.sshtools.publickey.InvalidPassphraseException;
import com.sshtools.publickey.SshPrivateKeyFile;
import com.sshtools.publickey.d;
import com.sshtools.publickey.g;
import com.sshtools.publickey.h;
import com.sshtools.publickey.i;
import com.sshtools.publickey.j;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPrivateKeyFileFactory {
    public static final int OPENSSH_FORMAT = 0;
    public static final int SSHTOOLS_FORMAT = 1;
    public static final int SSH1_FORMAT = 3;

    public static SshPrivateKeyFile parse(byte[] byArray) throws IOException {
        try {
            if (j.d(byArray)) {
                return new j(byArray);
            }
            if (Base64EncodedFileFormat.isFormatted(byArray, i.i, i.k)) {
                return new i(byArray);
            }
            if (d.b(byArray)) {
                return new d(byArray);
            }
            if (g.c(byArray)) {
                return new g(byArray);
            }
            if (h.e(byArray)) {
                return new h(byArray);
            }
            throw new IOException("A suitable key format could not be found!");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("An error occurred parsing a private key file! Is the file corrupt?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPrivateKeyFile parse(InputStream inputStream) throws IOException {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) > -1) {
                byteArrayOutputStream.write(n);
            }
            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFileFactory.parse(byteArrayOutputStream.toByteArray());
            return sshPrivateKeyFile;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPrivateKeyFile create(SshKeyPair sshKeyPair, String string, String string2, int n) throws IOException {
        if (!(sshKeyPair.getPrivateKey() instanceof SshRsaPrivateCrtKey) && n == 3) {
            throw new IOException("SSH1 format requires rsa key pair!");
        }
        switch (n) {
            case 0: {
                return new j(sshKeyPair, string);
            }
            case 1: {
                return new i(sshKeyPair, string, string2);
            }
            case 3: {
                return new d(sshKeyPair, string, string2);
            }
        }
        throw new IOException("Invalid key format!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(SshKeyPair sshKeyPair, String string, String string2, int n, File file) throws IOException {
        SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFileFactory.create(sshKeyPair, string, string2, n);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(sshPrivateKeyFile.getFormattedKey());
            fileOutputStream.flush();
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static void convertFile(File file, String string, String string2, int n, File file2) throws IOException, InvalidPassphraseException {
        SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFileFactory.parse(new FileInputStream(file));
        SshPrivateKeyFileFactory.createFile(sshPrivateKeyFile.toKeyPair(string), string, string2, n, file2);
    }
}

