/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sftp;

import com.maverick.events.Event;
import com.maverick.events.EventLog;
import com.maverick.events.EventServiceImplementation;
import com.maverick.sftp.FileTransferProgress;
import com.maverick.sftp.SftpFile;
import com.maverick.sftp.SftpFileAttributes;
import com.maverick.sftp.SftpFileInputStream;
import com.maverick.sftp.SftpFileOutputStream;
import com.maverick.sftp.SftpStatusException;
import com.maverick.sftp.SftpSubsystemChannel;
import com.maverick.sftp.TransferCancelledException;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.Client;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh1.Ssh1Client;
import com.maverick.ssh2.Ssh2Client;
import com.maverick.ssh2.Ssh2Session;
import com.maverick.util.EOLProcessor;
import com.maverick.util.IOUtil;
import com.maverick.util.UnsignedInteger32;
import com.maverick.util.UnsignedInteger64;
import com.sshtools.sftp.DirectoryOperation;
import com.sshtools.sftp.GlobRegExpMatching;
import com.sshtools.sftp.NoRegExpMatching;
import com.sshtools.sftp.Perl5RegExpMatching;
import com.sshtools.sftp.RegularExpressionMatching;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpClient
implements Client {
    SftpSubsystemChannel ic;
    String ec;
    String fc;
    private int dc = 4096;
    private int jc = 100;
    private int cc = -1;
    int lc = 18;
    public static final int MODE_BINARY = 1;
    public static final int MODE_TEXT = 2;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final int EOL_CR = 3;
    private int gc = 1;
    private int hc = 1;
    private Vector mc;
    public static final int NoSyntax = 0;
    public static final int GlobSyntax = 1;
    public static final int Perl5Syntax = 2;
    private int kc;

    public SftpClient(SshClient sshClient) throws SftpStatusException, SshException, ChannelOpenException {
        this(sshClient, SftpSubsystemChannel.MAX_VERSION);
    }

    public SftpClient(SshSession sshSession) throws SftpStatusException, SshException {
        this(sshSession, SftpSubsystemChannel.MAX_VERSION);
    }

    public SftpClient(SshSession sshSession, int n) throws SftpStatusException, SshException {
        this.mc = new Vector();
        this.kc = 1;
        this.b(sshSession, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SftpClient(SshClient var1_1, int var2_2) throws SftpStatusException, SshException, ChannelOpenException {
        super();
        this.mc = new Vector<E>();
        this.kc = 1;
        var3_3 = null;
        if (var1_1 instanceof Ssh1Client) {
            EventLog.LogDebugEvent(this, "SFTP may not be supported on SSH1, searching for sftp-server binary");
            try {
                var3_3 = var1_1.openSessionChannel();
                if (!var3_3.executeCommand("find / -name 'sftp-server'")) ** GOTO lbl33
                var4_4 = new BufferedReader(new InputStreamReader(var3_3.getInputStream()));
                while ((var5_6 = var4_4.readLine()) != null) {
                    if (!var5_6.startsWith("/") || !var5_6.endsWith("sftp-server")) continue;
                    var1_1.getContext().setSFTPProvider(var5_6);
                    EventLog.LogDebugEvent(this, "Found SFTP provider " + var5_6);
                }
                var4_4.close();
            }
            catch (Exception var4_5) {
            }
            finally {
                if (var3_3 != null) {
                    var3_3.close();
                }
                var3_3 = var1_1.openSessionChannel();
            }
        } else {
            EventLog.LogDebugEvent(this, "SFTP will be performed over an SSH2 connection");
            var3_3 = ((Ssh2Client)var1_1).openSessionChannel(131072, 16384, null);
        }
lbl33:
        // 4 sources

        if (var3_3 instanceof Ssh2Session) {
            var4_4 = (Ssh2Session)var3_3;
            if (!var4_4.startSubsystem("sftp")) {
                EventLog.LogDebugEvent(this, "The SFTP subsystem failed to start, attempting to execute provider " + var1_1.getContext().getSFTPProvider());
                if (!var4_4.executeCommand(var1_1.getContext().getSFTPProvider())) {
                    var4_4.close();
                    throw new SshException("Failed to start SFTP subsystem or SFTP provider " + var1_1.getContext().getSFTPProvider(), 6);
                }
            }
        } else if (!var3_3.executeCommand(var1_1.getContext().getSFTPProvider())) {
            var3_3.close();
            throw new SshException("Failed to launch SFTP provider " + var1_1.getContext().getSFTPProvider(), 6);
        }
        this.b(var3_3, var2_2);
    }

    private void b(SshSession sshSession, int n) throws SftpStatusException, SshException {
        this.ic = new SftpSubsystemChannel(sshSession, n);
        try {
            this.ic.initialize();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.ec = this.ic.getDefaultDirectory();
        String string = "";
        try {
            string = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.fc = string;
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 22, true));
    }

    public void setBlockSize(int n) {
        if (n < 512) {
            throw new IllegalArgumentException("Block size must be greater than 512");
        }
        this.dc = n;
    }

    public SftpSubsystemChannel getSubsystemChannel() {
        return this.ic;
    }

    public void setTransferMode(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Mode can only be either binary or text");
        }
        this.hc = n;
        EventLog.LogDebugEvent(this, "Transfer mode set to " + (n == 1 ? "binary" : "text"));
    }

    public void setRemoteEOL(int n) {
        this.gc = n;
        EventLog.LogDebugEvent(this, "Remote EOL set to " + (n == 1 ? "CRLF" : (n == 3 ? "CR" : "LF")));
    }

    public int getTransferMode() {
        return this.hc;
    }

    public void setBufferSize(int n) {
        this.cc = n;
        EventLog.LogDebugEvent(this, "Buffer size set to " + n);
    }

    public void setMaxAsyncRequests(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Maximum asynchronous requests must be greater or equal to 1");
        }
        this.jc = n;
        EventLog.LogDebugEvent(this, "Max async requests set to " + n);
    }

    public int umask(int n) {
        int n2 = this.lc;
        this.lc = n;
        EventLog.LogDebugEvent(this, "umask " + n);
        return n2;
    }

    public SftpFile openFile(String string) throws SftpStatusException, SshException {
        if (this.hc == 2 && this.ic.getVersion() > 3) {
            return this.ic.openFile(this.c(string), 65);
        }
        return this.ic.openFile(this.c(string), 1);
    }

    public void cd(String string) throws SftpStatusException, SshException {
        SftpFileAttributes sftpFileAttributes;
        String string2;
        if (string == null || string.equals("")) {
            string2 = this.ic.getDefaultDirectory();
        } else {
            string2 = this.c(string);
            string2 = this.ic.getAbsolutePath(string2);
        }
        if (!string2.equals("") && !(sftpFileAttributes = this.ic.getAttributes(string2)).isDirectory()) {
            throw new SftpStatusException(4, string + " is not a directory");
        }
        EventLog.LogDebugEvent(this, "Changing dir from " + this.ec + " to " + (string2.equals("") ? "user default dir" : string2));
        this.ec = string2;
    }

    public String getDefaultDirectory() throws SftpStatusException, SshException {
        return this.ic.getDefaultDirectory();
    }

    public void cdup() throws SftpStatusException, SshException {
        SftpFile sftpFile = this.ic.getFile(this.ec);
        SftpFile sftpFile2 = sftpFile.getParent();
        if (sftpFile2 != null) {
            this.ec = sftpFile2.getAbsolutePath();
        }
    }

    private File e(String string) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.fc, string);
        }
        return file;
    }

    private boolean i(String string) {
        return (string = string.trim()).length() > 2 && ((string.charAt(0) >= 'a' && string.charAt(0) <= 'z' || string.charAt(0) >= 'A' && string.charAt(0) <= 'Z') && string.charAt(1) == ':' && string.charAt(2) == '/' || string.charAt(2) == '\\');
    }

    public void addCustomRoot(String string) {
        this.mc.addElement(string);
    }

    public void removeCustomRoot(String string) {
        this.mc.removeElement(string);
    }

    private boolean h(String string) {
        Enumeration enumeration = this.mc.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            if (!string.startsWith((String)enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    private String c(String string) throws SftpStatusException {
        this.c();
        String string2 = !string.startsWith("/") && !string.startsWith(this.ec) && !this.i(string) && !this.h(string) ? this.ec + (this.ec.endsWith("/") ? "" : "/") + string : string;
        if (!string2.equals("/") && string2.endsWith("/")) {
            return string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private void c() throws SftpStatusException {
        if (this.ic.isClosed()) {
            throw new SftpStatusException(7, "The SFTP connection has been closed");
        }
    }

    public void mkdir(String string) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        EventLog.LogDebugEvent(this, "Creating dir " + string);
        SftpFileAttributes sftpFileAttributes = null;
        try {
            sftpFileAttributes = this.ic.getAttributes(string2);
        }
        catch (SftpStatusException sftpStatusException) {
            SftpFileAttributes sftpFileAttributes2 = new SftpFileAttributes(this.ic, 2);
            sftpFileAttributes2.setPermissions(new UnsignedInteger32(0x1FF ^ this.lc));
            this.ic.makeDirectory(string2, sftpFileAttributes2);
            return;
        }
        if (!sftpFileAttributes.isDirectory()) {
            EventLog.LogDebugEvent(this, "File with name " + string + " already exists!");
            throw new SftpStatusException(4, "File already exists named " + string);
        }
        EventLog.LogDebugEvent(this, "Directory " + string + " already exists!");
    }

    public void mkdirs(String string) throws SftpStatusException, SshException {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string3 = string2 = string.startsWith("/") ? "/" : "";
        while (stringTokenizer.hasMoreElements()) {
            block5: {
                string2 = string2 + (String)stringTokenizer.nextElement();
                try {
                    this.stat(string2);
                }
                catch (SftpStatusException sftpStatusException) {
                    try {
                        this.mkdir(string2);
                    }
                    catch (SftpStatusException sftpStatusException2) {
                        if (sftpStatusException2.getStatus() != 3) break block5;
                        throw sftpStatusException2;
                    }
                }
            }
            string2 = string2 + "/";
        }
    }

    public boolean isDirectoryOrLinkedDirectory(SftpFile sftpFile) throws SftpStatusException, SshException {
        return sftpFile.isDirectory() || sftpFile.isLink() && this.stat(sftpFile.getAbsolutePath()).isDirectory();
    }

    public String pwd() {
        return this.ec;
    }

    public SftpFile[] ls() throws SftpStatusException, SshException {
        return this.ls(this.ec);
    }

    public SftpFile[] ls(String string) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        EventLog.LogDebugEvent(this, "Listing files for " + string2);
        SftpFile sftpFile = this.ic.openDirectory(string2);
        Vector vector = new Vector();
        while (this.ic.listChildren(sftpFile, vector) > -1) {
        }
        sftpFile.close();
        SftpFile[] sftpFileArray = new SftpFile[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sftpFileArray[n++] = (SftpFile)enumeration.nextElement();
        }
        return sftpFileArray;
    }

    public void lcd(String string) throws SftpStatusException {
        File file = !SftpClient.g(string) ? new File(this.fc, string) : new File(string);
        if (!file.isDirectory()) {
            throw new SftpStatusException(4, string + " is not a directory");
        }
        try {
            this.fc = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new SftpStatusException(4, "Failed to canonicalize path " + string);
        }
    }

    private static boolean g(String string) {
        return new File(string).isAbsolute();
    }

    public String lpwd() {
        return this.fc;
    }

    public SftpFileAttributes get(String string, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, fileTransferProgress, false);
    }

    public SftpFileAttributes get(String string, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        String string2 = string.lastIndexOf("/") > -1 ? string.substring(string.lastIndexOf("/") + 1) : string;
        return this.get(string, string2, fileTransferProgress, bl);
    }

    public SftpFileAttributes get(String string, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, (FileTransferProgress)null, bl);
    }

    public SftpFileAttributes get(String string) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, (FileTransferProgress)null);
    }

    public SftpFileAttributes get(String string, String string2, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, string2, fileTransferProgress, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SftpFileAttributes get(String string, String string2, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        Object object;
        OutputStream outputStream = null;
        SftpFileAttributes sftpFileAttributes = null;
        File file = this.e(string2);
        if (!file.exists()) {
            File file2 = new File(file.getParent());
            file2.mkdirs();
        }
        if (file.isDirectory()) {
            int n = string.lastIndexOf(47);
            file = n > -1 ? new File(file, string.substring(n)) : new File(file, string);
        }
        this.stat(string);
        long l = 0L;
        try {
            if (bl && file.exists()) {
                l = file.length();
                object = new RandomAccessFile(file, "rw");
                ((RandomAccessFile)object).seek(l);
                outputStream = new _b((RandomAccessFile)object);
            } else {
                outputStream = new FileOutputStream(file);
            }
            if (this.hc == 2) {
                int n = this.gc;
                int n2 = 0;
                byte[] byArray = null;
                if (this.ic.getVersion() <= 3 && this.ic.getExtension("newline@vandyke.com") != null) {
                    byArray = this.ic.getExtension("newline@vandyke.com").getBytes();
                } else if (this.ic.getVersion() > 3) {
                    byArray = this.ic.getCanonicalNewline().getBytes();
                }
                if (byArray != null) {
                    switch (byArray.length) {
                        case 1: {
                            if (byArray[0] == 13) {
                                n = 3;
                                break;
                            }
                            if (byArray[0] != 10) throw new SftpStatusException(100, "Unsupported text mode: invalid newline character");
                            n = 2;
                            break;
                        }
                        case 2: {
                            if (byArray[0] != 13) throw new SftpStatusException(100, "Unsupported text mode: invalid newline characters");
                            if (byArray[1] != 10) throw new SftpStatusException(100, "Unsupported text mode: invalid newline characters");
                            n = 1;
                            break;
                        }
                        default: {
                            throw new SftpStatusException(100, "Unsupported text mode: newline length > 2");
                        }
                    }
                }
                outputStream = EOLProcessor.createOutputStream(n, n2, outputStream);
            }
            sftpFileAttributes = this.get(string, outputStream, fileTransferProgress, l);
            object = sftpFileAttributes;
        }
        catch (IOException iOException) {
            try {
                throw new SftpStatusException(4, "Failed to open outputstream to " + string2);
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (sftpFileAttributes == null) throw throwable;
                    Method method = file.getClass().getMethod("setLastModified", Long.TYPE);
                    method.invoke((Object)file, new Long(sftpFileAttributes.getModifiedTime().longValue() * 1000L));
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            if (sftpFileAttributes == null) return object;
            Method method = file.getClass().getMethod("setLastModified", Long.TYPE);
            method.invoke((Object)file, new Long(sftpFileAttributes.getModifiedTime().longValue() * 1000L));
            return object;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return object;
    }

    public SftpFileAttributes get(String string, String string2, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, string2, null, bl);
    }

    public SftpFileAttributes get(String string, String string2) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, string2, false);
    }

    public SftpFileAttributes get(String string, OutputStream outputStream, FileTransferProgress fileTransferProgress) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, outputStream, fileTransferProgress, 0L);
    }

    public void setRegularExpressionSyntax(int n) {
        this.kc = n;
    }

    private SftpFile[] d(String string) throws SftpStatusException, SshException {
        SftpFile[] sftpFileArray;
        RegularExpressionMatching regularExpressionMatching;
        String string2;
        String string3;
        int n = string.lastIndexOf("/");
        if (n > -1) {
            string3 = string.substring(0, n);
            string2 = string.length() > n + 1 ? string.substring(n + 1) : "";
        } else {
            string3 = this.ec;
            string2 = string;
        }
        switch (this.kc) {
            case 1: {
                regularExpressionMatching = new GlobRegExpMatching();
                sftpFileArray = this.ls(string3);
                break;
            }
            case 2: {
                regularExpressionMatching = new Perl5RegExpMatching();
                sftpFileArray = this.ls(string3);
                break;
            }
            default: {
                regularExpressionMatching = new NoRegExpMatching();
                sftpFileArray = new SftpFile[1];
                String string4 = this.c(string);
                sftpFileArray[0] = this.getSubsystemChannel().getFile(string4);
            }
        }
        return regularExpressionMatching.matchFilesWithPattern(sftpFileArray, string2);
    }

    private SftpFile[] b(String string, String string2, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        SftpFile[] sftpFileArray = this.d(string);
        Vector<SftpFile> vector = new Vector<SftpFile>();
        for (int k = 0; k < sftpFileArray.length; ++k) {
            this.get(sftpFileArray[k].getAbsolutePath(), string2, fileTransferProgress, bl);
            vector.addElement(sftpFileArray[k]);
        }
        Object[] objectArray = new SftpFile[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String[] f(String string) throws SftpStatusException, SshException {
        File[] fileArray;
        RegularExpressionMatching regularExpressionMatching;
        String string2;
        String string3;
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        if (n > -1 || (n = string.lastIndexOf(47)) > -1) {
            string3 = this.e(string.substring(0, n)).getAbsolutePath();
            string2 = n < string.length() - 1 ? string.substring(n + 1) : "";
        } else {
            string3 = this.fc;
            string2 = string;
        }
        switch (this.kc) {
            case 1: {
                File file = new File(string3);
                regularExpressionMatching = new GlobRegExpMatching();
                fileArray = this.b(file);
                break;
            }
            case 2: {
                File file = new File(string3);
                regularExpressionMatching = new Perl5RegExpMatching();
                fileArray = this.b(file);
                break;
            }
            default: {
                regularExpressionMatching = new NoRegExpMatching();
                fileArray = new File[]{new File(string)};
            }
        }
        return regularExpressionMatching.matchFileNamesWithPattern(fileArray, string2);
    }

    private File[] b(File file) {
        String string = file.getAbsolutePath();
        String[] stringArray = file.list();
        File[] fileArray = new File[stringArray.length];
        for (int k = 0; k < stringArray.length; ++k) {
            fileArray[k] = new File(string, stringArray[k]);
        }
        return fileArray;
    }

    private void c(String string, String string2, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        String string3 = this.c(string2);
        SftpFileAttributes sftpFileAttributes = null;
        try {
            sftpFileAttributes = this.stat(string3);
        }
        catch (SftpStatusException sftpStatusException) {
            throw new SftpStatusException(sftpStatusException.getStatus(), "Remote path '" + string2 + "' does not exist. It must be a valid directory and must already exist!");
        }
        if (!sftpFileAttributes.isDirectory()) {
            throw new SftpStatusException(10, "Remote path '" + string2 + "' is not a directory!");
        }
        String[] stringArray = this.f(string);
        for (int k = 0; k < stringArray.length; ++k) {
            try {
                this.put(stringArray[k], string3, fileTransferProgress, bl);
                continue;
            }
            catch (SftpStatusException sftpStatusException) {
                throw new SftpStatusException(sftpStatusException.getStatus(), "Failed to put " + stringArray[k] + " to " + string2 + " [" + sftpStatusException.getMessage() + "]");
            }
        }
    }

    public SftpFileAttributes get(String string, OutputStream outputStream, FileTransferProgress fileTransferProgress, long l) throws SftpStatusException, SshException, TransferCancelledException {
        String string2 = this.c(string);
        SftpFileAttributes sftpFileAttributes = this.ic.getAttributes(string2);
        if (l > sftpFileAttributes.getSize().longValue()) {
            throw new SftpStatusException(101, "The local file size is greater than the remote file");
        }
        if (fileTransferProgress != null) {
            fileTransferProgress.started(sftpFileAttributes.getSize().longValue(), string2);
        }
        SftpFile sftpFile = this.hc == 2 && this.ic.getVersion() > 3 ? this.ic.openFile(string2, 65) : this.ic.openFile(string2, 1);
        try {
            this.ic.performOptimizedRead(sftpFile.getHandle(), sftpFileAttributes.getSize().longValue(), this.dc, outputStream, this.jc, fileTransferProgress, l);
        }
        catch (TransferCancelledException transferCancelledException) {
            throw transferCancelledException;
        }
        finally {
            try {
                this.ic.closeFile(sftpFile);
            }
            catch (SftpStatusException sftpStatusException) {}
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
        if (fileTransferProgress != null) {
            fileTransferProgress.completed();
        }
        return sftpFileAttributes;
    }

    public InputStream getInputStream(String string, long l) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        this.ic.getAttributes(string2);
        return new SftpFileInputStream(this.ic.openFile(string2, 1), l);
    }

    public InputStream getInputStream(String string) throws SftpStatusException, SshException {
        return this.getInputStream(string, 0L);
    }

    public SftpFileAttributes get(String string, OutputStream outputStream, long l) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, outputStream, null, l);
    }

    public SftpFileAttributes get(String string, OutputStream outputStream) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(string, outputStream, null, 0L);
    }

    public boolean isClosed() {
        return this.ic.isClosed();
    }

    public void put(String string, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        File file = new File(string);
        this.put(string, file.getName(), fileTransferProgress, bl);
    }

    public void put(String string, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(string, fileTransferProgress, false);
    }

    public void put(String string) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(string, false);
    }

    public void put(String string, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(string, (FileTransferProgress)null, bl);
    }

    public void put(String string, String string2, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(string, string2, fileTransferProgress, false);
    }

    public void put(String string, String string2, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        long l;
        FileInputStream fileInputStream;
        block6: {
            File file = this.e(string);
            fileInputStream = new FileInputStream(file);
            l = 0L;
            try {
                SftpFileAttributes sftpFileAttributes = this.stat(string2);
                if (sftpFileAttributes.isDirectory()) {
                    string2 = string2 + (string2.endsWith("/") ? "" : "/") + file.getName();
                    sftpFileAttributes = this.stat(string2);
                }
                if (!bl) break block6;
                if (file.length() <= sftpFileAttributes.getSize().longValue()) {
                    throw new SftpStatusException(101, "The remote file size is greater than the local file");
                }
                try {
                    l = sftpFileAttributes.getSize().longValue();
                    ((InputStream)fileInputStream).skip(l);
                }
                catch (IOException iOException) {
                    throw new SftpStatusException(2, iOException.getMessage());
                }
            }
            catch (SftpStatusException sftpStatusException) {
                // empty catch block
            }
        }
        this.put(fileInputStream, string2, fileTransferProgress, l);
    }

    public void put(String string, String string2, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(string, string2, null, bl);
    }

    public void put(String string, String string2) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(string, string2, null, false);
    }

    public void put(InputStream inputStream, String string, FileTransferProgress fileTransferProgress) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(inputStream, string, fileTransferProgress, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(InputStream inputStream, String string, FileTransferProgress fileTransferProgress, long l) throws SftpStatusException, SshException, TransferCancelledException {
        SftpFile sftpFile;
        String string2 = this.c(string);
        SftpFileAttributes sftpFileAttributes = null;
        if (this.hc == 2) {
            int n = 0;
            int n2 = this.gc;
            byte[] byArray = null;
            if (this.ic.getVersion() <= 3 && this.ic.getExtension("newline@vandyke.com") != null) {
                byArray = this.ic.getExtension("newline@vandyke.com").getBytes();
            } else if (this.ic.getVersion() > 3) {
                byArray = this.ic.getCanonicalNewline().getBytes();
            }
            if (byArray != null) {
                switch (byArray.length) {
                    case 1: {
                        if (byArray[0] == 13) {
                            n2 = 3;
                            break;
                        }
                        if (byArray[0] == 10) {
                            n2 = 2;
                            break;
                        }
                        throw new SftpStatusException(100, "Unsupported text mode: invalid newline character");
                    }
                    case 2: {
                        if (byArray[0] == 13 && byArray[1] == 10) {
                            n2 = 1;
                            break;
                        }
                        throw new SftpStatusException(100, "Unsupported text mode: invalid newline characters");
                    }
                    default: {
                        throw new SftpStatusException(100, "Unsupported text mode: newline length > 2");
                    }
                }
            }
            try {
                inputStream = EOLProcessor.createInputStream(n, n2, inputStream);
            }
            catch (IOException iOException) {
                throw new SshException("Failed to create EOL processing stream", 5);
            }
        }
        if (l > 0L) {
            if (this.hc == 2 && this.ic.getVersion() > 3) {
                throw new SftpStatusException(8, "Resume on text mode files is not supported");
            }
            sftpFile = this.ic.openFile(string2, 6, sftpFileAttributes);
        } else {
            sftpFile = this.hc == 2 && this.ic.getVersion() > 3 ? this.ic.openFile(string2, 90, sftpFileAttributes) : this.ic.openFile(string2, 26, sftpFileAttributes);
        }
        if (fileTransferProgress != null) {
            try {
                fileTransferProgress.started(inputStream.available(), string2);
            }
            catch (IOException iOException) {
                throw new SshException("Failed to determine local file size", 5);
            }
        }
        try {
            this.ic.performOptimizedWrite(sftpFile.getHandle(), this.dc, this.jc, inputStream, this.cc, fileTransferProgress, l);
        }
        finally {
            try {
                this.ic.closeFile(sftpFile);
            }
            catch (SftpStatusException sftpStatusException) {}
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
        if (fileTransferProgress != null) {
            fileTransferProgress.completed();
        }
    }

    public OutputStream getOutputStream(String string) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        return new SftpFileOutputStream(this.ic.openFile(string2, 26));
    }

    public void put(InputStream inputStream, String string, long l) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(inputStream, string, null, l);
    }

    public void put(InputStream inputStream, String string) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(inputStream, string, null, 0L);
    }

    public void chown(String string, String string2) throws SftpStatusException, SshException {
        String string3 = this.c(string2);
        SftpFileAttributes sftpFileAttributes = this.ic.getAttributes(string3);
        sftpFileAttributes.setUID(string);
        this.ic.setAttributes(string3, sftpFileAttributes);
    }

    public void chgrp(String string, String string2) throws SftpStatusException, SshException {
        String string3 = this.c(string2);
        SftpFileAttributes sftpFileAttributes = this.ic.getAttributes(string3);
        sftpFileAttributes.setGID(string);
        this.ic.setAttributes(string3, sftpFileAttributes);
    }

    public void chmod(int n, String string) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        this.ic.changePermissions(string2, n);
    }

    public void umask(String string) throws SshException {
        try {
            this.lc = Integer.parseInt(string, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SshException("umask must be 4 digit octal number e.g. 0022", 4);
        }
    }

    public void rename(String string, String string2) throws SftpStatusException, SshException {
        String string3 = this.c(string);
        String string4 = this.c(string2);
        SftpFileAttributes sftpFileAttributes = null;
        try {
            sftpFileAttributes = this.ic.getAttributes(string4);
        }
        catch (SftpStatusException sftpStatusException) {
            this.ic.renameFile(string3, string4);
            return;
        }
        if (sftpFileAttributes == null || !sftpFileAttributes.isDirectory()) {
            throw new SftpStatusException(11, string2 + " already exists on the remote filesystem");
        }
        this.ic.renameFile(string3, string4);
    }

    public void rm(String string) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        SftpFileAttributes sftpFileAttributes = this.ic.getAttributes(string2);
        if (sftpFileAttributes.isDirectory()) {
            this.ic.removeDirectory(string2);
        } else {
            this.ic.removeFile(string2);
        }
    }

    public void rm(String string, boolean bl, boolean bl2) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        SftpFileAttributes sftpFileAttributes = null;
        sftpFileAttributes = this.ic.getAttributes(string2);
        if (sftpFileAttributes.isDirectory()) {
            SftpFile[] sftpFileArray = this.ls(string);
            if (!bl && sftpFileArray.length > 0) {
                throw new SftpStatusException(4, "You cannot delete non-empty directory, use force=true to overide");
            }
            for (int k = 0; k < sftpFileArray.length; ++k) {
                SftpFile sftpFile = sftpFileArray[k];
                if (sftpFile.isDirectory() && !sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) {
                    if (bl2) {
                        this.rm(sftpFile.getAbsolutePath(), bl, bl2);
                        continue;
                    }
                    throw new SftpStatusException(4, "Directory has contents, cannot delete without recurse=true");
                }
                if (!sftpFile.isFile()) continue;
                this.ic.removeFile(sftpFile.getAbsolutePath());
            }
            this.ic.removeDirectory(string2);
        } else {
            this.ic.removeFile(string2);
        }
    }

    public void symlink(String string, String string2) throws SftpStatusException, SshException {
        String string3 = this.c(string);
        String string4 = this.c(string2);
        this.ic.createSymbolicLink(string3, string4);
    }

    public SftpFileAttributes stat(String string) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        return this.ic.getAttributes(string2);
    }

    public String getAbsolutePath(String string) throws SftpStatusException, SshException {
        String string2 = this.c(string);
        return this.ic.getAbsolutePath(string2);
    }

    public void quit() throws SshException {
        try {
            this.ic.close();
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 6);
        }
    }

    public void exit() throws SshException {
        try {
            this.ic.close();
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 6);
        }
    }

    public DirectoryOperation copyLocalDirectory(String string, String string2, boolean bl, boolean bl2, boolean bl3, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        String[] stringArray;
        DirectoryOperation directoryOperation = new DirectoryOperation();
        File file = this.e(string);
        string2 = this.c(string2);
        string2 = string2 + (string2.endsWith("/") ? "" : "/");
        if (bl3) {
            try {
                this.ic.getAttributes(string2);
            }
            catch (SftpStatusException sftpStatusException) {
                this.mkdirs(string2);
            }
        }
        if ((stringArray = file.list()) != null) {
            for (int k = 0; k < stringArray.length; ++k) {
                SftpFileAttributes sftpFileAttributes;
                File file2 = new File(file, stringArray[k]);
                if (file2.isDirectory() && !file2.getName().equals(".") && !file2.getName().equals("..")) {
                    if (!bl) continue;
                    directoryOperation.addDirectoryOperation(this.copyLocalDirectory(file2.getAbsolutePath(), string2, bl, bl2, bl3, fileTransferProgress), file2);
                    continue;
                }
                if (!file2.isFile()) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                try {
                    sftpFileAttributes = this.ic.getAttributes(string2 + file2.getName());
                    bl5 = file2.length() == sftpFileAttributes.getSize().longValue() && file2.lastModified() / 1000L == sftpFileAttributes.getModifiedTime().longValue();
                }
                catch (SftpStatusException sftpStatusException) {
                    bl4 = true;
                }
                try {
                    if (bl3 && !bl5) {
                        this.put(file2.getAbsolutePath(), string2 + file2.getName(), fileTransferProgress);
                        sftpFileAttributes = this.ic.getAttributes(string2 + file2.getName());
                        sftpFileAttributes.setTimes(new UnsignedInteger64(file2.lastModified() / 1000L), new UnsignedInteger64(file2.lastModified() / 1000L));
                        this.ic.setAttributes(string2 + file2.getName(), sftpFileAttributes);
                    }
                    if (bl5) {
                        directoryOperation.c(file2);
                        continue;
                    }
                    if (!bl4) {
                        directoryOperation.d(file2);
                        continue;
                    }
                    directoryOperation.b(file2);
                    continue;
                }
                catch (SftpStatusException sftpStatusException) {
                    directoryOperation.b(file2, sftpStatusException);
                }
            }
        }
        if (bl2) {
            try {
                SftpFile[] sftpFileArray = this.ls(string2);
                for (int k = 0; k < sftpFileArray.length; ++k) {
                    SftpFile sftpFile = sftpFileArray[k];
                    File file3 = new File(file, sftpFile.getFilename());
                    if (directoryOperation.containsFile(file3) || sftpFile.getFilename().equals(".") || sftpFile.getFilename().equals("..")) continue;
                    directoryOperation.c(sftpFile);
                    if (!bl3) continue;
                    if (sftpFile.isDirectory()) {
                        this.b(sftpFile, directoryOperation);
                        if (!bl3) continue;
                        this.rm(sftpFile.getAbsolutePath(), true, true);
                        continue;
                    }
                    if (!sftpFile.isFile()) continue;
                    this.rm(sftpFile.getAbsolutePath());
                }
            }
            catch (SftpStatusException sftpStatusException) {
                // empty catch block
            }
        }
        return directoryOperation;
    }

    private void b(SftpFile sftpFile, DirectoryOperation directoryOperation) throws SftpStatusException, SshException {
        SftpFile[] sftpFileArray = this.ls(sftpFile.getAbsolutePath());
        directoryOperation.c(sftpFile);
        for (int k = 0; k < sftpFileArray.length; ++k) {
            sftpFile = sftpFileArray[k];
            if (sftpFile.isDirectory() && !sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) {
                this.b(sftpFile, directoryOperation);
                continue;
            }
            if (!sftpFile.isFile()) continue;
            directoryOperation.c(sftpFile);
        }
    }

    private void b(File file, DirectoryOperation directoryOperation) throws SftpStatusException, SshException {
        String[] stringArray = file.list();
        directoryOperation.e(file);
        if (stringArray != null) {
            for (int k = 0; k < stringArray.length; ++k) {
                file = new File(stringArray[k]);
                if (file.isDirectory() && !file.getName().equals(".") && !file.getName().equals("..")) {
                    this.b(file, directoryOperation);
                    continue;
                }
                if (!file.isFile()) continue;
                directoryOperation.e(file);
            }
        }
    }

    public static String formatLongname(SftpFile sftpFile) throws SftpStatusException, SshException {
        return SftpClient.formatLongname(sftpFile.getAttributes(), sftpFile.getFilename());
    }

    public static String formatLongname(SftpFileAttributes sftpFileAttributes, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SftpClient.b(10 - sftpFileAttributes.getPermissionsString().length()) + sftpFileAttributes.getPermissionsString());
        stringBuffer.append("    1 ");
        stringBuffer.append(sftpFileAttributes.getUID() + SftpClient.b(8 - sftpFileAttributes.getUID().length()));
        stringBuffer.append(" ");
        stringBuffer.append(sftpFileAttributes.getGID() + SftpClient.b(8 - sftpFileAttributes.getGID().length()));
        stringBuffer.append(" ");
        stringBuffer.append(SftpClient.b(8 - sftpFileAttributes.getSize().toString().length()) + sftpFileAttributes.getSize().toString());
        stringBuffer.append(" ");
        stringBuffer.append(SftpClient.b(12 - SftpClient.b(sftpFileAttributes.getModifiedTime()).length()) + SftpClient.b(sftpFileAttributes.getModifiedTime()));
        stringBuffer.append(" ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String b(UnsignedInteger64 unsignedInteger64) {
        if (unsignedInteger64 == null) {
            return "";
        }
        long l = unsignedInteger64.longValue() * 1000L;
        long l2 = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = l2 - l > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return simpleDateFormat.format(new Date(l));
    }

    private static String b(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (n > 0) {
            for (int k = 0; k < n; ++k) {
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    public DirectoryOperation copyRemoteDirectory(String string, String string2, boolean bl, boolean bl2, boolean bl3, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        String[] stringArray;
        File file;
        int n;
        DirectoryOperation directoryOperation = new DirectoryOperation();
        String string3 = this.pwd();
        this.cd(string);
        String string4 = string;
        if (string4.endsWith("/")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if ((n = string4.lastIndexOf(47)) != -1) {
            string4 = string4.substring(n + 1);
        }
        if (!(file = new File(string2, string4)).isAbsolute()) {
            file = new File(this.lpwd(), string2);
        }
        if (!file.exists() && bl3) {
            file.mkdir();
        }
        SftpFile[] sftpFileArray = this.ls();
        for (int k = 0; k < sftpFileArray.length; ++k) {
            File file2;
            SftpFile sftpFile = sftpFileArray[k];
            if (sftpFile.isDirectory() && !sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) {
                if (!bl) continue;
                file2 = new File(file, sftpFile.getFilename());
                directoryOperation.addDirectoryOperation(this.copyRemoteDirectory(sftpFile.getFilename(), file.getAbsolutePath(), bl, bl2, bl3, fileTransferProgress), file2);
                continue;
            }
            if (!sftpFile.isFile()) continue;
            file2 = new File(file, sftpFile.getFilename());
            if (file2.exists() && file2.length() == sftpFile.getAttributes().getSize().longValue() && file2.lastModified() / 1000L == sftpFile.getAttributes().getModifiedTime().longValue()) {
                if (bl3) {
                    directoryOperation.c(file2);
                    continue;
                }
                directoryOperation.d(sftpFile);
                continue;
            }
            try {
                if (file2.exists()) {
                    if (bl3) {
                        directoryOperation.d(file2);
                    } else {
                        directoryOperation.e(sftpFile);
                    }
                } else if (bl3) {
                    directoryOperation.b(file2);
                } else {
                    directoryOperation.b(sftpFile);
                }
                if (!bl3) continue;
                this.get(sftpFile.getFilename(), file2.getAbsolutePath(), fileTransferProgress);
                continue;
            }
            catch (SftpStatusException sftpStatusException) {
                directoryOperation.b(file2, sftpStatusException);
            }
        }
        if (bl2 && (stringArray = file.list()) != null) {
            for (int k = 0; k < stringArray.length; ++k) {
                File file3 = new File(file, stringArray[k]);
                if (directoryOperation.containsFile(file3)) continue;
                directoryOperation.e(file3);
                if (file3.isDirectory() && !file3.getName().equals(".") && !file3.getName().equals("..")) {
                    this.b(file3, directoryOperation);
                    if (!bl3) continue;
                    IOUtil.recurseDeleteDirectory(file3);
                    continue;
                }
                if (!bl3) continue;
                file3.delete();
            }
        }
        this.cd(string3);
        return directoryOperation;
    }

    public SftpFile[] getFiles(String string) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(string, (FileTransferProgress)null);
    }

    public SftpFile[] getFiles(String string, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(string, (FileTransferProgress)null, bl);
    }

    public SftpFile[] getFiles(String string, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(string, fileTransferProgress, false);
    }

    public SftpFile[] getFiles(String string, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(string, this.fc, fileTransferProgress, bl);
    }

    public SftpFile[] getFiles(String string, String string2) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(string, string2, false);
    }

    public SftpFile[] getFiles(String string, String string2, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(string, string2, null, bl);
    }

    public SftpFile[] getFiles(String string, String string2, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.b(string, string2, fileTransferProgress, bl);
    }

    public void putFiles(String string) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(string, false);
    }

    public void putFiles(String string, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(string, (FileTransferProgress)null, bl);
    }

    public void putFiles(String string, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(string, fileTransferProgress, false);
    }

    public void putFiles(String string, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(string, this.pwd(), fileTransferProgress, bl);
    }

    public void putFiles(String string, String string2) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(string, string2, null, false);
    }

    public void putFiles(String string, String string2, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(string, string2, null, bl);
    }

    public void putFiles(String string, String string2, FileTransferProgress fileTransferProgress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(string, string2, fileTransferProgress, false);
    }

    public void putFiles(String string, String string2, FileTransferProgress fileTransferProgress, boolean bl) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.c(string, string2, fileTransferProgress, bl);
    }

    static class _b
    extends OutputStream {
        RandomAccessFile b;

        _b(RandomAccessFile randomAccessFile) {
            this.b = randomAccessFile;
        }

        public void write(int n) throws IOException {
            this.b.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.b.write(byArray, n, n2);
        }

        public void close() throws IOException {
            this.b.close();
        }
    }
}

