/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.ipac_mfghost_mi;
import se.ericsson.cello.iptransport.mom.EnumNtpServerMode;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumAdmState;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public abstract class IpAccessHostEtMoGen
extends CelloMao
implements IpAccessHostEtMo {
    protected String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"administrativeState", "availabilityStatus", "ipAddress", "ipDefaultTtl", "ipInterfaceMoRef", "operationalState", "currentPmRegister", "ntpServerMode", "ntpDscp", "networkPrefixLength", "piuFroId", "secondaryLocation", "confMode", "ipVersion"};
    protected String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"IpAccessHostEtId", "administrativeState", "ipAddress", "ipDefaultTtl", "ipInterfaceMoRef", "userLabel", "ntpServerMode", "ntpDscp", "networkPrefixLength"};
    protected FroProxy froProxy = null;
    protected MoData data;
    protected static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipac_mfghost_mi());
    protected MaoFroIndicationHandler indHandler;
    Map myPmProxyFroIdMap = new HashMap(3);
    protected static final String FROID = "ipacHostEtFroId";
    protected static final int MO_DATA_REVISION_LATEST = 6100;

    private void checkMandatoryAttrs(AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        this.checkMandatoryRefAttribute("ipInterfaceMoRef", attrList);
    }

    private void checkMandatoryAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0 || attrList.getValue(n) == null) {
            throw new AttrMissingAtCreateException(string, "IpAccessHostEt");
        }
    }

    private void checkMandatoryRefAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0) {
            throw new AttrMissingAtCreateException(string, "IpAccessHostEt");
        }
    }

    protected IpAccessHostEtMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, InitialMaoContext initialMaoContext, AttrList attrList, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "IpAccessHostEt", string, coordinator, initialMaoContext);
        this.froProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        this.checkMandatoryAttrs(attrList);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("IpAccessHostEt");
        setRequestContextImpl.assertAllowedAttributes(this.NON_READONLY_MOM_ATTRIBUTES, "IpAccessHostEt");
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), "IpAccessHostEt", true, coordinator);
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true));
        this.data.setRevision(6100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"administrativeState", (AttrList)attrList, (Class)Integer.class, (String)"IpAccessHostEt");
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        this.validateAdministrativeState(n2, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("administrativeState", n2));
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"ipAddress", (AttrList)attrList, (Class)String.class, (String)"IpAccessHostEt");
        if (string2 == null) {
            string2 = "";
        }
        this.validateIpAddress(string2, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("ipAddress", string2));
        Integer n3 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"ipDefaultTtl", (AttrList)attrList, (Class)Integer.class, (String)"IpAccessHostEt");
        int n4 = 64;
        if (n3 != null) {
            n4 = n3;
        }
        this.validateIpDefaultTtl(n4, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipDefaultTtl", n4));
        ManagedObject managedObject2 = (ManagedObject)MoGenUtil.checkAndGetAttributeType((String)"ipInterfaceMoRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"IpAccessHostEt");
        this.validateIpInterfaceMoRef(managedObject2, (SetRequestContext)setRequestContextImpl);
        int n5 = 0;
        if (managedObject2 != null && managedObject2 instanceof FroInfo) {
            n5 = ((FroInfo)managedObject2).getFroId(coordinator);
        }
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipInterfaceMoRef", n5));
        String string3 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"IpAccessHostEt");
        if (string3 == null) {
            string3 = "";
        }
        this.validateUserLabel(string3, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string3);
        Integer n6 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"ntpServerMode", (AttrList)attrList, (Class)Integer.class, (String)"IpAccessHostEt");
        int n7 = 0;
        if (n6 != null) {
            n7 = n6;
        }
        this.validateNtpServerMode(n7, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ntpServerMode", n7));
        Integer n8 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"ntpDscp", (AttrList)attrList, (Class)Integer.class, (String)"IpAccessHostEt");
        int n9 = 46;
        if (n8 != null) {
            n9 = n8;
        }
        this.validateNtpDscp(n9, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ntpDscp", n9));
        Integer n10 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"networkPrefixLength", (AttrList)attrList, (Class)Integer.class, (String)"IpAccessHostEt");
        int n11 = 64;
        if (n10 != null) {
            n11 = n10;
        }
        this.validateNetworkPrefixLength(n11, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("networkPrefixLength", n11));
        this.onCreate((SetRequestContext)setRequestContextImpl);
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        FroData froData = setRequestContextImpl.sendCreateRequest(this.froProxy);
        int n12 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n12));
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n12);
    }

    public IpAccessHostEtMoGen(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6100);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(null));
    }

    protected abstract Object handleGetCurrentPmRegister(GetRequestContext var1) throws MoAccessException;

    protected abstract void handleSetCurrentPmRegister(String[] var1, SetRequestContext var2) throws MoAccessException;

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onGetAttributes(GetRequestContext getRequestContext) throws MoAccessException {
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        return object;
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
    }

    protected void updateParamChangedInd(Map map, String string, SetRequestContext setRequestContext) throws MoAccessException {
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.onDelete(coordinator);
        ManagedObject managedObject = null;
        managedObject = this.getIpInterfaceMoRef(coordinator);
        if (managedObject != null && managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length > 0) {
            throw new MoReservedNotDeletableException("IpAccessHostEt");
        }
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public void setIpAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAddress", string, coordinator);
    }

    public String getIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ipAddress", coordinator);
    }

    public void setIpDefaultTtl(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipDefaultTtl", new Integer(n), coordinator);
    }

    public int getIpDefaultTtl(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ipDefaultTtl", coordinator);
    }

    public ManagedObject getIpInterfaceMoRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipInterfaceMoRef", coordinator);
    }

    public abstract ManagedObject fetchIpInterfaceMoRef(SignedIntParameter var1, Coordinator var2) throws MoAccessException;

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public int getPmIpInAddrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInAddrErrors", coordinator);
    }

    public int getPmIpInDelivers(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInDelivers", coordinator);
    }

    public int getPmIpInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInDiscards", coordinator);
    }

    public int getPmIpInHdrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInHdrErrors", coordinator);
    }

    public int getPmIpInReceives(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInReceives", coordinator);
    }

    public int getPmIpInUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInUnknownProtos", coordinator);
    }

    public int getPmIpOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpOutDiscards", coordinator);
    }

    public int getPmIpOutRequests(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpOutRequests", coordinator);
    }

    public int getPmIcmpInDestUnreachs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInDestUnreachs", coordinator);
    }

    public int getPmIcmpInEchoReps(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInEchoReps", coordinator);
    }

    public int getPmIcmpInEchos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInEchos", coordinator);
    }

    public int getPmIcmpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInErrors", coordinator);
    }

    public int getPmIcmpInMsgs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInMsgs", coordinator);
    }

    public int getPmIcmpInParamProbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInParamProbs", coordinator);
    }

    public int getPmIcmpInRedirects(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInRedirects", coordinator);
    }

    public int getPmIcmpInSrcQuenchs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInSrcQuenchs", coordinator);
    }

    public int getPmIcmpInTimeExcds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInTimeExcds", coordinator);
    }

    public int getPmIcmpOutDestUnreachs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutDestUnreachs", coordinator);
    }

    public int getPmIcmpOutEchoReps(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutEchoReps", coordinator);
    }

    public int getPmIcmpOutEchos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutEchos", coordinator);
    }

    public int getPmIcmpOutErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutErrors", coordinator);
    }

    public int getPmIcmpOutMsgs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutMsgs", coordinator);
    }

    public int getPmIcmpOutParamProbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutParamProbs", coordinator);
    }

    public int getPmUdpInDatagrams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpInDatagrams", coordinator);
    }

    public int getPmUdpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpInErrors", coordinator);
    }

    public int getPmUdpNoPorts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpNoPorts", coordinator);
    }

    public int getPmUdpOutDatagrams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpOutDatagrams", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public void setNtpServerMode(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ntpServerMode", new Integer(n), coordinator);
    }

    public int getNtpServerMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ntpServerMode", coordinator);
    }

    public int getPmIpPortUnreachable(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpPortUnreachable", coordinator);
    }

    public void setNtpDscp(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ntpDscp", new Integer(n), coordinator);
    }

    public int getNtpDscp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ntpDscp", coordinator);
    }

    public int getPmIpFragCreates(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragCreates", coordinator);
    }

    public int getPmIpFragFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragFails", coordinator);
    }

    public int getPmIpFragOks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragOks", coordinator);
    }

    public int getPmIpReasmFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmFails", coordinator);
    }

    public int getPmIpReasmOks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmOks", coordinator);
    }

    public int getPmIpReasmReqds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmReqds", coordinator);
    }

    public int getPmMeanAtmConnSetupIntensity(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmMeanAtmConnSetupIntensity", coordinator);
    }

    public int getPmPeakAtmConnSetupIntensity(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmPeakAtmConnSetupIntensity", coordinator);
    }

    public int getPmStdDevAtmSetupIntensity(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmStdDevAtmSetupIntensity", coordinator);
    }

    public int getNetworkPrefixLength(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("networkPrefixLength", coordinator);
    }

    public int getPmInAppLayerError(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInAppLayerError", coordinator);
    }

    public String getType() {
        return "IpAccessHostEt";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, this.getFroId(coordinator), this.ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
            } else if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("administrativeState");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: administrativeState", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("availabilityStatus");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: availabilityStatus", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("ipAddress")) {
                signedIntParameter = (StringParameter)getRequestContextImpl.getParameter("ipAddress");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: ipAddress", "getAttributes", -1);
                }
                objectArray[i] = signedIntParameter.getValue();
            } else if (stringArray[i].equalsIgnoreCase("ipDefaultTtl")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("ipDefaultTtl");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: ipDefaultTtl", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("ipInterfaceMoRef")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("ipInterfaceMoRef");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: ipInterfaceMoRef", "getAttributes", -1);
                }
                objectArray[i] = this.fetchIpInterfaceMoRef(signedIntParameter, coordinator);
            } else if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("operationalState");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: operationalState", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                signedIntParameter = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)signedIntParameter, (Coordinator)coordinator);
            } else if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("pmIpInAddrErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInAddrErrors", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpInDelivers")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInDelivers", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpInDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInDiscards", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpInHdrErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInHdrErrors", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpInReceives")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInReceives", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpInUnknownProtos")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInUnknownProtos", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpOutDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpOutDiscards", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpOutRequests")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpOutRequests", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInDestUnreachs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInDestUnreachs", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInEchoReps")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInEchoReps", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInEchos")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInEchos", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInErrors", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInMsgs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInMsgs", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInParamProbs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInParamProbs", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInRedirects")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInRedirects", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInSrcQuenchs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInSrcQuenchs", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpInTimeExcds")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInTimeExcds", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpOutDestUnreachs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutDestUnreachs", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpOutEchoReps")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutEchoReps", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpOutEchos")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutEchos", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpOutErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutErrors", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpOutMsgs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutMsgs", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIcmpOutParamProbs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutParamProbs", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmUdpInDatagrams")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUdpInDatagrams", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmUdpInErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUdpInErrors", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmUdpNoPorts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUdpNoPorts", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmUdpOutDatagrams")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUdpOutDatagrams", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = this.handleGetCurrentPmRegister((GetRequestContext)getRequestContextImpl);
            } else if (stringArray[i].equalsIgnoreCase("ntpServerMode")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("ntpServerMode");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: ntpServerMode", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("pmIpPortUnreachable")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpPortUnreachable", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("ntpDscp")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("ntpDscp");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: ntpDscp", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("pmIpFragCreates")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpFragCreates", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpFragFails")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpFragFails", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpFragOks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpFragOks", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpReasmFails")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpReasmFails", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpReasmOks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpReasmOks", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmIpReasmReqds")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpReasmReqds", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmMeanAtmConnSetupIntensity")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmMeanAtmConnSetupIntensity", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmPeakAtmConnSetupIntensity")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmPeakAtmConnSetupIntensity", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmStdDevAtmSetupIntensity")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmStdDevAtmSetupIntensity", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("networkPrefixLength")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("networkPrefixLength");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: networkPrefixLength", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else {
                objectArray[i] = stringArray[i].equalsIgnoreCase("pmInAppLayerError") ? pmRequestContextImpl.getPmAttribute("pmInAppLayerError", INTEGER_PM_TYPE) : super.getAttribute(stringArray[i], coordinator);
            }
            objectArray[i] = this.onGetAttributes((GetRequestContext)getRequestContextImpl, stringArray[i], objectArray[i]);
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("IpAccessHostEt");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("administrativeState")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateAdministrativeState(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("administrativeState", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("administrativeState", "IpAccessHostEt");
            }
            if (string.equalsIgnoreCase("ipAddress")) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.validateIpAddress(string2, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("ipAddress", string2));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ipAddress", "IpAccessHostEt");
            }
            if (string.equalsIgnoreCase("ipDefaultTtl")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateIpDefaultTtl(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipDefaultTtl", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ipDefaultTtl", "IpAccessHostEt");
            }
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    String string3 = (String)object;
                    this.validateUserLabel(string3, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string3);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "IpAccessHostEt");
            }
            if (string.equalsIgnoreCase("ntpServerMode")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateNtpServerMode(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ntpServerMode", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ntpServerMode", "IpAccessHostEt");
            }
            if (string.equalsIgnoreCase("ntpDscp")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateNtpDscp(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ntpDscp", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ntpDscp", "IpAccessHostEt");
            }
            throw new NoSuchAttributeException(string, "IpAccessHostEt");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    public String actionPing(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        arrayList.add(new StringParameter("ping_host", string));
        Map map = this.froProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 2001, arrayList);
        StringParameter stringParameter = (StringParameter)map.get("actionPing");
        String string2 = "";
        if (stringParameter == null) {
            throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: actionPing", "actionPing", -1);
        }
        string2 = stringParameter.getValue();
        return string2;
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Iterator iterator = map.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                SignedIntParameter signedIntParameter;
                string = (String)iterator.next();
                if (string.equals("administrativeState")) {
                    signedIntParameter = (SignedIntParameter)map.get("administrativeState");
                    setRequestContextImpl.addAvcNotification("administrativeState", (Object)new Integer(signedIntParameter.getValue()));
                } else if (string.equals("ipAddress")) {
                    signedIntParameter = (StringParameter)map.get("ipAddress");
                    setRequestContextImpl.addAvcNotification("ipAddress", (Object)signedIntParameter.getValue());
                } else {
                    MessageLog.traceError(this.getClass(), (String)("Unknown attribute in parameterChanged(): " + string));
                }
                this.updateParamChangedInd(map, string, (SetRequestContext)setRequestContextImpl);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)("Attribute tag not found. " + moAccessException.toString()));
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void validateAdministrativeState(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkEnumAttribute((String)"administrativeState", (int)n, (int[])EnumAdmState.VALUES_ARRAY, (String)"IpAccessHostEt");
    }

    protected void validateIpAddress(String string, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateIpDefaultTtl(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"ipDefaultTtl", (int)n, (int)1, (int)255, (String)"IpAccessHostEt");
    }

    protected void validateIpInterfaceMoRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObject == null) {
            throw new ValueOutOfRangeException("ipInterfaceMoRef", "IpAccessHostEt");
        }
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"IpAccessHostEt");
    }

    protected void validateNtpServerMode(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkEnumAttribute((String)"ntpServerMode", (int)n, (int[])EnumNtpServerMode.VALUES_ARRAY, (String)"IpAccessHostEt");
    }

    protected void validateNtpDscp(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"ntpDscp", (int)n, (int)0, (int)63, (String)"IpAccessHostEt");
    }

    protected void validateNetworkPrefixLength(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"networkPrefixLength", (int)n, (int)1, (int)128, (String)"IpAccessHostEt");
    }
}

