/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.StringTokenizer;
import se.ericsson.cello.iptransport.FastEthernetMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpAccessHostGpbMo;
import se.ericsson.cello.iptransport.IpAccessHostSpbMo;
import se.ericsson.cello.iptransport.IpInterface;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.HostIpAddress;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.NetworkAddress;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCardinalityViolationException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class IpValidator {
    public static void validateAddressTowardsInterface(String string, ManagedObject managedObject, String string2, Coordinator coordinator) throws MoAccessException {
        NetworkAddress networkAddress = null;
        if (managedObject instanceof IpInterface) {
            networkAddress = ((IpInterface)managedObject).getNetworkAddress(coordinator);
            int n = networkAddress.getNetworkPrefix();
            HostIpAddress hostIpAddress = new HostIpAddress(string, n);
            IpAddress ipAddress = new IpAddress(networkAddress.getSubnet());
            hostIpAddress.validateIpAddrWithinSubnet(n, ipAddress, string2);
        } else if (!(managedObject instanceof VpnInterfaceBuildIF)) {
            throw new WrongAttributeTypeException("validateAddressTowardsInterface failed, MAO instance of wrong type", string2);
        }
    }

    public static void checkCombinedHostCardinality(ManagedObject managedObject, String string) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        int n = 0;
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!(managedObject2 instanceof IpAccessHostSpbMo) && !(managedObject2 instanceof IpAccessHostGpbMo) && !(managedObject2 instanceof IpAccessHostEtMo)) continue;
            ++n;
        }
        if (n >= 2500) {
            throw new MoCardinalityViolationException(string);
        }
    }

    public static void checkIpaddressFormat(String string) throws IpFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n3;
        }
        if (n3 != 3) {
            throw new IpFormatException("Not a valid IP address");
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IpFormatException("Not a valid IP address");
            }
            if (n < 0 || n > 255) {
                throw new IpFormatException("Not a valid IP address");
            }
            ++n2;
        }
        if (n2 != 4) {
            throw new IpFormatException("Not a valid IP address");
        }
    }

    public static void checkInterfacesNotSameInstance(ManagedObject managedObject, ManagedObject managedObject2) throws MoAccessException {
        if (managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
            throw new ValueOutOfRangeException("Attributes interface1 and interface2 must not be the same MO instance", "IpAccessHostSpb");
        }
        if (managedObject.getType().equals("IpInterface") && managedObject2.getType().equals("IpInterface") && managedObject.getParent().getParent().getLocalDistinguishedName().equals(managedObject2.getParent().getParent().getLocalDistinguishedName())) {
            throw new ValueOutOfRangeException("Attributes interface1 and interface2 must not be on same ET-IP boards", "IpAccessHostGpb");
        }
    }

    public static void checkInterfacesNotSameInstance(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
            throw new ValueOutOfRangeException("Attributes interface1 and interface2 must not be the same MO instance", "IpAccessHostGpb");
        }
        if (managedObject instanceof FastEthernetMo) {
            if (!(managedObject2 instanceof FastEthernetMo)) {
                throw new ValueOutOfRangeException("If interface1 refers to Fastethernet MO interface2 should also refer to same Mo type.", "IpAccessHostGpb");
            }
        } else if (managedObject2 instanceof FastEthernetMo && !(managedObject instanceof FastEthernetMo)) {
            throw new ValueOutOfRangeException("If interface2 refers to Fastethernet MO interface1 should also refer to same Mo type.", "IpAccessHostGpb");
        }
    }

    public static void checkForZeroIpAddress(String string) throws MoAccessException {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreElements()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (n != 0) continue;
            ++n2;
        }
        if (n2 == 4) {
            throw new OperationNotAllowedException("ntpServerIpAddress must be a valid IP address. 0.0.0.0 is not allowed", "IpSyncRef");
        }
    }

    static void checkIfIpv4AddrIsUniqueAmongIpInt(String string, ManagedObject managedObject, Coordinator coordinator, String string2) throws MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("IpInterface");
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            String string3;
            managedObject2 = moIterator.nextMo();
            String string4 = ((IpInterfaceMo)managedObject2).getOwnIpAddressPassive(coordinator);
            if (string4.equals(string) && !Ipv4AddressValidation.isDefault((String)string4)) {
                throw new OperationNotAllowedException("OwnIpAddressPassive cannot be shared.", string2);
            }
            if (managedObject2.equals(managedObject) || !(string3 = ((IpInterfaceMo)managedObject2).getOwnIpAddressActive(coordinator)).equals(string) || Ipv4AddressValidation.isDefault((String)string3)) continue;
            throw new OperationNotAllowedException("OwnIpAddressActive cannot be shared.", string2);
        }
    }

    public static boolean isIpv6AddressUnique(String string, String string2) throws IpFormatException {
        return Ipv6AddressValidation.getIpv6Addres((String)string).equals(Ipv6AddressValidation.getIpv6Addres((String)string2));
    }

    static void validateAgainstDefaultRouter(String string, int n, ManagedObject managedObject, String string2, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (!managedObject2.getType().equals("DefaultRouter")) continue;
                String string3 = (String)managedObject2.getAttribute("nextHopIpAddr", coordinator);
                if (IpValidator.isIpv6AddressUnique(string3, string)) {
                    throw new AttrValueNotUniqueException(" IpAddress must be unique among other Mos tied to the same Ipv6Interface", string2);
                }
                if (!Ipv6AddressValidation.isGlobalUnicastIpv6((String)string3) || Ipv6AddressValidation.compareNetPrefix((String)string, (String)string3, (int)n)) continue;
                throw new IllegalAttributeValueException("The network prefix of  Ipv6Address of " + string2 + " MO" + " and DefaultRouter MO(s)" + "nextHopIpAddr" + " for the same Ipv6Interface MO must be the same ", string2);
            }
        }
    }

    static boolean validateAgainstPathSupervision(String string, int n, ManagedObject managedObject, String string2, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        MoIterator moIterator = MoRepository.instance().lookupType("PathSupervision");
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            String string3 = (String)managedObject2.getAttribute("ownIpAddress", coordinator);
            if (Ipv6AddressValidation.isUnspecifiedIpv6((String)string3)) {
                return bl;
            }
            if (!managedObject2.getParent().equals(managedObject)) {
                if (!IpValidator.isIpv6AddressUnique(string3, string)) continue;
                throw new AttrValueNotUniqueException(" IpAddress cannot be same as that of ownIpAddress of PathSupervision MO", string2);
            }
            bl = true;
            int n2 = (Integer)managedObject2.getAttribute("networkPrefixLength", coordinator);
            int n3 = (Integer)managedObject2.getAttribute("linkSide", coordinator);
            String string4 = Ipv6AddressValidation.getNetworkPrefix((String)string, (int)n);
            String string5 = Ipv6AddressValidation.getNetworkPrefix((String)string3, (int)n2);
            if (n != n2 || !string4.equalsIgnoreCase(string5)) {
                throw new IllegalAttributeValueException("The network prefix of " + string2 + " MO ipaddress and PathSupervison MO " + "ownIpAddress" + " for the same Ipv6Interface MO must be the same ", string2);
            }
            if (n3 != 1 || !IpValidator.isIpv6AddressUnique(string3, string)) continue;
            throw new AttrValueNotUniqueException(" IpAddress can only be shared with PathSupervision MO ownIpAddress for the active link, PathSupervision MO linkSide=ACTIVE ", string2);
        }
        return bl;
    }
}

