/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emas.sm.applications.SlotSelectController;
import se.ericsson.cello.emas.sm.applications.SlotSelectView;
import se.ericsson.cello.emas.sm.services.SlotNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class EditSlotsActionController
extends AbstractApplicationController
implements ActionListener {
    SlotSelectController controller = null;
    private Vector fans = new Vector();
    private static final int TIME_OUT_PERIOD = 600;

    protected void init() {
        String slotName = null;
        TreeMap<String, MOProxy> selectedSlots = new TreeMap<String, MOProxy>();
        MOProxy swa = new MOProxy((String)this.getParameter("LDNLIST"));
        TreeMap selectedRepertoires = new TreeMap();
        try {
            MOProxy[] slotList = (MOProxy[])swa.getAttribute("slotList", null);
            MOProxy[] slots = null;
            Vector<MOProxy> slotVector = new Vector<MOProxy>(0, 1);
            for (int i = 0; i < slotList.length; ++i) {
                if (slotList[i].getType().equals("Fan")) {
                    this.fans.add(slotList[i]);
                    continue;
                }
                slotVector.add(slotList[i]);
            }
            if (slotVector.size() != 0) {
                slots = slotVector.toArray(new MOProxy[0]);
                for (int count = 0; count < slots.length; ++count) {
                    slotName = SlotNameFactory.getSlotName(slots[count]);
                    selectedSlots.put(slotName, slots[count]);
                }
            }
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_EDIT_SLOTS", null);
            this.stopApp();
            return;
        }
        Object[][] params = new Object[][]{{"LDNLIST", this.getParameter("LDNLIST")}, {"SLOT_LIST", selectedSlots}, {"SWALLOCAATION_SLOTS", "SwAllocationSlots"}};
        this.controller = (SlotSelectController)this.startDialog(false, "EDIT_SLOTS_TITLE", null, SlotSelectView.class, SlotSelectController.class, params);
        this.controller.addActionListener(this);
        this.controller.setDialogMessage("CONFIRM_EDIT_SLOTS_SOFTWARE_ALLOCATION");
    }

    public void setSelectedSlots(TreeMap selectedSlots) {
        NameValue[] nameValues = new NameValue[1];
        Object slotName = null;
        String ldn = (String)this.getParameter("LDNLIST");
        MOProxy swAllocationMo = new MOProxy(ldn);
        Transaction transaction = null;
        try {
            transaction = new Transaction(600);
            swAllocationMo.action("deleteAllSlots", new NameValue[0], transaction.session);
            Vector slots = new Vector(selectedSlots.values());
            Enumeration enume = this.fans.elements();
            while (enume.hasMoreElements()) {
                slots.addElement(enume.nextElement());
            }
            nameValues[0] = new NameValue("param", (Object)slots.toArray(new MOProxy[0]));
            swAllocationMo.action("addSlots", nameValues, transaction.session);
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException cs) {
                Log.logError((String)"Rollback of the transaction failed", (Throwable)cs);
            }
            this.reportException((Exception)((Object)e), "ERROR_EDIT_SLOTS", null);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if ("OK".equals(event.getActionCommand())) {
            this.setSelectedSlots(this.controller.getSelectedSlots());
            if (this.controller.canDismiss()) {
                this.controller.stopDialog();
                this.getApplication().stopApplicationNoCheck();
            }
        } else if ("APPLY".equals(event.getActionCommand())) {
            this.setSelectedSlots(this.controller.getSelectedSlots());
        } else if ("CANCEL".equals(event.getActionCommand())) {
            this.getApplication().stopApplicationNoCheck();
        } else if ("ERROR".equals(event.getActionCommand())) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    private void stopApp() {
        final AbstractApplication application = this.getApplication();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                application.stopApplicationNoCheck();
            }
        });
    }
}

