/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import se.ericsson.cello.emas.sm.applications.DetailedInformation;
import se.ericsson.cello.emas.sm.applications.RestoreSlide3VerificationResultsWizardView;
import se.ericsson.cello.emas.sm.applications.RestoreSlide4RestoreWizardController;
import se.ericsson.cello.emas.sm.applications.RestoreSlide4RestoreWizardView;
import se.ericsson.cello.emas.sm.applications.RestoreSlidesController;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.ErrorDialog;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.RestoreConfirm;
import se.ericsson.cello.support.mgr.UsernamePasswordDialogController;
import se.ericsson.cello.support.mgr.UsernamePasswordDialogView;
import se.ericsson.cello.support.mgr.cellomom.CVActionMainResult;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.Struct;

public class RestoreSlide3VerificationResultsWizardController
extends RestoreSlidesController {
    private RestoreSlide3VerificationResultsWizardView view;
    private DialogListener dialogListener = new DialogListener();
    private UsernamePasswordDialogController usernamePasswordDialogController = null;
    private MyHyperlinkListener hyperlinkListenerForPathToDetailedInfo = new MyHyperlinkListener();
    private MyHyperlinkListener hyperlinkListenerForCorruptedUpgradePackagesTabb = new MyHyperlinkListener();
    private boolean hyperlinkForCorruptedUpgradePackage_showVisible = false;
    private boolean showAsModal = true;

    protected void init() {
        this.view = (RestoreSlide3VerificationResultsWizardView)this.getView();
        this.view.setInfoJTextArea(this.getString("RESTORE_INFO_TEXT_WIZARD_SLIDE3", null));
    }

    protected boolean next() {
        this.removeListeners();
        return true;
    }

    protected boolean previous() {
        this.removeListeners();
        return true;
    }

    protected Class getNextViewClass() {
        return RestoreSlide4RestoreWizardView.class;
    }

    protected Class getNextControllerClass() {
        return RestoreSlide4RestoreWizardController.class;
    }

    protected void beforeVisible() {
        this.setWizardTitle("CV_RESTORE_WIZARD_SLIDE_3", new Object[]{downloadedCv});
        this.setCancelVisible(false);
        this.setCloseVisible(true);
        if (restore_forcedRestore_failed) {
            this.requestFocusCloseButton();
            this.setCloseAsDefaultButton();
            this.setPreviousVisible(false);
        } else {
            this.requestFocusNextButton();
            this.setNextAsDefaultButton();
        }
        try {
            this.actionResult = (Struct)configurationVersionMo.getAttribute("actionResult");
            this.mainResult = (Integer)this.actionResult.getElementValue("mainResult");
        }
        catch (Exception e) {
            Log.logError((String)"Error getting attribute", (Throwable)e);
            this.reportException(e, "ERROR_GET", null);
        }
        String resultMessage = "No message";
        CVActionMainResult cvActionMainResult = CVActionMainResult.get((Object)this.mainResult);
        if (cvActionMainResult == CVActionMainResult.EXECUTED) {
            resultMessage = this.getString("VERIFICATION_MAIN_RESULT_EXECUTED", null);
            this.view.setMainResultBackgroundColor(Color.green);
        } else if (cvActionMainResult == CVActionMainResult.EXECUTED_WITH_WARNINGS) {
            resultMessage = this.getString("VERIFICATION_MAIN_RESULT_EXECUTEDWITHWARNINGS", null);
            this.view.setMainResultBackgroundColor(Color.yellow);
        } else if (cvActionMainResult == CVActionMainResult.EXECUTION_FAILED) {
            resultMessage = this.getString("VERIFICATION_MAIN_RESULT_EXECUTIONFAILED", null);
            this.view.setMainResultBackgroundColor(Color.pink);
        }
        this.view.setMainResultText("actionResult.mainResult = " + resultMessage);
        this.view.hyperlinkForCorruptedUpgradePackagesSetVisible(this.hyperlinkForCorruptedUpgradePackage_showVisible);
        this.view.showVerificationResults();
        this.view.addHyperlinkListenerForPathToDetailedInfo(this.hyperlinkListenerForPathToDetailedInfo);
        if (this.hyperlinkForCorruptedUpgradePackage_showVisible) {
            this.view.addHyperlinkListenerForCorruptedUpgradePackagesTabb(this.hyperlinkListenerForCorruptedUpgradePackagesTabb);
        }
    }

    private void askForUsernameAndPassword() {
        this.usernamePasswordDialogController = (UsernamePasswordDialogController)this.startDialog(this.showAsModal, "USERNAME_AND_PASSWORD_ENTRY_DIALOG", null, UsernamePasswordDialogView.class, UsernamePasswordDialogController.class);
        this.setInformativeTextInEntryField();
        this.usernamePasswordDialogController.addActionListener((ActionListener)this.dialogListener);
    }

    private void setInformativeTextInEntryField() {
        String localfileName = DetailedInformation.getDetailedInformationLocalFileName();
        String localfilePathAndName = DetailedInformation.getDetailedInformationLocalFilePathAndName();
        this.usernamePasswordDialogController.setUpperInformativeText(this.getString("INFORMATIVE_TEXT_USERNAME_PASSWORD_ENTRY_FIELD_UPPER", null));
        Object[] args = new Object[]{localfileName, localfilePathAndName};
        this.usernamePasswordDialogController.setLowerInformativeText(this.getString("INFORMATIVE_TEXT_USERNAME_PASSWORD_ENTRY_FIELD_LOWER", args));
    }

    protected boolean close() {
        return true;
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private void showPropertiesWindowForTheCorruptedUP(int linkNumber) {
        boolean UP_Found = false;
        String productNumber = "";
        String productRevision = "";
        MOProxy swManagementMo = new MOProxy("ManagedElement=1,SwManagement=1");
        MOProxy[] moPxyArray = null;
        try {
            moPxyArray = swManagementMo.getChildren(1, "UpgradePackage", "");
        }
        catch (Exception e) {
            Log.logError((String)"Error in getChildren", (Throwable)e);
            this.reportException(e, e.toString(), null);
        }
        String upgradePackageIdentifer = this.view.getUP_productNumberAndProductRevision(linkNumber);
        if (moPxyArray != null) {
            for (int i = 0; i < moPxyArray.length; ++i) {
                try {
                    Struct administrativeData = (Struct)moPxyArray[i].getAttribute("administrativeData");
                    if (administrativeData == null) continue;
                    productNumber = administrativeData.getNameValue("productNumber").getValue().toString();
                    productRevision = administrativeData.getNameValue("productRevision").getValue().toString();
                    String identifier = productNumber + productRevision;
                    if (identifier == null || !identifier.equals(upgradePackageIdentifer)) continue;
                    Object[][] parameters = new Object[][]{{new String("LDNLIST"), moPxyArray[i].getDN()}};
                    this.showUP_propertieswindow(parameters);
                    UP_Found = true;
                    break;
                }
                catch (Exception exception) {
                    Log.logError((String)"Error getting attribute", (Throwable)exception);
                    this.reportException(exception, exception.toString(), null);
                }
            }
        }
        if (!UP_Found) {
            ErrorDialog error = ErrorDialog.create((Component)((Object)this.view), (String)this.getString("CORRUPTED_UP_NOT_FOUND_MESSAGE", null), null, null, null, null, null);
            error.setTitle(this.getString("CORRUPTED_UP_NOT_FOUND_TITLE", null));
            error.setModal(false);
            error.setVisible(true);
        }
    }

    private int getLinkNumber(String linkAsString) {
        int linkNumber;
        int index = linkAsString.indexOf("_");
        String linkAsStringNumber = linkAsString.substring(index + 1);
        try {
            linkNumber = Integer.parseInt(linkAsStringNumber);
        }
        catch (NumberFormatException exception) {
            linkNumber = -1;
            Log.logError((String)"Error getting getLinkNumber", (Throwable)exception);
            this.reportException(exception, exception.toString(), null);
        }
        return linkNumber;
    }

    private void showUP_propertieswindow(Object[][] parameters) {
        MainWindowController mainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
        mainWindowController.startApplication("se.ericsson.cello.emas.sm.applications.UpgradePackageApplication", parameters, true);
    }

    private void removeListeners() {
        this.view.removeHyperlinkListenerForPathToDetailedInfo(this.hyperlinkListenerForPathToDetailedInfo);
        this.view.removeHyperlinkListenerForCorruptedUpgradePackagesTabb(this.hyperlinkListenerForCorruptedUpgradePackagesTabb);
    }

    private class DialogListener
    implements ActionListener {
        private DialogListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("OK_PRESSED".equals(event.getActionCommand())) {
                String username = ((RestoreSlide3VerificationResultsWizardController)RestoreSlide3VerificationResultsWizardController.this).usernamePasswordDialogController.username;
                String password = ((RestoreSlide3VerificationResultsWizardController)RestoreSlide3VerificationResultsWizardController.this).usernamePasswordDialogController.password;
                String ipAddress = RestoreConfirm.get_node_IP_address();
                try {
                    String pathInLocalDiskToDetailedInformationFile = null;
                    pathInLocalDiskToDetailedInformationFile = DetailedInformation.downloadDetailedInformationFileFromNodesFtpServer(username, password, ipAddress);
                    RestoreSlide3VerificationResultsWizardController.this.usernamePasswordDialogController.stopDialog();
                    DetailedInformation.showDetailedInformationFile(pathInLocalDiskToDetailedInformationFile);
                }
                catch (IOException e) {
                    ErrorDialog errorDialog = ErrorDialog.create((Component)((Object)RestoreSlide3VerificationResultsWizardController.this.view), (String)e.toString(), null, null, null, null, (String)RestoreSlide3VerificationResultsWizardController.this.getString("ERROR_FTP_CONNECTION_TO_NODES_FTP_SERVER", null));
                    errorDialog.setModal(RestoreSlide3VerificationResultsWizardController.this.showAsModal);
                    errorDialog.setVisible(true);
                }
            } else if ("CANCEL_PRESSED".equals(event.getActionCommand())) {
                RestoreSlide3VerificationResultsWizardController.this.usernamePasswordDialogController.stopDialog();
            }
        }
    }

    private class MyHyperlinkListener
    implements HyperlinkListener {
        private MyHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (e.getDescription().equals("pathToDetailedInfoHyperlink")) {
                    RestoreSlide3VerificationResultsWizardController.this.askForUsernameAndPassword();
                } else if (e.getDescription().startsWith("openUPpropertiesWindow_")) {
                    int linkNumber = RestoreSlide3VerificationResultsWizardController.this.getLinkNumber(e.getDescription());
                    RestoreSlide3VerificationResultsWizardController.this.showPropertiesWindowForTheCorruptedUP(linkNumber);
                } else if (e.getDescription().startsWith("openUPpropertiesWindowCreate")) {
                    RestoreSlide3VerificationResultsWizardController.this.showUP_propertieswindow(null);
                }
            }
        }
    }
}

