/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.util.Properties;
import se.ericsson.cello.emas.sm.services.SlotNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.mgr.cellomom.RPUNormalisationMode;
import se.ericsson.cello.support.mgr.cellomom.RPUOperationalMode;
import se.ericsson.cello.support.mgr.cellomom.RPUReplicationMode;
import se.ericsson.cello.support.mgr.cellomom.RPUSwitchOverMode;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class ReliableProgramElement
extends EmasViewElement {
    private String name;
    private String userLabel;
    private String rpLabel;
    private String rpuId;
    private String activeSlot = "";
    private String passiveSlot = "";
    private RPUOperationalMode operationalMode = RPUOperationalMode.UNAVAILABLE;
    private RPUNormalisationMode normalisationMode = RPUNormalisationMode.MANUAL;
    private RPUReplicationMode replicationMode = RPUReplicationMode.APPL_CONTROLLED;
    private RPUSwitchOverMode switchOverMode = RPUSwitchOverMode.AT_PIU_FAULT;
    private MOProxy rpUniter;
    private boolean isReserved = false;

    public ReliableProgramElement(MOComposite aMoc, Properties aProperties, EmasViewElementCreator aCreator) throws CSException {
        super(aMoc, aProperties, aCreator);
        this.rpUniter = aMoc.getMO("ReliableProgramUniter");
        this.name = this.rpUniter.getLastRDN();
        this.refreshData();
    }

    public String getName() {
        return this.name;
    }

    public Object getAttributeValue(String aName) {
        Object value = null;
        if (aName.equals("ATTR_RPLABEL")) {
            value = this.rpLabel;
        } else if (aName.equals("ATTR_RPLABEL_ID")) {
            try {
                value = new Integer(this.rpuId);
            }
            catch (NumberFormatException e) {
                value = this.rpuId;
            }
        } else if (aName.equals("ATTR_ACTIVE_SLOT")) {
            value = this.activeSlot;
        } else if (aName.equals("ATTR_PASSIVE_SLOT")) {
            value = this.passiveSlot;
        } else if (aName.equals("ATTR_OPERATION")) {
            value = this.translate(this.operationalMode.toString());
        } else if (aName.equals("ATTR_NORMALIZATION")) {
            value = this.translate(this.normalisationMode.toString());
        } else if (aName.equals("ATTR_REPLICATION")) {
            value = this.translate(this.replicationMode.toString());
        } else if (aName.equals("ATTR_SWITCH_OVER")) {
            value = this.translate(this.switchOverMode.toString());
        } else if (aName.equals("ATTR_USERLABEL")) {
            value = this.userLabel;
        }
        return value;
    }

    private void refreshData() throws CSException {
        MOProxy[] reservedBy;
        MOProxy slot = null;
        Integer mode = null;
        String[] moAttributes = new String[]{"userLabel", "reliableProgramLabel", "ReliableProgramUniterId", "admActiveSlot", "admPassiveSlot", "operationalMode", "normalisation", "replication", "switchOver", "reservedBy"};
        Object[] moValues = null;
        moValues = this.rpUniter.getAttributes(moAttributes, null);
        AttributeBuffer bufferValues = new AttributeBuffer(moAttributes, moValues);
        this.userLabel = (String)bufferValues.getAttribute("userLabel");
        this.rpLabel = (String)bufferValues.getAttribute("reliableProgramLabel");
        this.rpuId = (String)bufferValues.getAttribute("ReliableProgramUniterId");
        slot = (MOProxy)bufferValues.getAttribute("admActiveSlot");
        if (slot.getDN() != null) {
            this.activeSlot = SlotNameFactory.getSlotName(slot);
        }
        if ((slot = (MOProxy)bufferValues.getAttribute("admPassiveSlot")).getDN() != null) {
            this.passiveSlot = SlotNameFactory.getSlotName(slot);
        }
        if ((mode = (Integer)bufferValues.getAttribute("operationalMode")) != null && mode > 0) {
            this.operationalMode = RPUOperationalMode.get((Object)mode);
        }
        if ((mode = (Integer)bufferValues.getAttribute("normalisation")) != null && mode > 0) {
            this.normalisationMode = RPUNormalisationMode.get((Object)mode);
        }
        if ((mode = (Integer)bufferValues.getAttribute("replication")) != null && mode > 0) {
            this.replicationMode = RPUReplicationMode.get((Object)mode);
        }
        if ((mode = (Integer)bufferValues.getAttribute("switchOver")) != null && mode > 0) {
            this.switchOverMode = RPUSwitchOverMode.get((Object)mode);
        }
        this.isReserved = (reservedBy = (MOProxy[])bufferValues.getAttribute("reservedBy")).length > 0;
    }

    public void refresh() {
        try {
            this.refreshData();
        }
        catch (CSException e) {
            Log.logError((String)"refresh failed", (Throwable)e);
        }
    }

    public void attributesChanged(MOProxy aMO, NameValue[] nameValue) {
        try {
            for (int i = 0; i < nameValue.length; ++i) {
                Integer mode;
                MOProxy slot;
                if (nameValue[i].name.equals("admActiveSlot")) {
                    slot = (MOProxy)nameValue[i].value;
                    if (slot == null || slot.getDN() == null || slot.getDN().length() <= 0) continue;
                    this.activeSlot = SlotNameFactory.getSlotName(slot);
                    continue;
                }
                if (nameValue[i].name.equals("admPassiveSlot")) {
                    slot = (MOProxy)nameValue[i].value;
                    this.passiveSlot = slot != null && slot.getDN() != null && slot.getDN().length() > 0 ? SlotNameFactory.getSlotName(slot) : "";
                    this.refresh();
                    continue;
                }
                if (nameValue[i].name.equals("normalisation")) {
                    mode = (Integer)nameValue[i].value;
                    if (mode == null || mode <= 0) continue;
                    this.normalisationMode = RPUNormalisationMode.get((Object)mode);
                    this.fireViewElementUpdated();
                    continue;
                }
                if (nameValue[i].name.equals("replication")) {
                    mode = (Integer)nameValue[i].value;
                    if (mode == null || mode <= 0) continue;
                    this.replicationMode = RPUReplicationMode.get((Object)mode);
                    this.fireViewElementUpdated();
                    continue;
                }
                if (nameValue[i].name.equals("switchOver")) {
                    mode = (Integer)nameValue[i].value;
                    if (mode == null || mode <= 0) continue;
                    this.switchOverMode = RPUSwitchOverMode.get((Object)mode);
                    this.fireViewElementUpdated();
                    continue;
                }
                if (!nameValue[i].name.equals("userLabel")) continue;
                this.userLabel = (String)nameValue[i].value;
                this.fireViewElementUpdated();
            }
        }
        catch (Exception e) {
            Log.logError((String)"update failed", (Throwable)e);
        }
    }

    public boolean isReserved() {
        return this.isReserved;
    }
}

