/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.FileWriterUtil;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement.AbstractDtdInfo;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement.AbstractXmlElement;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement.XmlElementFactory;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public abstract class AbstractXmlManager {
    private String fileName;
    private Rbs rbs;
    private StringBuffer xmlBuffer;
    private String[] configurationCheckReport;
    private static final String NEWLINE = "\n\r";

    AbstractXmlManager(Rbs rbs, String string, String[] stringArray) {
        this.rbs = rbs;
        this.fileName = string;
        this.xmlBuffer = new StringBuffer();
        this.configurationCheckReport = stringArray;
    }

    public abstract void createXmlFile() throws BemException;

    public abstract InputStream createInputStreamWithXmlData() throws BemException;

    protected void createXmlFile(AbstractDtdInfo abstractDtdInfo) throws BemException {
        this.createXmlData(abstractDtdInfo);
        FileWriterUtil.writeFile(this.fileName, this.xmlBuffer);
    }

    protected InputStream createInputStreamWithXmlData(AbstractDtdInfo abstractDtdInfo) throws BemException {
        StringBuffer stringBuffer = this.createXmlData(abstractDtdInfo);
        byte[] byArray = stringBuffer.toString().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    private StringBuffer createXmlData(AbstractDtdInfo abstractDtdInfo) throws BemException {
        int n;
        String[] stringArray = abstractDtdInfo.getHeaderLines();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.xmlBuffer.append(stringArray[n] + NEWLINE);
            }
        }
        this.xmlBuffer.append(NEWLINE);
        if (this.configurationCheckReport != null) {
            for (n = 0; n < this.configurationCheckReport.length; ++n) {
                this.xmlBuffer.append("<!--   " + this.configurationCheckReport[n] + "   -->" + NEWLINE);
            }
            this.xmlBuffer.append(NEWLINE);
        }
        String string = abstractDtdInfo.getRoot();
        AbstractXmlElement abstractXmlElement = XmlElementFactory.createRootElement(string, abstractDtdInfo, this.rbs);
        String string2 = abstractXmlElement.printElement();
        this.xmlBuffer.append(string2);
        return this.xmlBuffer;
    }
}

